package com.payufin.mobilemsg.configurables

import androidx.annotation.Keep
import com.payufin.mobilemsg.sms.SdkCallback

@Keep
class SdkConfig private constructor(
    val retryCount: Int,
    val regexPattern: String,
    val upperLimit: Int,
    val packetSize: Int,
    val clientEmail: String,
    val accessId: String,
    val sdkCallback: SdkCallback
) {
    @Keep
    class Builder {
        private var retryCount: Int = 3
        private var regexPattern: String = "^(?!(.*\\d){10,}).*\$"
        private var upperLimit: Int = 190
        private var packetSize: Int = 50
        private lateinit var clientEmail : String
        private lateinit var accessId : String
        private lateinit var sdkCallback: SdkCallback

        fun setRetryCount(retryCount: Int) = apply { this.retryCount = retryCount }
        fun setRegexPattern(regexPattern: String) = apply { this.regexPattern = regexPattern }
        fun setUpperLimit(upperLimit: Int) = apply { this.upperLimit = upperLimit }
        fun setPacketSize(packetSize: Int) = apply { this.packetSize = packetSize }
        fun setClientEmail( clientEmail: String ) = apply { this.clientEmail = clientEmail }
        fun setAccessId( accessId: String ) = apply { this.accessId = accessId }
        fun setSdkCallback( sdkCallback : SdkCallback ) = apply {
            this.sdkCallback = sdkCallback
        }

        fun build()  = SdkConfig( retryCount, regexPattern, upperLimit, packetSize, clientEmail,
                                            accessId, sdkCallback )
    }
}