package com.payufin.mobilemsg.network

import android.content.Context
import androidx.annotation.Keep
import com.orhanobut.logger.AndroidLogAdapter
import com.orhanobut.logger.Logger
import com.payufin.mobilemsg.configurables.SdkConfig
import com.payufin.mobilemsg.helper.Callback
import com.payufin.mobilemsg.helper.Utils
import com.payufin.mobilemsg.models.AuthRequestData
import com.payufin.mobilemsg.sms.ReadSms
import com.payufin.mobilemsg.sms.checkpoint
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.SupervisorJob
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext


/*
This is the entrypoint for SDK
The SDK initialized by the parent app will call the Auth API to authenticate the client
    On successful authentication - SMS permission needs to be checked
    On failure - return signal to parent app that the authentication has failed

 */
@Keep
class SmsManager( private val context: Context, private val config : SdkConfig ) {


    private val coroutineScope = CoroutineScope(Dispatchers.IO + SupervisorJob())

    private lateinit var smsRepository: SmsRepository
    // private lateinit var dataSource: SmsDataSource
    val deviceId = Utils.getAndroidId(context)

    fun init(){
        coroutineScope.launch {
            authenticate()
        }
    }

    private suspend fun authenticate() {

        Logger.addLogAdapter(object : AndroidLogAdapter() {
            override fun isLoggable(priority: Int, tag: String?): Boolean {
                return true
                //return BuildConfig.DEBUG
            }
        })

        checkpoint.setClientDetails( context, config.clientEmail, config.accessId )
        val authRequestData = AuthRequestData( config.clientEmail, config.accessId )

        Logger.d("readSMSSDK : client id - %s", config.clientEmail)
        Logger.d("readSMSSDK : access_key - %s", config.accessId)


        val dataSource   = SmsAPI.getSmsDataSourceInstance(config, context)
        smsRepository    = SmsRepository(context, dataSource, config )

        smsRepository.getAuthToken( authRequestData , object : Callback<Boolean>{
            override suspend fun onSuccess(t: Boolean) {
                // TODO: fix this
                val authToken = checkpoint.getAuthToken(context)
                proceedWithUploadingSms( authToken )
            }

            override suspend fun onFailure(message: String?, code: Int) {
                // callback host application
                withContext(Dispatchers.Main) {
                    config.sdkCallback.onAuthFailure(code, message ?: "", Utils.getAndroidId(context))
                }
            }

        } )
    }

    private suspend fun proceedWithUploadingSms( authToken : String? ){
        // val smsUploadRequest = UploadSMS.getSmsUploadRequest( )
        ReadSms( smsRepository ).checkSmsPermission( context, authToken, config )

    }
}

