package com.payufin.mobilemsg.network

import android.content.Context
import android.util.Log
import com.google.gson.JsonObject
import com.payufin.mobilemsg.configurables.Constants
import com.payufin.mobilemsg.helper.HttpHelper
import com.payufin.mobilemsg.models.AuthRequestData
import com.payufin.mobilemsg.models.AuthResponseData
import com.payufin.mobilemsg.models.SmsBodyData
import com.payufin.mobilemsg.sms.SdkCallback
import com.payufin.mobilemsg.sms.checkpoint
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.delay
import kotlinx.coroutines.withContext
import okhttp3.ResponseBody
import retrofit2.Call
import retrofit2.Response
import java.nio.charset.StandardCharsets
import java.security.MessageDigest

class UploadSMSAPIServiceImpl(
    private val context: Context,
    private var earliestMessageDate : Long,
    private var latestMessageDate : Long,
    private val apiMsgList : List<JsonObject>,
    private val Android_id : String,
    private val apiObj : SmsBodyData,
    private val apiString: String,
    private val parent_callback: SdkCallback
) {

    private var retryCount = 0
    private var authRetryCount = 0
    private val maxRetries = 3
    private var flag = 1
    private val initialBackoffTime = 1000 // Initial backoff time in milliseconds

    private fun shouldRetry(responseCode: Int): Boolean {
        return responseCode == 404 || (responseCode >= 500 && responseCode < 600) || responseCode == 403
    }

    private suspend fun retry(call: Call<ResponseBody>) {
        if (retryCount < maxRetries) {
            retryCount++
            val backoffTime = initialBackoffTime * Math.pow(2.0, (retryCount - 1).toDouble()).toLong()
            delay(backoffTime)
//            Handler(Looper.getMainLooper()).postDelayed({
//                call.clone().execute()
//            }, backoffTime)
            val clonedCall = call.clone()
            val response = clonedCall.execute()
            Log.d("readSMS", "Retrying... Attempt: $retryCount")
            handleResponse(clonedCall, response)

        } else {
            Log.d("readSMS", "Max retries reached. No more attempts.")
        }
    }

    private suspend fun auth_api_retry(call: Call<ResponseBody>) {
        if(authRetryCount < 1) {
            authRetryCount++
            // call the auth api to get the new token
            val(client_email, access_key) = checkpoint.getClientDetails(context)
            val authRequestData = AuthRequestData(client_email, access_key)
            try {

                val response: Response<AuthResponseData> =
                    SmsAPI.retrofitService.clientAuth(authRequestData).execute()

                if (response.isSuccessful) {
                    val AuthToken = "Bearer " + response.body()?.access
                    Log.d("readSMS", "AuthToken : $AuthToken")

                    val upload_timestamp = System.currentTimeMillis().toString()


                    val httpHelper = HttpHelper()
                    val checkSum = httpHelper.bytesToHexString(
                        MessageDigest.getInstance("MD5").digest(
                            (Constants.HEADER_TYPE.HEADER_API_VERSION_VALUE + AuthToken + apiString +
                                    upload_timestamp).toByteArray(
                                StandardCharsets.UTF_8
                            )
                        )
                    )

                    var newCall = SmsAPI.retrofitService.uploadSMS(
                        Android_id,
                        upload_timestamp,
                        checkSum,
                        AuthToken,
                        apiObj
                    )
                    var newresponse = newCall.execute()
                    handleResponse(newCall, newresponse)

                }

            else{
                Log.d("readSMS", "client id : $client_email")
                Log.d("readSMS", "Error in API call: ${response.code()}")

            }
        }catch (e: Exception) {
                Log.d("readSMS", "Failure in API call: $e")
            }

        }
        // call the upload sms api with the new token for the failed packet
        else {
            Log.d("readSMS", "Max retries reached. No more attempts.")
        }
    }



    suspend fun handleResponse(call: Call<ResponseBody>, response: Response<ResponseBody>) {
        if (response.isSuccessful) {

            var (lastSyncedLatestTimestamp, lastSyncedEarliestTimestamp) = checkpoint.getLastSyncedIndex(context)
            Log.d("readSMS", "Last Synced Latest Message Checkpoint Epoch Timestamp : $lastSyncedLatestTimestamp")
            Log.d("readSMS", "Last Synced Earliest Message Checkpoint Epoch Timestamp : $lastSyncedEarliestTimestamp")


            if(apiMsgList.isNotEmpty() && (lastSyncedEarliestTimestamp.toInt() == -1 || apiMsgList.last().get("date").asLong < lastSyncedEarliestTimestamp))
                lastSyncedEarliestTimestamp = apiMsgList.last().get("date").asLong

            if(apiMsgList.isNotEmpty() && (lastSyncedLatestTimestamp.toInt() == -1 || apiMsgList.first().get("date").asLong > lastSyncedLatestTimestamp))
                lastSyncedLatestTimestamp = apiMsgList.first().get("date").asLong

            checkpoint.setLastSyncedIndex(
                context,
                lastSyncedLatestTimestamp,
                lastSyncedEarliestTimestamp
            )


//            if(apiMsgList.isEmpty() && apiObj.sms_permission_available == true) {
//                withContext(Dispatchers.Main) {
//                    parent_callback.smsSyncSuccess("No SMS left to be synced")
//                }
//            }
//            if(apiMsgList.isEmpty() && apiObj.sms_permission_available == false) {
//                withContext(Dispatchers.Main) {
//                    parent_callback.permissionNotAvailable("Permission Not Available")
//                }
//            }



            Log.d("readSMS", "Latest Message Checkpoint: $latestMessageDate")
            Log.d("readSMS", "Earliest Message Checkpoint: $earliestMessageDate")


            val responseBody = response.code()
            Log.d("readSMS", "Response: $responseBody")

            Log.d("readSMS", "SMS uploaded successfully!")


        } else {

            Log.d("readSMS", "response code - ${response.code()} - ${response.message()}")
            if (shouldRetry(response.code())) {
                retry(call)
                if(flag == 1 && retryCount >= maxRetries)
                {
                    flag = 0
                    withContext(Dispatchers.Main){
//                    parent_callback.onUploadFailure(response.code(),
//                        "SMS failure for packet : ${response.errorBody()?.string()}")
                   }
                }
            }
            else if (response.code() == 401){
                auth_api_retry(call)
            }
            else {
                Log.d("readSMS", "Failed to upload SMS: ${response.code()} - ${response.message()}")
//                parent_callback.onUploadFailure(response.code(),
//                    "SMS failure for packet : ${response.errorBody()?.string()}")
          }

        }
    }
}
