/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core;

import in.specmatic.conversions.IncludedSpecification;
import in.specmatic.conversions.OpenApiSpecification;
import in.specmatic.conversions.WsdlSpecificationKt;
import in.specmatic.core.AnchorFile;
import in.specmatic.core.ContractCache;
import in.specmatic.core.ContractFileWithExports;
import in.specmatic.core.ExampleDeclarations;
import in.specmatic.core.Feature;
import in.specmatic.core.FeatureKt;
import in.specmatic.core.GherkinClause;
import in.specmatic.core.GherkinClauseKt;
import in.specmatic.core.GherkinScenario;
import in.specmatic.core.HttpHeadersPattern;
import in.specmatic.core.HttpRequestKt;
import in.specmatic.core.HttpRequestPattern;
import in.specmatic.core.HttpResponseKt;
import in.specmatic.core.HttpResponsePattern;
import in.specmatic.core.MultiPartContentPattern;
import in.specmatic.core.MultiPartFilePattern;
import in.specmatic.core.MultiPartFormDataPattern;
import in.specmatic.core.NamedStub;
import in.specmatic.core.OutputKt;
import in.specmatic.core.References;
import in.specmatic.core.Resolver;
import in.specmatic.core.Scenario;
import in.specmatic.core.ScenarioInfo;
import in.specmatic.core.SpecmaticConfigKt;
import in.specmatic.core.StepInfo;
import in.specmatic.core.URLMatcher;
import in.specmatic.core.URLMatcherKt;
import in.specmatic.core.pattern.AnyPattern;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.pattern.DeferredPattern;
import in.specmatic.core.pattern.ExactValuePattern;
import in.specmatic.core.pattern.Examples;
import in.specmatic.core.pattern.GrammarKt;
import in.specmatic.core.pattern.KafkaMessagePattern;
import in.specmatic.core.pattern.NumberPattern;
import in.specmatic.core.pattern.Pattern;
import in.specmatic.core.pattern.StringPattern;
import in.specmatic.core.pattern.TabularPatternKt;
import in.specmatic.core.utilities.JSONSerialisationKt;
import in.specmatic.core.value.BooleanValueKt;
import in.specmatic.core.value.KafkaMessage;
import in.specmatic.core.value.KafkaMessageKt;
import in.specmatic.core.value.NumberValue;
import in.specmatic.core.value.ScalarValue;
import in.specmatic.core.value.StringValue;
import in.specmatic.core.value.UseExampleDeclarations;
import in.specmatic.core.value.Value;
import io.cucumber.gherkin.GherkinDocumentBuilder;
import io.cucumber.gherkin.Parser;
import io.cucumber.messages.IdGenerator;
import io.cucumber.messages.types.DataTable;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TableCell;
import io.cucumber.messages.types.TableRow;
import io.cucumber.messages.types.Tag;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u00d2\u0001\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0001H\u0002\u001a\u0018\u0010\u000e\u001a\u0004\u0018\u00010\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0001H\u0002\u001a\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0001H\u0002\u001a\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013\u001a$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013\u001a,\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0002H\u0000\u001a$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00012\u0006\u0010\u001a\u001a\u00020\u0002H\u0000\u001aT\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00012\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00012\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00012\b\u0010\"\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001a\u001a\u00020\u00022\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010$0\u0001H\u0002\u001a2\u0010%\u001a$\u0012\f\u0012\n (*\u0004\u0018\u00010'0' (*\u0010\u0012\f\u0012\n (*\u0004\u0018\u00010'0'0\u00010&2\u0006\u0010)\u001a\u00020\u000bH\u0002\u001a\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-\u001a\u000e\u0010*\u001a\u00020+2\u0006\u0010.\u001a\u00020\u0002\u001a\u001a\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002000\u00162\u0006\u00101\u001a\u000202\u001a\u0012\u00103\u001a\u0004\u0018\u00010\u00192\u0006\u00104\u001a\u00020\u0002H\u0000\u001a\u0016\u00103\u001a\u00020\u00192\u0006\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u00020\u0002\u001a\u0018\u00106\u001a\u00020+2\u0006\u00104\u001a\u00020\u00022\b\b\u0002\u00105\u001a\u00020\u0002\u001a<\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u000200082\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u000200082\u0006\u0010:\u001a\u00020\u00022\f\u0010;\u001a\b\u0012\u0004\u0012\u00020'0\u0001\u001a\u0016\u0010<\u001a\u00020=2\u0006\u0010:\u001a\u00020\u00022\u0006\u0010>\u001a\u00020=\u001a.\u0010?\u001a\u00020\u001c2\u0006\u0010@\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00012\u0006\u0010A\u001a\u00020BH\u0002\u001a\"\u0010C\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00012\u0006\u0010\u001a\u001a\u00020\u0002\u001a\u001c\u0010D\u001a\b\u0012\u0004\u0012\u00020\r0\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0001H\u0002\u001aB\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002082\u0006\u0010:\u001a\u00020\u00022\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002082\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000208\u001a\u001a\u0010H\u001a\u00020\u00022\b\u0010I\u001a\u0004\u0018\u00010\u00022\u0006\u00101\u001a\u000202H\u0000\u001a\"\u0010J\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020K0\u0001\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010L\u001a\u00020\tH\u0002\u001a\u000e\u0010M\u001a\u00020N2\u0006\u00101\u001a\u000202\u001a0\u0010O\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020P082\u0006\u0010:\u001a\u00020\u00022\u0012\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020P08H\u0002\u001a\u0010\u0010R\u001a\u00020P2\u0006\u0010S\u001a\u00020\u0002H\u0002\u001a\u001c\u0010T\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020P0\u00162\u0006\u0010:\u001a\u00020\u0002H\u0002\u001a\u0016\u0010U\u001a\u00020V2\u0006\u00101\u001a\u0002022\u0006\u0010W\u001a\u00020\u0002\u001a\u000e\u0010X\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t\u001a\u001c\u0010X\u001a\u00020\u00022\u0006\u0010Y\u001a\u00020\u00022\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\t0\u0001\u001aH\u0010[\u001a\u0004\u0018\u00010$2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00012\u001a\u0010\\\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u000b0]2\u0012\u0010^\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020$0]H\u0002\u001a\u000e\u0010_\u001a\u0002002\u0006\u00101\u001a\u000202\u001a*\u0010`\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002000\u00162\u0006\u00101\u001a\u0002022\f\u0010;\u001a\b\u0012\u0004\u0012\u00020'0\u0001H\u0002\u001a\"\u0010a\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002000\u00162\u0006\u0010b\u001a\u00020\u00022\u0006\u0010c\u001a\u00020\u0002\u001a\u001c\u0010d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u00012\u0006\u0010:\u001a\u00020\u0002H\u0002\u001aJ\u0010e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020f082\u0006\u0010:\u001a\u00020\u00022\u0012\u0010g\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020f082\u0012\u0010h\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020f082\u0006\u0010\u001a\u001a\u00020\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006i"}, d2={"HTTP_METHODS", "", "", "contractCache", "Lin/specmatic/core/ContractCache;", "addCommentsToExamples", "Lin/specmatic/core/ExampleDeclarations;", "examples", "stub", "Lin/specmatic/core/NamedStub;", "backgroundOpenApi", "Lio/cucumber/messages/types/Step;", "featureChildren", "Lio/cucumber/messages/types/FeatureChild;", "backgroundScenario", "backgroundWsdl", "breakIntoPartsMaxLength", "whole", "partCount", "", "separator", "lex", "Lkotlin/Pair;", "Lin/specmatic/core/Scenario;", "gherkinDocument", "Lio/cucumber/messages/types/GherkinDocument;", "filePath", "lexScenario", "Lin/specmatic/core/ScenarioInfo;", "steps", "examplesList", "Lio/cucumber/messages/types/Examples;", "featureTags", "Lio/cucumber/messages/types/Tag;", "backgroundScenarioInfo", "includedSpecifications", "Lin/specmatic/conversions/IncludedSpecification;", "listOfDatatableRows", "", "Lio/cucumber/messages/types/TableRow;", "kotlin.jvm.PlatformType", "it", "parseContractFileToFeature", "Lin/specmatic/core/Feature;", "file", "Ljava/io/File;", "contractPath", "parseEnum", "Lin/specmatic/core/pattern/Pattern;", "step", "Lin/specmatic/core/StepInfo;", "parseGherkinString", "gherkinData", "sourceFilePath", "parseGherkinStringToFeature", "plusFormFields", "", "formFields", "rest", "rowsList", "plusHeaderPattern", "Lin/specmatic/core/HttpHeadersPattern;", "headersPattern", "scenarioInfoWithExamples", "parsedScenarioInfo", "ignoreFailure", "", "scenarioInfos", "scenarios", "setters", "backgroundSetters", "scenarioSetters", "stringOrDocString", "string", "stubToClauses", "Lin/specmatic/core/GherkinClause;", "namedStub", "toAsyncMessage", "Lin/specmatic/core/pattern/KafkaMessagePattern;", "toFacts", "Lin/specmatic/core/value/Value;", "fixtures", "toFixtureData", "rawData", "toFixtureInfo", "toFormDataPart", "Lin/specmatic/core/MultiPartFormDataPattern;", "contractFilePath", "toGherkinFeature", "featureName", "stubs", "toIncludedSpecification", "selector", "Lkotlin/Function1;", "creator", "toPattern", "toPatternInfo", "toPatternPair", "key", "value", "toQueryParams", "values", "Lin/specmatic/core/References;", "scenarioReferences", "backgroundReferences", "core"})
public final class FeatureKt {
    @NotNull
    private static final ContractCache contractCache = new ContractCache(null, 1, null);
    @NotNull
    private static final List<String> HTTP_METHODS;

    @NotNull
    public static final Feature parseContractFileToFeature(@NotNull String contractPath) {
        Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
        return FeatureKt.parseContractFileToFeature(new File(contractPath));
    }

    @NotNull
    public static final Feature parseContractFileToFeature(@NotNull File file) {
        Feature feature2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        OutputKt.getInformation().forDebugging("Parsing contract file " + file.getPath() + ", absolute path " + file.getAbsolutePath());
        if (!file.exists()) {
            throw new ContractException("File " + file.getPath() + " does not exist (absolute path " + file.getCanonicalPath() + ')', null, null, null, 14, null);
        }
        String string = FilesKt.getExtension((File)file);
        if (Intrinsics.areEqual((Object)string, (Object)"yaml")) {
            String string2 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
            feature2 = OpenApiSpecification.Companion.fromFile(string2).toFeature();
        } else if (Intrinsics.areEqual((Object)string, (Object)"wsdl")) {
            String string3 = FilesKt.readText$default((File)file, null, (int)1, null);
            String string4 = file.getCanonicalPath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"file.canonicalPath");
            feature2 = WsdlSpecificationKt.wsdlContentToFeature(string3, string4);
        } else if (SpecmaticConfigKt.getCONTRACT_EXTENSIONS().contains(string)) {
            String string5 = FilesKt.readText$default((File)file, null, (int)1, null);
            boolean bl = false;
            String string6 = string5;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string7 = ((Object)StringsKt.trim((CharSequence)string6)).toString();
            string5 = file.getCanonicalPath();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"file.canonicalPath");
            feature2 = FeatureKt.parseGherkinStringToFeature(string7, string5);
        } else {
            throw new ContractException("File extension of " + file.getPath() + " not recognized", null, null, null, 14, null);
        }
        return feature2;
    }

    @NotNull
    public static final Feature parseGherkinStringToFeature(@NotNull String gherkinData, @NotNull String sourceFilePath) {
        Intrinsics.checkNotNullParameter((Object)gherkinData, (String)"gherkinData");
        Intrinsics.checkNotNullParameter((Object)sourceFilePath, (String)"sourceFilePath");
        GherkinDocument gherkinDocument = FeatureKt.parseGherkinString(gherkinData, sourceFilePath);
        Pair<String, List<Scenario>> pair = FeatureKt.lex(gherkinDocument, sourceFilePath);
        String name = (String)pair.component1();
        List scenarios = (List)pair.component2();
        return new Feature(scenarios, null, name, null, null, sourceFilePath, 26, null);
    }

    public static /* synthetic */ Feature parseGherkinStringToFeature$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return FeatureKt.parseGherkinStringToFeature(string, string2);
    }

    private static final Pair<String, Value> toFixtureInfo(String rest2) {
        String string = rest2;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        List<String> fixtureTokens = FeatureKt.breakIntoPartsMaxLength(((Object)StringsKt.trim((CharSequence)string2)).toString(), 2);
        if (fixtureTokens.size() != 2) {
            throw new ContractException(Intrinsics.stringPlus((String)"Couldn't parse fixture data: ", (Object)rest2), null, null, null, 14, null);
        }
        return new Pair((Object)fixtureTokens.get(0), (Object)FeatureKt.toFixtureData(fixtureTokens.get(1)));
    }

    private static final Value toFixtureData(String rawData) {
        return GrammarKt.parsedJSON(rawData);
    }

    @NotNull
    public static final String stringOrDocString(@Nullable String string, @NotNull StepInfo step) {
        CharSequence charSequence;
        boolean bl;
        String string2;
        String string3;
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        CharSequence charSequence2 = string;
        if (charSequence2 == null) {
            string3 = "";
        } else {
            string2 = charSequence2;
            bl = false;
            String string4 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            string3 = string4 == null ? "" : string4;
        }
        String trimmed = string3;
        charSequence2 = trimmed;
        boolean bl2 = false;
        string2 = charSequence2;
        bl = false;
        if (string2.length() == 0) {
            boolean bl3 = false;
            charSequence = step.getDocString();
        } else {
            charSequence = charSequence2;
        }
        return charSequence;
    }

    private static final Pair<String, Pattern> toPatternInfo(StepInfo step, List<? extends TableRow> rowsList) {
        List<String> tokens = FeatureKt.breakIntoPartsMaxLength(step.getRest(), 2);
        String patternName = GrammarKt.withPatternDelimiters(tokens.get(0));
        String patternDefinition = FeatureKt.stringOrDocString((String)CollectionsKt.getOrNull(tokens, (int)1), step);
        CharSequence charSequence = patternDefinition;
        boolean bl = false;
        Pattern pattern2 = charSequence.length() == 0 ? (Pattern)TabularPatternKt.rowsToTabularPattern(rowsList, patternName) : GrammarKt.parsedPattern$default(patternDefinition, null, patternName, 2, null);
        return new Pair((Object)patternName, (Object)pattern2);
    }

    private static final Map<String, Value> toFacts(String rest2, Map<String, ? extends Value> fixtures) {
        Map map;
        try {
            map = JSONSerialisationKt.jsonStringToValueMap(rest2);
        }
        catch (Exception notValidJSON) {
            StringValue stringValue;
            List<String> factTokens = FeatureKt.breakIntoPartsMaxLength(rest2, 2);
            String name = factTokens.get(0);
            String string = (String)CollectionsKt.getOrNull(factTokens, (int)1);
            if (string == null) {
                stringValue = null;
            } else {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                stringValue = new StringValue(it);
            }
            StringValue stringValue2 = stringValue;
            Value data = stringValue2 == null ? fixtures.getOrDefault(name, BooleanValueKt.getTrue()) : (Value)stringValue2;
            map = MapsKt.mapOf((Pair)TuplesKt.to((Object)name, (Object)data));
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private static final ScenarioInfo lexScenario(List<? extends Step> steps, List<? extends io.cucumber.messages.types.Examples> examplesList, List<? extends Tag> featureTags, ScenarioInfo backgroundScenarioInfo, String filePath, List<? extends IncludedSpecification> includedSpecifications) {
        ScenarioInfo scenarioInfo;
        boolean ignoreFailure2;
        void $this$mapTo$iv$iv;
        boolean bl;
        Object object;
        Object it;
        Object object2;
        void $this$fold$iv;
        StepInfo it2;
        ScenarioInfo $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Object object3;
        Iterator step;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = steps;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Step step2 = (Step)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            String string = step.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"step.text");
            object3 = new StepInfo(string, FeatureKt.listOfDatatableRows((Step)step), (Step)step);
            collection.add(object3);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot22 = false;
        $this$mapTo$iv$iv2 = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            it2 = (StepInfo)element$iv$iv;
            boolean bl3 = false;
            if (it2.isEmpty()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredSteps = (List)destination$iv$iv;
        Iterable $i$f$filterNot22 = filteredSteps;
        $this$filterNotTo$iv$iv = backgroundScenarioInfo;
        ScenarioInfo initial$iv = $this$filterNotTo$iv$iv == null ? new ScenarioInfo(null, null, null, null, null, null, null, null, false, null, null, 2047, null) : $this$filterNotTo$iv$iv;
        boolean $i$f$fold = false;
        Object accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            Object object4;
            Map<String, String> map;
            it2 = (StepInfo)element$iv;
            ScenarioInfo scenarioInfo2 = accumulator$iv;
            boolean bl4 = false;
            String string = ((StepInfo)((Object)step)).getKeyword();
            if (HTTP_METHODS.contains(string)) {
                Object object5;
                object2 = (String)CollectionsKt.getOrNull(((StepInfo)((Object)step)).getWords(), (int)1);
                if (object2 == null) {
                    object5 = null;
                } else {
                    String string2 = object2;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    it = string2;
                    boolean bl7 = false;
                    try {
                        object = URI.create(((StepInfo)((Object)step)).getRest());
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(step.rest)");
                        object = URLMatcherKt.toURLMatcherWithOptionalQueryParams((URI)object);
                    }
                    catch (Throwable e) {
                        throw new Exception("Could not parse the contract URL \"" + ((StepInfo)((Object)step)).getRest() + "\" in scenario \"" + scenarioInfo2.getScenarioName() + '\"', e);
                    }
                    Object urlMatcher = object;
                    HttpRequestPattern httpRequestPattern = scenarioInfo2.getHttpRequestPattern();
                    object = ((StepInfo)((Object)step)).getKeyword();
                    bl = false;
                    Object object6 = object;
                    if (object6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = ((String)object6).toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
                    object5 = ScenarioInfo.copy$default(scenarioInfo2, null, HttpRequestPattern.copy$default(httpRequestPattern, null, (URLMatcher)urlMatcher, string3, null, null, null, 57, null), null, null, null, null, null, null, false, null, null, 2045, null);
                }
                map = object5;
                if (map == null) {
                    throw new ContractException("Line " + ((StepInfo)((Object)step)).getLine() + ": " + step + ".text", null, null, null, 14, null);
                }
                object4 = map;
            } else if (Intrinsics.areEqual((Object)string, (Object)"REQUEST-HEADER")) {
                object4 = ScenarioInfo.copy$default(scenarioInfo2, null, HttpRequestPattern.copy$default(scenarioInfo2.getHttpRequestPattern(), FeatureKt.plusHeaderPattern(((StepInfo)((Object)step)).getRest(), scenarioInfo2.getHttpRequestPattern().getHeadersPattern()), null, null, null, null, null, 62, null), null, null, null, null, null, null, false, null, null, 2045, null);
            } else if (Intrinsics.areEqual((Object)string, (Object)"RESPONSE-HEADER")) {
                object4 = ScenarioInfo.copy$default(scenarioInfo2, null, null, HttpResponsePattern.copy$default(scenarioInfo2.getHttpResponsePattern(), FeatureKt.plusHeaderPattern(((StepInfo)((Object)step)).getRest(), scenarioInfo2.getHttpResponsePattern().getHeadersPattern()), 0, null, 6, null), null, null, null, null, null, false, null, null, 2043, null);
            } else if (Intrinsics.areEqual((Object)string, (Object)"STATUS")) {
                HttpResponsePattern httpResponsePattern = scenarioInfo2.getHttpResponsePattern();
                map = Integer.valueOf(((StepInfo)((Object)step)).getRest());
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"valueOf(\n               \u2026                        )");
                object4 = ScenarioInfo.copy$default(scenarioInfo2, null, null, HttpResponsePattern.copy$default(httpResponsePattern, null, ((Number)((Object)map)).intValue(), null, 5, null), null, null, null, null, null, false, null, null, 2043, null);
            } else if (Intrinsics.areEqual((Object)string, (Object)"REQUEST-BODY")) {
                object4 = ScenarioInfo.copy$default(scenarioInfo2, null, HttpRequestPattern.copy$default(scenarioInfo2.getHttpRequestPattern(), null, null, null, FeatureKt.toPattern(step), null, null, 55, null), null, null, null, null, null, null, false, null, null, 2045, null);
            } else if (Intrinsics.areEqual((Object)string, (Object)"RESPONSE-BODY")) {
                object4 = ScenarioInfo.copy$default(scenarioInfo2, null, null, scenarioInfo2.getHttpResponsePattern().bodyPattern(FeatureKt.toPattern(step)), null, null, null, null, null, false, null, null, 2043, null);
            } else if (Intrinsics.areEqual((Object)string, (Object)"FACT")) {
                object4 = ScenarioInfo.copy$default(scenarioInfo2, null, null, null, MapsKt.plus(scenarioInfo2.getExpectedServerState(), FeatureKt.toFacts(((StepInfo)((Object)step)).getRest(), scenarioInfo2.getFixtures())), null, null, null, null, false, null, null, 2039, null);
            } else if ((Intrinsics.areEqual((Object)string, (Object)"TYPE") ? true : Intrinsics.areEqual((Object)string, (Object)"PATTERN")) ? true : Intrinsics.areEqual((Object)string, (Object)"JSON")) {
                object4 = ScenarioInfo.copy$default(scenarioInfo2, null, null, null, null, MapsKt.plus(scenarioInfo2.getPatterns(), FeatureKt.toPatternInfo(step, ((StepInfo)((Object)step)).getRowsList())), null, null, null, false, null, null, 2031, null);
            } else if (Intrinsics.areEqual((Object)string, (Object)"ENUM")) {
                object4 = ScenarioInfo.copy$default(scenarioInfo2, null, null, null, null, MapsKt.plus(scenarioInfo2.getPatterns(), FeatureKt.parseEnum(step)), null, null, null, false, null, null, 2031, null);
            } else if (Intrinsics.areEqual((Object)string, (Object)"FIXTURE")) {
                object4 = ScenarioInfo.copy$default(scenarioInfo2, null, null, null, null, null, MapsKt.plus(scenarioInfo2.getFixtures(), FeatureKt.toFixtureInfo(((StepInfo)((Object)step)).getRest())), null, null, false, null, null, 2015, null);
            } else if (Intrinsics.areEqual((Object)string, (Object)"FORM-FIELD")) {
                object4 = ScenarioInfo.copy$default(scenarioInfo2, null, HttpRequestPattern.copy$default(scenarioInfo2.getHttpRequestPattern(), null, null, null, null, FeatureKt.plusFormFields(scenarioInfo2.getHttpRequestPattern().getFormFieldsPattern(), ((StepInfo)((Object)step)).getRest(), ((StepInfo)((Object)step)).getRowsList()), null, 47, null), null, null, null, null, null, null, false, null, null, 2045, null);
            } else if (Intrinsics.areEqual((Object)string, (Object)"REQUEST-PART")) {
                object4 = ScenarioInfo.copy$default(scenarioInfo2, null, HttpRequestPattern.copy$default(scenarioInfo2.getHttpRequestPattern(), null, null, null, null, null, CollectionsKt.plus((Collection)scenarioInfo2.getHttpRequestPattern().getMultiPartFormDataPattern(), (Object)FeatureKt.toFormDataPart(step, filePath)), 31, null), null, null, null, null, null, null, false, null, null, 2045, null);
            } else if (Intrinsics.areEqual((Object)string, (Object)"KAFKA-MESSAGE")) {
                object4 = ScenarioInfo.copy$default(scenarioInfo2, null, null, null, null, null, null, null, FeatureKt.toAsyncMessage(step), false, null, null, 1919, null);
            } else if (Intrinsics.areEqual((Object)string, (Object)"VALUE")) {
                object2 = backgroundScenarioInfo;
                map = object2 == null ? null : ((ScenarioInfo)object2).getReferences();
                object4 = ScenarioInfo.copy$default(scenarioInfo2, null, null, null, null, null, null, null, null, false, FeatureKt.values(((StepInfo)((Object)step)).getRest(), scenarioInfo2.getReferences(), (Map<String, References>)(map == null ? MapsKt.emptyMap() : map), filePath), null, 1535, null);
            } else if (Intrinsics.areEqual((Object)string, (Object)"EXPORT")) {
                object2 = backgroundScenarioInfo;
                map = object2 == null ? null : ((ScenarioInfo)object2).getBindings();
                object4 = ScenarioInfo.copy$default(scenarioInfo2, null, null, null, null, null, null, null, null, false, null, FeatureKt.setters(((StepInfo)((Object)step)).getRest(), map == null ? MapsKt.emptyMap() : map, scenarioInfo2.getBindings()), 1023, null);
            } else {
                object2 = ((StepInfo)((Object)step)).getRaw().getLocation();
                String location = object2 == null ? "" : Intrinsics.stringPlus((String)" at line ", (Object)((StepInfo)((Object)step)).getRaw().getLocation().getLine());
                StringBuilder stringBuilder = new StringBuilder().append("Invalid syntax").append(location).append(": ");
                object2 = ((StepInfo)((Object)step)).getRaw().getKeyword();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"step.raw.keyword");
                boolean bl8 = false;
                throw new ContractException(stringBuilder.append(((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString()).append(' ').append((Object)((StepInfo)((Object)step)).getRaw().getText()).append(" -> keyword \"").append(((StepInfo)((Object)step)).getOriginalKeyword()).append("\" not recognised.").toString(), null, null, null, 14, null);
            }
            accumulator$iv = object4;
        }
        ScenarioInfo parsedScenarioInfo = accumulator$iv;
        Iterable $this$map$iv2 = featureTags;
        boolean $i$f$map22 = false;
        accumulator$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void tag;
            Tag bl4 = (Tag)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl9 = false;
            object3 = tag.getName();
            collection.add(object3);
        }
        List tags = (List)destination$iv$iv2;
        boolean bl10 = ignoreFailure2 = SequencesKt.contains((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)tags), (Function1)lexScenario.ignoreFailure.1.INSTANCE), (Object)"@WIP");
        if (includedSpecifications.isEmpty() || backgroundScenarioInfo == null) {
            ScenarioInfo $i$f$map22 = backgroundScenarioInfo;
            scenarioInfo = FeatureKt.scenarioInfoWithExamples(parsedScenarioInfo, $i$f$map22 == null ? new ScenarioInfo(null, null, null, null, null, null, null, null, false, null, null, 2047, null) : $i$f$map22, examplesList, ignoreFailure2);
        } else {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = includedSpecifications;
            boolean $i$f$mapNotNull = false;
            Iterable $i$f$mapTo22 = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            object2 = $this$forEach$iv$iv$iv.iterator();
            while (object2.hasNext()) {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object2.next();
                boolean bl11 = false;
                it = (IncludedSpecification)element$iv$iv;
                boolean bl12 = false;
                object = it;
                object = object == null ? null : object.matches(parsedScenarioInfo, steps);
                bl = false;
                Object object7 = object;
                if (object7 == null) {
                    object7 = CollectionsKt.emptyList();
                }
                if (object7 == null) continue;
                Object object8 = object7;
                boolean bl13 = false;
                boolean bl14 = false;
                Object it$iv$iv = object8;
                boolean bl15 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            List matchingScenarios2 = CollectionsKt.flatten((Iterable)((List)destination$iv$iv3));
            if (matchingScenarios2.size() > 1) {
                throw new ContractException("Scenario: " + parsedScenarioInfo.getScenarioName() + " is not specific, it matches " + matchingScenarios2.size() + " in the included Wsdl / OpenApi", null, null, null, 14, null);
            }
            scenarioInfo = FeatureKt.scenarioInfoWithExamples((ScenarioInfo)CollectionsKt.first((List)matchingScenarios2), backgroundScenarioInfo, examplesList, ignoreFailure2);
        }
        return scenarioInfo;
    }

    private static final List<TableRow> listOfDatatableRows(Step it) {
        List list;
        List list2;
        DataTable dataTable = it.getDataTable();
        List list3 = list2 = dataTable == null ? null : dataTable.getRows();
        if (list2 == null) {
            boolean bl = false;
            list = new ArrayList();
        } else {
            list = list2;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<String, Pattern> parseEnum(@NotNull StepInfo step) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        String[] stringArray = new String[]{" "};
        List tokens = StringsKt.split$default((CharSequence)step.getText(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (tokens.size() < 5) {
            throw new ContractException("Enum syntax error in step at line " + step.getRaw().getLocation().getLine() + ". Syntax should be Given(/When/Then) enum EnumName <TypeName> values choice1,choice2,choice3", null, null, null, 14, null);
        }
        String enumName = (String)tokens.get(1);
        String[] stringArray2 = new String[]{","};
        List enumValues = StringsKt.split$default((CharSequence)((CharSequence)tokens.get(4)), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        String enumType = (String)tokens.get(2);
        Iterable $this$map$iv = enumValues;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ScalarValue scalarValue;
            void enumValue;
            Pattern enumPattern;
            Pattern pattern2;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pattern pattern3 = GrammarKt.parsedPattern$default(enumType, null, null, 6, null);
            boolean bl2 = false;
            boolean bl3 = false;
            Pattern $this$parseEnum_u24lambda_u2d9_u24lambda_u2d8 = pattern3;
            boolean bl4 = false;
            Pattern pattern4 = $this$parseEnum_u24lambda_u2d9_u24lambda_u2d8;
            if (pattern4 instanceof DeferredPattern) {
                pattern2 = ((DeferredPattern)$this$parseEnum_u24lambda_u2d9_u24lambda_u2d8).resolvePattern(new Resolver());
            } else {
                if (pattern4 instanceof AnyPattern) {
                    throw new ContractException("Enums " + enumName + " type " + enumType + " cannot be nullable. To mark the enum nullable please use it with nullable syntax. Suggested Usage: (" + enumName + "?)", null, null, null, 14, null);
                }
                pattern2 = $this$parseEnum_u24lambda_u2d9_u24lambda_u2d8;
            }
            if ((pattern3 = (enumPattern = pattern2)) instanceof StringPattern) {
                scalarValue = new StringValue((String)enumValue);
            } else if (pattern3 instanceof NumberPattern) {
                void var16_16 = enumValue;
                bl3 = false;
                scalarValue = new NumberValue(Integer.parseInt((String)var16_16));
            } else {
                throw new ContractException("Enums can only be of type String or Number", null, null, null, 14, null);
            }
            ExactValuePattern exactValuePattern = new ExactValuePattern((Value)((Object)scalarValue), null, 2, null);
            collection.add(exactValuePattern);
        }
        List exactValuePatterns = (List)destination$iv$iv;
        return new Pair((Object)('(' + enumName + ')'), (Object)new AnyPattern(exactValuePatterns, null, null, 6, null));
    }

    private static final ScenarioInfo scenarioInfoWithExamples(ScenarioInfo parsedScenarioInfo, ScenarioInfo backgroundScenarioInfo, List<? extends io.cucumber.messages.types.Examples> examplesList, boolean ignoreFailure2) {
        List list = CollectionsKt.plus((Collection)backgroundScenarioInfo.getExamples(), (Iterable)Examples.Companion.examplesFrom(examplesList));
        Map map = MapsKt.plus(backgroundScenarioInfo.getBindings(), parsedScenarioInfo.getBindings());
        Map map2 = MapsKt.plus(backgroundScenarioInfo.getReferences(), parsedScenarioInfo.getReferences());
        return ScenarioInfo.copy$default(parsedScenarioInfo, null, null, null, null, null, null, list, null, ignoreFailure2, map2, map, 191, null);
    }

    @NotNull
    public static final Map<String, String> setters(@NotNull String rest2, @NotNull Map<String, String> backgroundSetters, @NotNull Map<String, String> scenarioSetters) {
        Intrinsics.checkNotNullParameter((Object)rest2, (String)"rest");
        Intrinsics.checkNotNullParameter(backgroundSetters, (String)"backgroundSetters");
        Intrinsics.checkNotNullParameter(scenarioSetters, (String)"scenarioSetters");
        List<String> parts = FeatureKt.breakIntoPartsMaxLength(rest2, 3);
        if (parts.size() != 3 || !Intrinsics.areEqual((Object)parts.get(1), (Object)"=")) {
            throw new ContractException("Setter syntax is incorrect in \"" + rest2 + "\". Syntax should be \"Then set <variable> = <selector>\"", null, null, null, 14, null);
        }
        String variableName = parts.get(0);
        String selector = parts.get(2);
        return MapsKt.plus((Map)MapsKt.plus(backgroundSetters, scenarioSetters), (Pair)TuplesKt.to((Object)variableName, (Object)selector));
    }

    @NotNull
    public static final Map<String, References> values(@NotNull String rest2, @NotNull Map<String, References> scenarioReferences, @NotNull Map<String, References> backgroundReferences, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)rest2, (String)"rest");
        Intrinsics.checkNotNullParameter(scenarioReferences, (String)"scenarioReferences");
        Intrinsics.checkNotNullParameter(backgroundReferences, (String)"backgroundReferences");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        List<String> parts = FeatureKt.breakIntoPartsMaxLength(rest2, 3);
        if (parts.size() != 3 || !Intrinsics.areEqual((Object)parts.get(1), (Object)"from")) {
            throw new ContractException("Incorrect syntax for value statement: " + rest2 + " - it should be \"Given value <value name> from <Specmatic file name>\"", null, null, null, 14, null);
        }
        String valueStoreName = parts.get(0);
        String qontractFileName = parts.get(2);
        ContractFileWithExports qontractFilePath = new ContractFileWithExports(qontractFileName, new AnchorFile(filePath));
        return MapsKt.plus((Map)MapsKt.plus(backgroundReferences, scenarioReferences), (Pair)TuplesKt.to((Object)valueStoreName, (Object)new References(valueStoreName, qontractFilePath, null, null, contractCache, 12, null)));
    }

    @NotNull
    public static final KafkaMessagePattern toAsyncMessage(@NotNull StepInfo step) {
        KafkaMessagePattern kafkaMessagePattern;
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        List<String> parts = FeatureKt.breakIntoPartsMaxLength(step.getRest(), 3);
        int n = parts.size();
        switch (n) {
            case 2: {
                List<String> list;
                List<String> list2 = list = parts;
                boolean bl = false;
                String name = list2.get(0);
                List<String> list3 = list;
                boolean bl2 = false;
                String type = list3.get(1);
                kafkaMessagePattern = new KafkaMessagePattern(name, null, GrammarKt.parsedPattern$default(type, null, null, 6, null), 2, null);
                break;
            }
            case 3: {
                List<String> list;
                List<String> type = list = parts;
                boolean bl = false;
                String name = type.get(0);
                List<String> list4 = list;
                boolean bl3 = false;
                String key = list4.get(1);
                List<String> list5 = list;
                boolean bl4 = false;
                String contentType = list5.get(2);
                kafkaMessagePattern = new KafkaMessagePattern(name, GrammarKt.parsedPattern$default(key, null, null, 6, null), GrammarKt.parsedPattern$default(contentType, null, null, 6, null));
                break;
            }
            default: {
                throw new ContractException("The message keyword must have either 2 params (topic, value) or 3 (topic, key, value)", null, null, null, 14, null);
            }
        }
        return kafkaMessagePattern;
    }

    @NotNull
    public static final MultiPartFormDataPattern toFormDataPart(@NotNull StepInfo step, @NotNull String contractFilePath) {
        MultiPartFormDataPattern multiPartFormDataPattern;
        List list;
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        Intrinsics.checkNotNullParameter((Object)contractFilePath, (String)"contractFilePath");
        List<String> parts = FeatureKt.breakIntoPartsMaxLength(step.getRest(), 4);
        if (parts.size() < 2) {
            throw new ContractException("There must be at least 2 words after request-part in " + step + ".line", null, null, null, 14, null);
        }
        List list2 = list = CollectionsKt.slice(parts, (IntRange)new IntRange(0, 1));
        boolean bl = false;
        String name = (String)list2.get(0);
        List list3 = list;
        boolean bl2 = false;
        String content = (String)list3.get(1);
        if (StringsKt.startsWith$default((String)content, (String)"@", (boolean)false, (int)2, null)) {
            Pattern pattern2;
            String contentType = (String)CollectionsKt.getOrNull(parts, (int)2);
            String contentEncoding = (String)CollectionsKt.getOrNull(parts, (int)3);
            String multipartFilename = StringsKt.removePrefix((String)content, (CharSequence)"@");
            Pattern filenamePattern = GrammarKt.parsedPattern$default(multipartFilename, null, null, 6, null);
            if (filenamePattern instanceof ExactValuePattern) {
                File file = new File(contractFilePath).getAbsoluteFile().getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"File(contractFilePath).absoluteFile.parentFile");
                String multipartFilePath = FilesKt.resolve((File)file, (String)multipartFilename).getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)multipartFilePath, (String)"multipartFilePath");
                pattern2 = new ExactValuePattern(new StringValue(multipartFilePath), null, 2, null);
            } else {
                pattern2 = filenamePattern;
            }
            Pattern expandedFilenamePattern = pattern2;
            multiPartFormDataPattern = new MultiPartFilePattern(name, expandedFilenamePattern, contentType, contentEncoding);
        } else {
            multiPartFormDataPattern = GrammarKt.isPatternToken(content) ? (MultiPartFormDataPattern)new MultiPartContentPattern(name, GrammarKt.parsedPattern$default(content, null, null, 6, null)) : (MultiPartFormDataPattern)new MultiPartContentPattern(name, new ExactValuePattern(GrammarKt.parsedValue(content), null, 2, null));
        }
        return multiPartFormDataPattern;
    }

    @NotNull
    public static final Pattern toPattern(@NotNull StepInfo step) {
        Pattern pattern2;
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        String stringData = FeatureKt.stringOrDocString(step.getRest(), step);
        if (Intrinsics.areEqual((Object)stringData, (Object)"")) {
            if (step.getRowsList().isEmpty()) {
                throw new ContractException(Intrinsics.stringPlus((String)"Not enough information to describe a type in ", (Object)step), null, null, null, 14, null);
            }
            pattern2 = TabularPatternKt.rowsToTabularPattern$default(step.getRowsList(), null, 2, null);
        } else {
            pattern2 = GrammarKt.parsedPattern$default(stringData, null, null, 6, null);
        }
        return pattern2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Pattern> plusFormFields(@NotNull Map<String, ? extends Pattern> formFields, @NotNull String rest2, @NotNull List<? extends TableRow> rowsList) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        List list;
        Map<String, ? extends Pattern> map;
        Pair pair;
        TableRow $dstr$key$value;
        Object object;
        Object object2;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Object destination$iv$iv;
        Iterable $this$map$iv;
        boolean $i$f$map;
        Map<String, ? extends Pattern> map2;
        Intrinsics.checkNotNullParameter(formFields, (String)"formFields");
        Intrinsics.checkNotNullParameter((Object)rest2, (String)"rest");
        Intrinsics.checkNotNullParameter(rowsList, (String)"rowsList");
        Map<String, ? extends Pattern> map3 = formFields;
        int n = rowsList.size();
        if (n == 0) {
            Iterable iterable = FeatureKt.toQueryParams(rest2);
            map2 = map3;
            $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                object2 = (List)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                TableRow tableRow = $dstr$key$value;
                boolean bl2 = false;
                String key = (String)tableRow.get(0);
                TableRow tableRow2 = $dstr$key$value;
                boolean bl3 = false;
                String value = (String)tableRow2.get(1);
                pair = TuplesKt.to((Object)key, (Object)value);
                object.add(pair);
            }
            object = (List)destination$iv$iv;
            map = map2;
            list = object;
        } else {
            $this$map$iv = rowsList;
            map2 = map3;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void row;
                $dstr$key$value = (TableRow)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                pair = TuplesKt.to((Object)((TableCell)row.getCells().get(0)).getValue(), (Object)((TableCell)row.getCells().get(1)).getValue());
                object.add(pair);
            }
            object = (List)destination$iv$iv;
            map = map2;
            list = object;
        }
        Iterable iterable = list;
        map2 = map;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        $this$mapTo$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            object2 = destination$iv$iv;
            Pair $dstr$key$value2 = (Pair)element$iv$iv;
            boolean bl = false;
            String key = (String)$dstr$key$value2.component1();
            String value = (String)$dstr$key$value2.component2();
            Pair pair2 = TuplesKt.to((Object)key, (Object)GrammarKt.parsedPattern$default(value, null, null, 6, null));
            boolean bl4 = false;
            object2.put(pair2.getFirst(), pair2.getSecond());
        }
        object = destination$iv$iv;
        return MapsKt.plus(map2, (Map)object);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<List<String>> toQueryParams(String rest2) {
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{"&"};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)rest2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List<String> list = FeatureKt.breakIntoPartsMaxLength((String)it, 2);
            collection.add(list);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final HttpHeadersPattern plusHeaderPattern(@NotNull String rest2, @NotNull HttpHeadersPattern headersPattern) {
        Intrinsics.checkNotNullParameter((Object)rest2, (String)"rest");
        Intrinsics.checkNotNullParameter((Object)headersPattern, (String)"headersPattern");
        List<String> parts = FeatureKt.breakIntoPartsMaxLength(rest2, 2);
        int n = parts.size();
        switch (n) {
            case 2: {
                break;
            }
            case 1: {
                throw new ContractException("Header " + parts + "[0] should have a value", null, null, null, 14, null);
            }
            default: {
                throw new ContractException(Intrinsics.stringPlus((String)"Unrecognised header params ", (Object)rest2), null, null, null, 14, null);
            }
        }
        return HttpHeadersPattern.copy$default(headersPattern, MapsKt.plus(headersPattern.getPattern(), FeatureKt.toPatternPair(parts.get(0), parts.get(1))), null, 2, null);
    }

    @NotNull
    public static final Pair<String, Pattern> toPatternPair(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return TuplesKt.to((Object)key, (Object)GrammarKt.parsedPattern$default(value, null, null, 6, null));
    }

    @NotNull
    public static final List<String> breakIntoPartsMaxLength(@NotNull String whole, int partCount) {
        Intrinsics.checkNotNullParameter((Object)whole, (String)"whole");
        CharSequence charSequence = whole;
        String string = "\\s+";
        boolean bl = false;
        string = new Regex(string);
        bl = false;
        return string.split(charSequence, partCount);
    }

    @NotNull
    public static final List<String> breakIntoPartsMaxLength(@NotNull String whole, @NotNull String separator, int partCount) {
        Intrinsics.checkNotNullParameter((Object)whole, (String)"whole");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        CharSequence charSequence = whole;
        String string = separator;
        boolean bl = false;
        string = new Regex(string);
        bl = false;
        return string.split(charSequence, partCount);
    }

    @NotNull
    public static final GherkinDocument parseGherkinString(@NotNull String gherkinData, @NotNull String sourceFilePath) {
        Intrinsics.checkNotNullParameter((Object)gherkinData, (String)"gherkinData");
        Intrinsics.checkNotNullParameter((Object)sourceFilePath, (String)"sourceFilePath");
        GherkinDocument gherkinDocument = FeatureKt.parseGherkinString(gherkinData);
        if (gherkinDocument == null) {
            throw new ContractException("There was no contract in the file " + sourceFilePath + '.', null, null, null, 14, null);
        }
        return gherkinDocument;
    }

    @Nullable
    public static final GherkinDocument parseGherkinString(@NotNull String gherkinData) {
        Intrinsics.checkNotNullParameter((Object)gherkinData, (String)"gherkinData");
        IdGenerator idGenerator = (IdGenerator)new IdGenerator.Incrementing();
        Parser parser = new Parser((Parser.Builder)new GherkinDocumentBuilder(idGenerator));
        return (GherkinDocument)parser.parse(gherkinData);
    }

    @NotNull
    public static final Pair<String, List<Scenario>> lex(@NotNull GherkinDocument gherkinDocument, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)gherkinDocument, (String)"gherkinDocument");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String string = gherkinDocument.getFeature().getName();
        List list = gherkinDocument.getFeature().getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"gherkinDocument.feature.children");
        return new Pair((Object)string, FeatureKt.lex(list, filePath));
    }

    public static /* synthetic */ Pair lex$default(GherkinDocument gherkinDocument, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return FeatureKt.lex(gherkinDocument, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Scenario> lex(@NotNull List<? extends FeatureChild> featureChildren, @NotNull String filePath) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(featureChildren, (String)"featureChildren");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Iterable $this$map$iv = FeatureKt.scenarioInfos(featureChildren, filePath);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void scenarioInfo;
            ScenarioInfo scenarioInfo2 = (ScenarioInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Scenario scenario = new Scenario(scenarioInfo.getScenarioName(), scenarioInfo.getHttpRequestPattern(), scenarioInfo.getHttpResponsePattern(), scenarioInfo.getExpectedServerState(), scenarioInfo.getExamples(), scenarioInfo.getPatterns(), scenarioInfo.getFixtures(), scenarioInfo.getKafkaMessage(), scenarioInfo.getIgnoreFailure(), scenarioInfo.getReferences(), scenarioInfo.getBindings());
            collection.add(scenario);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ScenarioInfo> scenarioInfos(@NotNull List<? extends FeatureChild> featureChildren, @NotNull String filePath) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv;
        Object destination$iv$iv;
        ScenarioInfo scenarioInfo;
        Object element$iv$iv$iv;
        FeatureChild $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(featureChildren, (String)"featureChildren");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        IncludedSpecification openApiSpecification2 = FeatureKt.toIncludedSpecification(featureChildren, (Function1<? super List<? extends FeatureChild>, ? extends Step>)((Function1)scenarioInfos.openApiSpecification.1.INSTANCE), (Function1<? super String, ? extends IncludedSpecification>)((Function1)new Function1<String, IncludedSpecification>(filePath){
            final /* synthetic */ String $filePath;
            {
                this.$filePath = $filePath;
                super(1);
            }

            @NotNull
            public final IncludedSpecification invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return OpenApiSpecification.Companion.fromFile(it, this.$filePath);
            }
        }));
        IncludedSpecification wsdlSpecification2 = FeatureKt.toIncludedSpecification(featureChildren, (Function1<? super List<? extends FeatureChild>, ? extends Step>)((Function1)scenarioInfos.wsdlSpecification.1.INSTANCE), (Function1<? super String, ? extends IncludedSpecification>)((Function1)scenarioInfos.wsdlSpecification.2.INSTANCE));
        Object[] objectArray = new IncludedSpecification[]{openApiSpecification2, wsdlSpecification2};
        List includedSpecifications = CollectionsKt.listOfNotNull((Object[])objectArray);
        Iterable $this$mapNotNull$iv = includedSpecifications;
        boolean $i$f$mapNotNull22 = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl6 = false;
            IncludedSpecification it = (IncludedSpecification)element$iv$iv;
            boolean bl2 = false;
            if (it.toScenarioInfos() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            List<ScenarioInfo> it$iv$iv = iterator2;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List scenarioInfosBelongingToIncludedSpecifications = CollectionsKt.flatten((Iterable)((List)destination$iv$iv2));
        $this$mapNotNullTo$iv$iv = FeatureKt.backgroundScenario(featureChildren);
        if ($this$mapNotNullTo$iv$iv == null) {
            scenarioInfo = null;
        } else {
            Iterable $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2;
            destination$iv$iv2 = $this$mapNotNullTo$iv$iv;
            $i$f$mapNotNullTo22 = false;
            boolean $this$forEach$iv$iv$iv2 = false;
            Collection feature2 = destination$iv$iv2;
            boolean bl = false;
            element$iv$iv$iv = feature2.getBackground().getSteps();
            Intrinsics.checkNotNullExpressionValue(element$iv$iv$iv, (String)"feature.background.steps");
            element$iv$iv$iv = (Iterable)element$iv$iv$iv;
            boolean $i$f$filter = false;
            void bl6 = $this$filter$iv2;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Step it = (Step)element$iv$iv;
                boolean bl7 = false;
                String string = it.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                if (!(!StringsKt.contains((CharSequence)string, (CharSequence)"openapi", (boolean)true))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv2 = $this$filter$iv2;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Step it = (Step)element$iv$iv;
                boolean bl8 = false;
                String string = it.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                if (!(!StringsKt.contains((CharSequence)string, (CharSequence)"wsdl", (boolean)true))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            boolean $this$filter$iv22 = false;
            scenarioInfo = FeatureKt.lexScenario((List)destination$iv$iv, CollectionsKt.emptyList(), CollectionsKt.emptyList(), null, filePath, includedSpecifications);
        }
        ScenarioInfo $i$f$mapNotNull22 = scenarioInfo;
        ScenarioInfo backgroundInfo = $i$f$mapNotNull22 == null ? new ScenarioInfo(null, null, null, null, null, null, null, null, false, null, null, 2047, null) : $i$f$mapNotNull22;
        Iterable $this$map$iv = FeatureKt.scenarios(featureChildren);
        boolean $i$f$map = false;
        Iterable $i$f$mapNotNullTo22 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void featureChild;
            FeatureChild $i$f$filter = (FeatureChild)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            destination$iv$iv = featureChild.getScenario().getName();
            Intrinsics.checkNotNullExpressionValue((Object)destination$iv$iv, (String)"featureChild.scenario.name");
            if (StringsKt.isBlank((CharSequence)((CharSequence)destination$iv$iv))) {
                throw new ContractException("Error at line " + featureChild.getScenario().getLocation().getLine() + ": scenario name must not be empty", null, null, null, 14, null);
            }
            Object $i$f$filterTo = featureChild.getScenario().getName();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$filterTo, (String)"featureChild.scenario.name");
            ScenarioInfo backgroundInfoCopy = ScenarioInfo.copy$default(backgroundInfo, (String)$i$f$filterTo, null, null, null, null, null, null, null, false, null, null, 2046, null);
            $i$f$filterTo = featureChild.getScenario().getSteps();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$filterTo, (String)"featureChild.scenario.steps");
            Object object2 = $i$f$filterTo;
            $i$f$filterTo = featureChild.getScenario().getExamples();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$filterTo, (String)"featureChild.scenario.examples");
            Object object3 = $i$f$filterTo;
            $i$f$filterTo = featureChild.getScenario().getTags();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$filterTo, (String)"featureChild.scenario.tags");
            object = FeatureKt.lexScenario((List<? extends Step>)object2, (List<? extends io.cucumber.messages.types.Examples>)object3, (List<? extends Tag>)$i$f$filterTo, backgroundInfoCopy, filePath, includedSpecifications);
            collection.add(object);
        }
        List specmaticScenarioInfos = (List)destination$iv$iv3;
        $this$map$iv = scenarioInfosBelongingToIncludedSpecifications;
        collection = specmaticScenarioInfos;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block11: {
                ScenarioInfo scenarioInfo2 = (ScenarioInfo)element$iv$iv;
                boolean bl9 = false;
                Iterable $this$any$iv = specmaticScenarioInfos;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ScenarioInfo it = (ScenarioInfo)element$iv;
                        boolean bl10 = false;
                        if (!(it.getHttpResponsePattern().getStatus() == scenarioInfo2.getHttpResponsePattern().getStatus())) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            boolean bl11 = !bl;
            if (!bl11) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        object = (List)destination$iv$iv3;
        return CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object));
    }

    private static final IncludedSpecification toIncludedSpecification(List<? extends FeatureChild> featureChildren, Function1<? super List<? extends FeatureChild>, ? extends Step> selector, Function1<? super String, ? extends IncludedSpecification> creator) {
        IncludedSpecification includedSpecification;
        Step step = (Step)selector.invoke(featureChildren);
        if (step == null) {
            includedSpecification = null;
        } else {
            Step step2 = step;
            boolean bl = false;
            boolean bl2 = false;
            Step $this$toIncludedSpecification_u24lambda_u2d22 = step2;
            boolean bl3 = false;
            String[] stringArray = $this$toIncludedSpecification_u24lambda_u2d22.getText();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"text");
            CharSequence charSequence = (CharSequence)stringArray;
            stringArray = new String[]{" "};
            includedSpecification = (IncludedSpecification)creator.invoke(StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1));
        }
        return includedSpecification;
    }

    private static final FeatureChild backgroundScenario(List<? extends FeatureChild> featureChildren) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = featureChildren;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FeatureChild it = (FeatureChild)element$iv;
                boolean bl = false;
                if (!(it.getBackground() != null)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * Unable to fully structure code
     */
    private static final Step backgroundOpenApi(List<? extends FeatureChild> featureChildren) {
        block5: {
            block3: {
                block4: {
                    var1_1 = FeatureKt.backgroundScenario(featureChildren);
                    if (var1_1 != null) break block4;
                    v0 = null;
                    break block5;
                }
                var2_2 = var1_1;
                var3_3 = false;
                var4_4 = false;
                background = var2_2;
                $i$a$-let-FeatureKt$backgroundOpenApi$1 = false;
                var7_7 = background.getBackground().getSteps();
                Intrinsics.checkNotNullExpressionValue((Object)var7_7, (String)"background.background.steps");
                $this$firstOrNull$iv = var7_7;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (Step)element$iv;
                    $i$a$-firstOrNull-FeatureKt$backgroundOpenApi$1$1 = false;
                    var13_13 = it.getKeyword();
                    Intrinsics.checkNotNullExpressionValue((Object)var13_13, (String)"it.keyword");
                    if (!StringsKt.contains((CharSequence)var13_13, (CharSequence)"Given", (boolean)true)) ** GOTO lbl-1000
                    var13_13 = it.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)var13_13, (String)"it.text");
                    if (StringsKt.contains((CharSequence)var13_13, (CharSequence)"openapi", (boolean)true)) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                    if (!v1) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            v0 = v2;
        }
        return v0;
    }

    /*
     * Unable to fully structure code
     */
    private static final Step backgroundWsdl(List<? extends FeatureChild> featureChildren) {
        block5: {
            block3: {
                block4: {
                    var1_1 = FeatureKt.backgroundScenario(featureChildren);
                    if (var1_1 != null) break block4;
                    v0 = null;
                    break block5;
                }
                var2_2 = var1_1;
                var3_3 = false;
                var4_4 = false;
                background = var2_2;
                $i$a$-let-FeatureKt$backgroundWsdl$1 = false;
                var7_7 = background.getBackground().getSteps();
                Intrinsics.checkNotNullExpressionValue((Object)var7_7, (String)"background.background.steps");
                $this$firstOrNull$iv = var7_7;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (Step)element$iv;
                    $i$a$-firstOrNull-FeatureKt$backgroundWsdl$1$1 = false;
                    var13_13 = it.getKeyword();
                    Intrinsics.checkNotNullExpressionValue((Object)var13_13, (String)"it.keyword");
                    if (!StringsKt.contains((CharSequence)var13_13, (CharSequence)"Given", (boolean)true)) ** GOTO lbl-1000
                    var13_13 = it.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)var13_13, (String)"it.text");
                    if (StringsKt.contains((CharSequence)var13_13, (CharSequence)"wsdl", (boolean)true)) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                    if (!v1) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            v0 = v2;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<FeatureChild> scenarios(List<? extends FeatureChild> featureChildren) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = featureChildren;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FeatureChild it = (FeatureChild)element$iv$iv;
            boolean bl = false;
            if (!(it.getBackground() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final String toGherkinFeature(@NotNull NamedStub stub) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        return FeatureKt.toGherkinFeature("New Feature", CollectionsKt.listOf((Object)stub));
    }

    private static final Pair<List<GherkinClause>, ExampleDeclarations> stubToClauses(NamedStub namedStub) {
        Pair pair;
        KafkaMessage kafkaMessage = namedStub.getStub().getKafkaMessage();
        if (kafkaMessage == null) {
            Triple<List<GherkinClause>, Map<String, Pattern>, ExampleDeclarations> triple = HttpRequestKt.toGherkinClauses(namedStub.getStub().getRequest());
            List requestClauses = (List)triple.component1();
            Map typesFromRequest = (Map)triple.component2();
            ExampleDeclarations examples = (ExampleDeclarations)triple.component3();
            for (String message : examples.getMessages()) {
                OutputKt.getInformation().forTheUser(message);
            }
            Iterator<String> iterator = HttpResponseKt.toGherkinClauses(namedStub.getStub().getResponse(), typesFromRequest);
            List responseClauses = (List)iterator.component1();
            Map allTypes = (Map)iterator.component2();
            List<GherkinClause> typeClauses = GherkinClauseKt.toGherkinClauses(allTypes);
            pair = new Pair((Object)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)typeClauses, (Iterable)requestClauses), (Iterable)responseClauses), (Object)examples);
        } else {
            pair = new Pair(KafkaMessageKt.toGherkinClauses(namedStub.getStub().getKafkaMessage()), (Object)new UseExampleDeclarations(null, null, null, 7, null));
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toGherkinFeature(@NotNull String featureName, @NotNull List<NamedStub> stubs) {
        void $this$mapTo$iv$iv;
        Map groupedStubs;
        Object examples;
        void $this$fold$iv;
        Object object;
        ExampleDeclarations commentedExamples;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        Intrinsics.checkNotNullParameter(stubs, (String)"stubs");
        Iterable $this$map$iv = stubs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void stub;
            NamedStub namedStub = (NamedStub)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Pair<List<GherkinClause>, ExampleDeclarations> pair = FeatureKt.stubToClauses((NamedStub)stub);
            List clauses = (List)pair.component1();
            ExampleDeclarations examples2 = (ExampleDeclarations)pair.component2();
            commentedExamples = FeatureKt.addCommentsToExamples(examples2, (NamedStub)stub);
            object = new Pair((Object)new GherkinScenario(stub.getName(), clauses), (Object)CollectionsKt.listOf((Object)commentedExamples));
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        Map initial$iv = MapsKt.emptyMap();
        boolean $i$f$fold = false;
        Map accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void $dstr$scenario$examples;
            Object item$iv$iv;
            item$iv$iv = (Pair)element$iv;
            Map groups = accumulator$iv;
            boolean bl = false;
            GherkinScenario scenario = (GherkinScenario)$dstr$scenario$examples.component1();
            examples = (List)$dstr$scenario$examples.component2();
            accumulator$iv = MapsKt.plus((Map)groups, (Pair)TuplesKt.to((Object)scenario, (Object)CollectionsKt.plus((Collection)groups.getOrDefault(scenario, CollectionsKt.emptyList()), (Iterable)((Iterable)examples))));
        }
        Map $this$map$iv2 = groupedStubs = accumulator$iv;
        boolean $i$f$map2 = false;
        accumulator$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo2 = false;
        void var9_12 = $this$mapTo$iv$iv;
        boolean bl = false;
        for (Map.Entry item$iv$iv : var9_12.entrySet()) {
            void $dstr$nameAndClauses$examplesList;
            examples = item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            commentedExamples = $dstr$nameAndClauses$examplesList;
            boolean bl3 = false;
            GherkinScenario nameAndClauses = (GherkinScenario)commentedExamples.getKey();
            GherkinScenario gherkinScenario = $dstr$nameAndClauses$examplesList;
            boolean bl4 = false;
            List examplesList = (List)gherkinScenario.getValue();
            gherkinScenario = nameAndClauses;
            String name = gherkinScenario.component1();
            List<GherkinClause> clauses = gherkinScenario.component2();
            object = GherkinClauseKt.toGherkinScenario(name, clauses, examplesList);
            collection.add(object);
        }
        List scenarioStrings = (List)destination$iv$iv2;
        return GherkinClauseKt.withFeatureClause(featureName, CollectionsKt.joinToString$default((Iterable)scenarioStrings, (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null));
    }

    private static final ExampleDeclarations addCommentsToExamples(ExampleDeclarations examples, NamedStub stub) {
        String date = stub.getStub().getResponse().getHeaders().get("Date");
        return examples.withComment(date);
    }

    public static final /* synthetic */ Step access$backgroundOpenApi(List featureChildren) {
        return FeatureKt.backgroundOpenApi(featureChildren);
    }

    public static final /* synthetic */ Step access$backgroundWsdl(List featureChildren) {
        return FeatureKt.backgroundWsdl(featureChildren);
    }

    static {
        Object[] objectArray = new String[]{"GET", "POST", "PUT", "PATCH", "DELETE", "HEAD", "OPTIONS"};
        HTTP_METHODS = CollectionsKt.listOf((Object[])objectArray);
    }
}

