/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core;

import in.specmatic.core.HttpHeadersPattern;
import in.specmatic.core.HttpRequest;
import in.specmatic.core.HttpRequestKt;
import in.specmatic.core.HttpRequestPattern;
import in.specmatic.core.MultiPartFormDataPattern;
import in.specmatic.core.MultiPartFormDataValue;
import in.specmatic.core.URLMatcher;
import in.specmatic.core.URLMatcherKt;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.pattern.ExactValuePattern;
import in.specmatic.core.pattern.GrammarKt;
import in.specmatic.core.pattern.Pattern;
import in.specmatic.core.utilities.URIUtils;
import in.specmatic.core.value.EmptyStringKt;
import in.specmatic.core.value.JSONArrayValue;
import in.specmatic.core.value.JSONObjectValue;
import in.specmatic.core.value.StringValue;
import in.specmatic.core.value.Value;
import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001By\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J\u0015\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\u0015\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0003J}\u0010#\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00062\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00062\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010'\u001a\u00020\u00032\b\u0010(\u001a\u0004\u0018\u00010\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001J(\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020,0\u00062\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0002J\u001a\u0010.\u001a\u00020\u00002\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006J\u0006\u00100\u001a\u000201J\u0010\u00102\u001a\u00020\u00032\b\b\u0002\u00103\u001a\u00020\u0003J\u0006\u00104\u001a\u000205J\t\u00106\u001a\u00020\u0003H\u00d6\u0001J\u000e\u00107\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0002J\u0010\u00107\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003J\u0016\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u0003J\u000e\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u0003J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0003J\u0016\u0010A\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u0003J\u001a\u0010B\u001a\u00020\u00002\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006J\u000e\u0010C\u001a\u00020\u00002\u0006\u0010D\u001a\u00020EJ\u000e\u0010F\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\u0003R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015\u00a8\u0006H"}, d2={"Lin/specmatic/core/HttpRequest;", "", "method", "", "path", "headers", "", "body", "Lin/specmatic/core/value/Value;", "queryParams", "formFields", "multiPartFormData", "", "Lin/specmatic/core/MultiPartFormDataValue;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Lin/specmatic/core/value/Value;Ljava/util/Map;Ljava/util/Map;Ljava/util/List;)V", "getBody", "()Lin/specmatic/core/value/Value;", "bodyString", "getBodyString", "()Ljava/lang/String;", "getFormFields", "()Ljava/util/Map;", "getHeaders", "getMethod", "getMultiPartFormData", "()Ljava/util/List;", "getPath", "getQueryParams", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "getURL", "baseURL", "hashCode", "", "mapToPattern", "Lin/specmatic/core/pattern/Pattern;", "map", "setHeaders", "addedHeaders", "toJSON", "Lin/specmatic/core/value/JSONObjectValue;", "toLogString", "prefix", "toPattern", "Lin/specmatic/core/HttpRequestPattern;", "toString", "updateBody", "", "contentBuffer", "Lio/netty/buffer/ByteBuf;", "updateHeader", "key", "value", "updateMethod", "name", "updatePath", "updateQueryParam", "updateQueryParams", "updateWith", "url", "Ljava/net/URI;", "withHost", "host", "core"})
public final class HttpRequest {
    @Nullable
    private final String method;
    @Nullable
    private final String path;
    @NotNull
    private final Map<String, String> headers;
    @NotNull
    private final Value body;
    @NotNull
    private final Map<String, String> queryParams;
    @NotNull
    private final Map<String, String> formFields;
    @NotNull
    private final List<MultiPartFormDataValue> multiPartFormData;

    public HttpRequest(@Nullable String method, @Nullable String path, @NotNull Map<String, String> headers, @NotNull Value body, @NotNull Map<String, String> queryParams, @NotNull Map<String, String> formFields, @NotNull List<? extends MultiPartFormDataValue> multiPartFormData) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        Intrinsics.checkNotNullParameter(formFields, (String)"formFields");
        Intrinsics.checkNotNullParameter(multiPartFormData, (String)"multiPartFormData");
        this.method = method;
        this.path = path;
        this.headers = headers;
        this.body = body;
        this.queryParams = queryParams;
        this.formFields = formFields;
        this.multiPartFormData = multiPartFormData;
    }

    public /* synthetic */ HttpRequest(String string, String string2, Map map, Value value, Map map2, Map map3, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            value = EmptyStringKt.getEmptyString();
        }
        if ((n & 0x10) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 0x20) != 0) {
            map3 = MapsKt.emptyMap();
        }
        if ((n & 0x40) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, string2, map, value, map2, map3, list);
    }

    @Nullable
    public final String getMethod() {
        return this.method;
    }

    @Nullable
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final Map<String, String> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final Value getBody() {
        return this.body;
    }

    @NotNull
    public final Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    @NotNull
    public final Map<String, String> getFormFields() {
        return this.formFields;
    }

    @NotNull
    public final List<MultiPartFormDataValue> getMultiPartFormData() {
        return this.multiPartFormData;
    }

    @NotNull
    public final HttpRequest updateQueryParams(@NotNull Map<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        return HttpRequest.copy$default(this, null, null, null, null, MapsKt.plus(queryParams, queryParams), null, null, 111, null);
    }

    @NotNull
    public final HttpRequest withHost(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return HttpRequest.copy$default(this, null, null, MapsKt.plus(this.headers, (Pair)TuplesKt.to((Object)"Host", (Object)host)), null, null, null, null, 123, null);
    }

    @NotNull
    public final HttpRequest updatePath(@NotNull String path) {
        HttpRequest httpRequest;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            URI urlParam = new URI(path);
            httpRequest = this.updateWith(urlParam);
        }
        catch (URISyntaxException e) {
            httpRequest = HttpRequest.copy$default(this, null, path, null, null, null, null, null, 125, null);
        }
        catch (UnsupportedEncodingException e) {
            httpRequest = HttpRequest.copy$default(this, null, path, null, null, null, null, null, 125, null);
        }
        return httpRequest;
    }

    @NotNull
    public final HttpRequest updateQueryParam(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return HttpRequest.copy$default(this, null, null, null, null, MapsKt.plus(this.queryParams, (Pair)TuplesKt.to((Object)key, (Object)value)), null, null, 111, null);
    }

    @NotNull
    public final HttpRequest updateBody(@NotNull Value body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return HttpRequest.copy$default(this, null, null, null, body, null, null, null, 119, null);
    }

    @NotNull
    public final HttpRequest updateBody(@Nullable String body) {
        return HttpRequest.copy$default(this, null, null, null, GrammarKt.parsedValue(body), null, null, null, 119, null);
    }

    @NotNull
    public final HttpRequest updateWith(@NotNull URI url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String path = url.getPath();
        Map<String, String> queryParams = URIUtils.INSTANCE.parseQuery(url.getQuery());
        return HttpRequest.copy$default(this, null, path, null, null, queryParams, null, null, 109, null);
    }

    @NotNull
    public final HttpRequest updateMethod(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name;
        boolean bl = false;
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
        return HttpRequest.copy$default(this, string2, null, null, null, null, null, null, 126, null);
    }

    private final void updateBody(ByteBuf contentBuffer) {
        String bodyString2 = contentBuffer.toString(Charset.defaultCharset());
        this.updateBody(bodyString2);
    }

    @NotNull
    public final HttpRequest updateHeader(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return HttpRequest.copy$default(this, null, null, MapsKt.plus(this.headers, (Pair)TuplesKt.to((Object)key, (Object)value)), null, null, null, null, 123, null);
    }

    @NotNull
    public final String getBodyString() {
        return this.body.toString();
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final String getURL(@Nullable String baseURL) {
        block7: {
            block6: {
                var3_2 = baseURL;
                if (var3_2 == null) {
                    v0 = "";
                } else {
                    var5_3 = var3_2;
                    var6_5 = false;
                    var7_7 = false;
                    it = var5_3;
                    $i$a$-let-HttpRequest$getURL$cleanBase$1 = false;
                    var10_12 = it;
                    var11_14 = false;
                    var4_16 = StringsKt.isBlank((CharSequence)var10_12) == false && !StringsKt.endsWith$default((String)it, (String)"/", (boolean)false, (int)2, null) ? Intrinsics.stringPlus((String)it, (Object)"/") : it;
                    v0 = var4_16 == null ? "" : var4_16;
                }
                cleanBase = v0;
                var4_16 = this.path;
                if (var4_16 != null) break block6;
                v1 = "";
                break block7;
            }
            var6_6 = var4_16;
            var7_7 = false;
            var8_9 = false;
            it = var6_6;
            $i$a$-let-HttpRequest$getURL$cleanPath$1 = false;
            var11_15 = it;
            var12_18 = false;
            if (!(StringsKt.isBlank((CharSequence)var11_15) == false) || !StringsKt.startsWith$default((String)it, (String)"/", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            var11_15 = cleanBase;
            var12_18 = false;
            if (StringsKt.isBlank((CharSequence)var11_15) == false) {
                v2 = StringsKt.removePrefix((String)it, (CharSequence)"/");
            } else lbl-1000:
            // 2 sources

            {
                v2 = it;
            }
            v1 = (var5_3 = v2) == null ? "" : var5_3;
        }
        cleanPath = v1;
        v3 = new StringBuilder().append(cleanBase).append(cleanPath);
        var4_16 = this.queryParams;
        var5_4 = false;
        if (var4_16.isEmpty() == false) {
            joinedQueryParams = CollectionsKt.joinToString$default((Iterable)MapsKt.toList(this.queryParams), (CharSequence)"&", null, null, (int)0, null, (Function1)getURL.joinedQueryParams.1.INSTANCE, (int)30, null);
            v4 = Intrinsics.stringPlus((String)"?", (Object)joinedQueryParams);
        } else {
            v4 = "";
        }
        return v3.append(v4).toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JSONObjectValue toJSON() {
        Iterable $this$mapValuesTo$iv$iv;
        Object object;
        Object object2;
        Object it;
        Object object3;
        StringValue stringValue;
        Map<String, String> requestMap;
        boolean bl = false;
        Map<String, String> map = requestMap = (Map<String, String>)new LinkedHashMap();
        String string = "path";
        String string2 = this.path;
        if (string2 == null) {
            stringValue = null;
        } else {
            object3 = string2;
            boolean bl2 = false;
            boolean bl3 = false;
            it = object3;
            boolean bl4 = false;
            stringValue = new StringValue((String)it);
        }
        Object object4 = stringValue;
        object4 = object4 == null ? new StringValue("/") : object4;
        boolean bl5 = false;
        map.put(string, (String)object4);
        string = this.method;
        if (string == null) {
            object2 = null;
        } else {
            object4 = string;
            bl5 = false;
            boolean bl6 = false;
            Object it2 = object4;
            boolean bl7 = false;
            it = requestMap;
            String bl4 = "method";
            object = new StringValue((String)it2);
            boolean bl8 = false;
            it.put(bl4, object);
            object2 = map = Unit.INSTANCE;
        }
        if (map == null) {
            throw new ContractException("Can't serialise the request without a method.", null, null, null, 14, null);
        }
        HttpRequestKt.access$setIfNotEmpty(requestMap, "query", this.queryParams);
        HttpRequestKt.access$setIfNotEmpty(requestMap, "headers", this.headers);
        map = this.formFields;
        boolean bl9 = false;
        if (!map.isEmpty()) {
            Map map2;
            map = requestMap;
            String string3 = "form-fields";
            Object $this$mapValues$iv = this.formFields;
            boolean $i$f$mapValues = false;
            object3 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it3;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl10 = false;
                Object k = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                map2 = map3;
                boolean bl11 = false;
                StringValue stringValue2 = new StringValue((String)it3.getValue());
                map2.put(k2, stringValue2);
            }
            Map map4 = map2 = destination$iv$iv;
            $this$mapValues$iv = new JSONObjectValue(map4);
            $i$f$mapValues = false;
            map.put(string3, (String)$this$mapValues$iv);
        } else {
            map = this.multiPartFormData;
            bl9 = false;
            if (!map.isEmpty()) {
                Collection<JSONObjectValue> collection;
                void $this$mapTo$iv$iv;
                map = requestMap;
                String string4 = "multipart-formdata";
                Iterable $this$map$iv = this.multiPartFormData;
                boolean $i$f$map = false;
                $this$mapValuesTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it4;
                    object = (MultiPartFormDataValue)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl12 = false;
                    JSONObjectValue jSONObjectValue = it4.toJSONObject();
                    collection.add(jSONObjectValue);
                }
                collection = (List)destination$iv$iv;
                List list = collection;
                object4 = new JSONArrayValue(list);
                bl5 = false;
                map.put(string4, (String)object4);
            } else {
                map = requestMap;
                String string5 = "body";
                object4 = this.body;
                bl5 = false;
                map.put(string5, (String)object4);
            }
        }
        return new JSONObjectValue(requestMap);
    }

    @NotNull
    public final HttpRequest setHeaders(@NotNull Map<String, String> addedHeaders) {
        Intrinsics.checkNotNullParameter(addedHeaders, (String)"addedHeaders");
        return HttpRequest.copy$default(this, null, null, MapsKt.plus(this.headers, addedHeaders), null, null, null, null, 123, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toLogString(@NotNull String prefix2) {
        String string;
        boolean $i$f$map3;
        Object $this$map$iv;
        void $this$mapTo$iv$iv32;
        String string2;
        Collection collection;
        Map.Entry item$iv$iv;
        void $this$mapTo$iv$iv22;
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        String string3 = this.method;
        String methodString = string3 == null ? "NO_METHOD" : string3;
        String string4 = this.path;
        String pathString = string4 == null ? "NO_PATH" : string4;
        Object $this$map$iv2 = this.queryParams;
        boolean $i$f$map2 = false;
        Map<String, String> map = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo = false;
        Object object = $this$mapTo$iv$iv22;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            string2 = (String)it.getKey() + '=' + (String)it.getValue();
            collection.add(string2);
        }
        $this$map$iv2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        $i$f$map2 = false;
        boolean $this$mapTo$iv$iv22 = false;
        Object it = $this$map$iv2;
        boolean bl3 = false;
        object = (CharSequence)it;
        bl = false;
        Object queryParamString = object.length() > 0 ? Intrinsics.stringPlus((String)"?", (Object)it) : it;
        String urlString = Intrinsics.stringPlus((String)pathString, (Object)queryParamString);
        String firstLine = methodString + ' ' + urlString;
        Map<String, String> $this$map$iv3 = this.headers;
        boolean $i$f$map222 = false;
        object = $this$map$iv3;
        Object destination$iv$iv2 = new ArrayList($this$map$iv3.size());
        boolean $i$f$mapTo2 = false;
        item$iv$iv = $this$mapTo$iv$iv32;
        boolean bl4 = false;
        Iterator iterator2 = item$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it2;
            Map.Entry item$iv$iv2;
            Map.Entry entry = item$iv$iv2 = iterator2.next();
            collection = destination$iv$iv2;
            boolean bl5 = false;
            string2 = (String)it2.getKey() + ": " + (String)it2.getValue();
            collection.add(string2);
        }
        String headerString2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        Map<String, String> $i$f$map222 = this.formFields;
        boolean $this$mapTo$iv$iv32 = false;
        if (!$i$f$map222.isEmpty()) {
            void $this$mapTo$iv$iv;
            $this$map$iv = this.formFields;
            $i$f$map3 = false;
            destination$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo3 = false;
            void var14_28 = $this$mapTo$iv$iv;
            boolean bl6 = false;
            Iterator iterator3 = var14_28.entrySet().iterator();
            while (iterator3.hasNext()) {
                void it3;
                Map.Entry item$iv$iv3;
                Map.Entry bl5 = item$iv$iv3 = iterator3.next();
                collection = destination$iv$iv3;
                boolean bl7 = false;
                string2 = (String)it3.getKey() + '=' + (String)it3.getValue();
                collection.add(string2);
            }
            string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv3), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        } else {
            $this$map$iv = this.multiPartFormData;
            $i$f$map3 = false;
            string = !$this$map$iv.isEmpty() ? CollectionsKt.joinToString$default((Iterable)this.multiPartFormData, (CharSequence)"\n", null, null, (int)0, null, (Function1)toLogString.bodyString.2.INSTANCE, (int)30, null) : this.body.toString();
        }
        String bodyString2 = string;
        Object $i$f$map3 = new String[]{firstLine, headerString2};
        $i$f$map3 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])$i$f$map3), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        boolean bl8 = false;
        if ($i$f$map3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String firstPart = ((Object)StringsKt.trim((CharSequence)((CharSequence)$i$f$map3))).toString();
        Object[] objectArray = new String[]{firstPart, "", bodyString2};
        String requestString = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return HttpRequestKt.startLinesWith(requestString, prefix2);
    }

    public static /* synthetic */ String toLogString$default(HttpRequest httpRequest, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return httpRequest.toLogString(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HttpRequestPattern toPattern() {
        Collection<MultiPartFormDataPattern> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = this.path;
        String pathForPattern = object == null ? "/" : object;
        object = this.multiPartFormData;
        Map<String, Pattern> map = this.mapToPattern(this.formFields);
        Pattern pattern2 = this.body.exactMatchElseType();
        String string = this.method;
        URLMatcher uRLMatcher = new URLMatcher(this.mapToPattern(this.queryParams), URLMatcherKt.pathToPattern(pathForPattern), pathForPattern);
        HttpHeadersPattern httpHeadersPattern = new HttpHeadersPattern(this.mapToPattern(this.headers), null, 2, null);
        boolean $i$f$map = false;
        void var4_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MultiPartFormDataValue multiPartFormDataValue = (MultiPartFormDataValue)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            MultiPartFormDataPattern multiPartFormDataPattern = it.inferType();
            collection.add(multiPartFormDataPattern);
        }
        Collection<MultiPartFormDataPattern> collection2 = collection = (List)destination$iv$iv;
        Map<String, Pattern> map2 = map;
        Pattern pattern3 = pattern2;
        String string2 = string;
        URLMatcher uRLMatcher2 = uRLMatcher;
        HttpHeadersPattern httpHeadersPattern2 = httpHeadersPattern;
        return new HttpRequestPattern(httpHeadersPattern2, uRLMatcher2, string2, pattern3, (Map<String, ? extends Pattern>)map2, (List<? extends MultiPartFormDataPattern>)collection2);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Pattern> mapToPattern(Map<String, String> map) {
        void $this$mapValuesTo$iv$iv;
        Map<String, String> $this$mapValues$iv = map;
        boolean $i$f$mapValues = false;
        Map<String, String> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $dstr$_u24__u24$value;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map4 = map3;
            boolean bl2 = false;
            void var17_17 = $dstr$_u24__u24$value;
            boolean bl3 = false;
            String value = (String)var17_17.getValue();
            Pattern pattern2 = GrammarKt.isPatternToken(value) ? GrammarKt.parsedPattern$default(value, null, null, 6, null) : (Pattern)new ExactValuePattern(new StringValue(value), null, 2, null);
            map4.put(k2, pattern2);
        }
        return destination$iv$iv;
    }

    @Nullable
    public final String component1() {
        return this.method;
    }

    @Nullable
    public final String component2() {
        return this.path;
    }

    @NotNull
    public final Map<String, String> component3() {
        return this.headers;
    }

    @NotNull
    public final Value component4() {
        return this.body;
    }

    @NotNull
    public final Map<String, String> component5() {
        return this.queryParams;
    }

    @NotNull
    public final Map<String, String> component6() {
        return this.formFields;
    }

    @NotNull
    public final List<MultiPartFormDataValue> component7() {
        return this.multiPartFormData;
    }

    @NotNull
    public final HttpRequest copy(@Nullable String method, @Nullable String path, @NotNull Map<String, String> headers, @NotNull Value body, @NotNull Map<String, String> queryParams, @NotNull Map<String, String> formFields, @NotNull List<? extends MultiPartFormDataValue> multiPartFormData) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        Intrinsics.checkNotNullParameter(formFields, (String)"formFields");
        Intrinsics.checkNotNullParameter(multiPartFormData, (String)"multiPartFormData");
        return new HttpRequest(method, path, headers, body, queryParams, formFields, multiPartFormData);
    }

    public static /* synthetic */ HttpRequest copy$default(HttpRequest httpRequest, String string, String string2, Map map, Value value, Map map2, Map map3, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = httpRequest.method;
        }
        if ((n & 2) != 0) {
            string2 = httpRequest.path;
        }
        if ((n & 4) != 0) {
            map = httpRequest.headers;
        }
        if ((n & 8) != 0) {
            value = httpRequest.body;
        }
        if ((n & 0x10) != 0) {
            map2 = httpRequest.queryParams;
        }
        if ((n & 0x20) != 0) {
            map3 = httpRequest.formFields;
        }
        if ((n & 0x40) != 0) {
            list = httpRequest.multiPartFormData;
        }
        return httpRequest.copy(string, string2, map, value, map2, map3, list);
    }

    @NotNull
    public String toString() {
        return "HttpRequest(method=" + this.method + ", path=" + this.path + ", headers=" + this.headers + ", body=" + this.body + ", queryParams=" + this.queryParams + ", formFields=" + this.formFields + ", multiPartFormData=" + this.multiPartFormData + ')';
    }

    public int hashCode() {
        int result2 = this.method == null ? 0 : this.method.hashCode();
        result2 = result2 * 31 + (this.path == null ? 0 : this.path.hashCode());
        result2 = result2 * 31 + ((Object)this.headers).hashCode();
        result2 = result2 * 31 + this.body.hashCode();
        result2 = result2 * 31 + ((Object)this.queryParams).hashCode();
        result2 = result2 * 31 + ((Object)this.formFields).hashCode();
        result2 = result2 * 31 + ((Object)this.multiPartFormData).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpRequest)) {
            return false;
        }
        HttpRequest httpRequest = (HttpRequest)other;
        if (!Intrinsics.areEqual((Object)this.method, (Object)httpRequest.method)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.path, (Object)httpRequest.path)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.headers, httpRequest.headers)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.body, (Object)httpRequest.body)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.queryParams, httpRequest.queryParams)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.formFields, httpRequest.formFields)) {
            return false;
        }
        return Intrinsics.areEqual(this.multiPartFormData, httpRequest.multiPartFormData);
    }

    public HttpRequest() {
        this(null, null, null, null, null, null, null, 127, null);
    }
}

