/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core;

import in.specmatic.conversions.PostmanKt;
import in.specmatic.core.ExampleDeclarations;
import in.specmatic.core.GherkinClause;
import in.specmatic.core.GherkinClauseKt;
import in.specmatic.core.GherkinSection;
import in.specmatic.core.HttpRequest;
import in.specmatic.core.HttpRequestKt;
import in.specmatic.core.MultiPartContentValue;
import in.specmatic.core.MultiPartFileValue;
import in.specmatic.core.MultiPartFormDataValue;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.pattern.DeferredPattern;
import in.specmatic.core.pattern.GrammarKt;
import in.specmatic.core.pattern.Pattern;
import in.specmatic.core.value.JSONArrayValue;
import in.specmatic.core.value.JSONObjectValue;
import in.specmatic.core.value.JSONObjectValueKt;
import in.specmatic.core.value.NullValue;
import in.specmatic.core.value.StringValue;
import in.specmatic.core.value.UseExampleDeclarations;
import in.specmatic.core.value.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\b\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001\u001aN\u0010\b\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\u000e\u001aN\u0010\u0013\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0014\u001a\u00020\u000e\u001aZ\u0010\u0015\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u000e0\t2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\u000e\u001aT\u0010\u0017\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u000e0\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\n2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\u000e\u001a$\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u001c\u001a\u00020\u0001\u001a0\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\f2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u001c\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001\u001a$\u0010!\u001a\u00020\u00192\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010#\u001a\u00020\u0001H\u0002\u001a\u001a\u0010$\u001a\u00020\u00102\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\f\u001a8\u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060(2\u0006\u0010\u001c\u001a\u00020\u00012\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\fH\u0002\u001a\u0018\u0010*\u001a\u00020\u00012\u0006\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\u0001H\u0000\u001a&\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\f2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\f\u001a2\u0010/\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u000f\u001a\u00020\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"FORM_FIELDS_JSON_KEY", "", "MULTIPART_FORMDATA_JSON_KEY", "arrayValue", "Lin/specmatic/core/value/JSONArrayValue;", "value", "Lin/specmatic/core/value/Value;", "errorMessage", "bodyToGherkin", "Lkotlin/Triple;", "", "Lin/specmatic/core/GherkinClause;", "", "Lin/specmatic/core/pattern/Pattern;", "Lin/specmatic/core/ExampleDeclarations;", "request", "Lin/specmatic/core/HttpRequest;", "types", "exampleDeclarations", "firstLineToGherkin", "exampleDeclarationsStore", "formFieldsToGherkin", "formFields", "multiPartFormDataToGherkin", "multiPartFormData", "Lin/specmatic/core/MultiPartFormDataValue;", "nativeString", "json", "key", "nativeStringStringMap", "notNull", "objectValue", "Lin/specmatic/core/value/JSONObjectValue;", "parsePartType", "multiPartSpec", "name", "requestFromJSON", "setIfNotEmpty", "", "dest", "", "data", "startLinesWith", "str", "startValue", "stringMapToValueMap", "stringStringMap", "toGherkinClauses", "core"})
public final class HttpRequestKt {
    @NotNull
    public static final String FORM_FIELDS_JSON_KEY = "form-fields";
    @NotNull
    public static final String MULTIPART_FORMDATA_JSON_KEY = "multipart-formdata";

    /*
     * WARNING - void declaration
     */
    private static final void setIfNotEmpty(Map<String, Value> dest, String key, Map<String, String> data) {
        Map<String, Object> map = data;
        boolean bl = false;
        if (!map.isEmpty()) {
            Map map2;
            void $this$mapValuesTo$iv$iv;
            map = dest;
            Map<String, String> $this$mapValues$iv = data;
            boolean $i$f$mapValues = false;
            Map<String, String> map3 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map4 = destination$iv$iv;
                boolean bl2 = false;
                Object k = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                map2 = map4;
                boolean bl3 = false;
                StringValue stringValue = new StringValue((String)it.getValue());
                map2.put(k2, stringValue);
            }
            Map map5 = map2 = destination$iv$iv;
            JSONObjectValue jSONObjectValue = new JSONObjectValue(map5);
            boolean bl4 = false;
            map.put(key, (String)((Object)jSONObjectValue));
        }
    }

    @Nullable
    public static final String nativeString(@NotNull Map<String, ? extends Value> json, @NotNull String key) {
        Intrinsics.checkNotNullParameter(json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Value value = json.get(key);
        if (value == null) {
            return null;
        }
        Value keyValue = value;
        if (!(keyValue instanceof StringValue)) {
            throw new ContractException("Expected " + key + " to be a string value", null, null, null, 14, null);
        }
        return ((StringValue)keyValue).getString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final HttpRequest requestFromJSON(@NotNull Map<String, ? extends Value> json) {
        Object object;
        Intrinsics.checkNotNullParameter(json, (String)"json");
        Object object2 = HttpRequestKt.nativeString(json, "method");
        if (object2 == null) {
            throw new ContractException("http-request must contain a key named method whose value is the method in the request", null, null, null, 14, null);
        }
        object2 = new HttpRequest(null, null, null, null, null, null, null, 127, null).updateMethod((String)object2).updatePath((String)((object2 = HttpRequestKt.nativeString(json, "path")) == null ? "/" : object2)).updateQueryParams(HttpRequestKt.nativeStringStringMap(json, "query")).setHeaders(HttpRequestKt.nativeStringStringMap(json, "headers"));
        boolean bl = false;
        boolean bl2 = false;
        Object httpRequest = object2;
        boolean bl3 = false;
        Map<String, ? extends Value> map = json;
        String string = FORM_FIELDS_JSON_KEY;
        boolean bl4 = false;
        Object object3 = map;
        boolean bl5 = false;
        if (object3.containsKey(string)) {
            object = HttpRequest.copy$default((HttpRequest)httpRequest, null, null, null, null, null, HttpRequestKt.nativeStringStringMap(json, FORM_FIELDS_JSON_KEY), null, 95, null);
        } else {
            Object parts;
            map = json;
            string = MULTIPART_FORMDATA_JSON_KEY;
            bl4 = false;
            object3 = map;
            bl5 = false;
            if (object3.containsKey(string)) {
                void $this$mapTo$iv$iv;
                parts = HttpRequestKt.arrayValue((Value)MapsKt.getValue(json, (Object)MULTIPART_FORMDATA_JSON_KEY), "multipart-formdata must be a json array.");
                Iterable $this$map$iv = ((JSONArrayValue)parts).getList();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Value value = (Value)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl6 = false;
                    JSONObjectValue part = HttpRequestKt.objectValue((Value)it, "All multipart parts must be json object values.");
                    Map<String, Value> multiPartSpec = part.getJsonObject();
                    String string2 = HttpRequestKt.nativeString(multiPartSpec, "name");
                    if (string2 == null) {
                        throw new ContractException("One of the multipart entries does not have a name key", null, null, null, 14, null);
                    }
                    String name = string2;
                    MultiPartFormDataValue multiPartFormDataValue = HttpRequestKt.parsePartType(multiPartSpec, name);
                    collection.add(multiPartFormDataValue);
                }
                List multiPartData = (List)destination$iv$iv;
                object = HttpRequest.copy$default((HttpRequest)httpRequest, null, null, null, null, null, null, CollectionsKt.plus((Collection)((HttpRequest)httpRequest).getMultiPartFormData(), (Iterable)multiPartData), 63, null);
            } else {
                parts = json;
                string = "body";
                bl4 = false;
                object3 = parts;
                bl5 = false;
                if (object3.containsKey(string)) {
                    Value body = HttpRequestKt.notNull(json.getOrDefault("body", NullValue.INSTANCE), "Either body should have a value or the key should be absent from http-response");
                    object = ((HttpRequest)httpRequest).updateBody(body);
                } else {
                    object = httpRequest;
                }
            }
        }
        return object;
    }

    private static final MultiPartFormDataValue parsePartType(Map<String, ? extends Value> multiPartSpec, String name) {
        MultiPartFormDataValue multiPartFormDataValue;
        if (multiPartSpec.containsKey("content")) {
            multiPartFormDataValue = new MultiPartContentValue(name, (Value)MapsKt.getValue(multiPartSpec, (Object)"content"), null, 4, null);
        } else if (multiPartSpec.containsKey("filename")) {
            Value value = multiPartSpec.get("contentType");
            String string = value == null ? null : value.toStringLiteral();
            value = multiPartSpec.get("contentEncoding");
            multiPartFormDataValue = new MultiPartFileValue(name, StringsKt.removePrefix((String)((Value)MapsKt.getValue(multiPartSpec, (Object)"filename")).toStringLiteral(), (CharSequence)"@"), string, value == null ? null : value.toStringLiteral(), null, null, 48, null);
        } else {
            throw new ContractException("Multipart entry " + name + " must have either a content key or a filename key", null, null, null, 14, null);
        }
        return multiPartFormDataValue;
    }

    @NotNull
    public static final JSONObjectValue objectValue(@NotNull Value value, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        if (!(value instanceof JSONObjectValue)) {
            throw new ContractException(errorMessage, null, null, null, 14, null);
        }
        return (JSONObjectValue)value;
    }

    @NotNull
    public static final JSONArrayValue arrayValue(@NotNull Value value, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        if (!(value instanceof JSONArrayValue)) {
            throw new ContractException(errorMessage, null, null, null, 14, null);
        }
        return (JSONArrayValue)value;
    }

    @NotNull
    public static final Value notNull(@NotNull Value value, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        if (value instanceof NullValue) {
            throw new ContractException(errorMessage, null, null, null, 14, null);
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> nativeStringStringMap(@NotNull Map<String, ? extends Value> json, @NotNull String key) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Value value = json.get(key);
        if (value == null) {
            return MapsKt.emptyMap();
        }
        Value queryValue = value;
        if (!(queryValue instanceof JSONObjectValue)) {
            throw new ContractException("Expected " + key + " to be a json object", null, null, null, 14, null);
        }
        Map<String, Value> $this$mapValues$iv = ((JSONObjectValue)queryValue).getJsonObject();
        boolean $i$f$mapValues = false;
        Map<String, Value> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl2 = false;
            String string = it.getValue().toString();
            map3.put(k2, string);
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final String startLinesWith(@NotNull String str, @NotNull String startValue) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Intrinsics.checkNotNullParameter((Object)startValue, (String)"startValue");
        String[] stringArray = new String[]{"\n"};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)str, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(startValue){
            final /* synthetic */ String $startValue;
            {
                this.$startValue = $startValue;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.stringPlus((String)this.$startValue, (Object)it);
            }
        }), (int)30, null);
    }

    @NotNull
    public static final Triple<List<GherkinClause>, Map<String, Pattern>, ExampleDeclarations> toGherkinClauses(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Triple triple = new Triple((Object)CollectionsKt.emptyList(), (Object)MapsKt.emptyMap(), (Object)new UseExampleDeclarations(null, null, null, 7, null));
        boolean bl = false;
        boolean bl2 = false;
        Triple $dstr$clauses$types$exampleDeclaration = triple;
        boolean bl3 = false;
        List clauses = (List)$dstr$clauses$types$exampleDeclaration.component1();
        Map types = (Map)$dstr$clauses$types$exampleDeclaration.component2();
        UseExampleDeclarations exampleDeclaration = (UseExampleDeclarations)$dstr$clauses$types$exampleDeclaration.component3();
        Triple<List<GherkinClause>, Map<String, Pattern>, ExampleDeclarations> triple2 = HttpRequestKt.firstLineToGherkin(request, types, exampleDeclaration);
        List newClauses = (List)triple2.component1();
        Map newTypes = (Map)triple2.component2();
        ExampleDeclarations newExamples = (ExampleDeclarations)triple2.component3();
        triple = new Triple((Object)CollectionsKt.plus((Collection)clauses, (Iterable)newClauses), (Object)newTypes, (Object)newExamples);
        bl = false;
        bl2 = false;
        Triple $dstr$clauses$types$examples = triple;
        boolean bl4 = false;
        clauses = (List)$dstr$clauses$types$examples.component1();
        types = (Map)$dstr$clauses$types$examples.component2();
        ExampleDeclarations examples = (ExampleDeclarations)$dstr$clauses$types$examples.component3();
        triple2 = GherkinClauseKt.headersToGherkin(request.getHeaders(), "request-header", types, examples, GherkinSection.When);
        newClauses = (List)triple2.component1();
        newTypes = (Map)triple2.component2();
        newExamples = (ExampleDeclarations)triple2.component3();
        triple = new Triple((Object)CollectionsKt.plus((Collection)clauses, (Iterable)newClauses), (Object)newTypes, (Object)newExamples);
        bl = false;
        bl2 = false;
        $dstr$clauses$types$examples = triple;
        boolean bl5 = false;
        clauses = (List)$dstr$clauses$types$examples.component1();
        types = (Map)$dstr$clauses$types$examples.component2();
        examples = (ExampleDeclarations)$dstr$clauses$types$examples.component3();
        triple2 = HttpRequestKt.bodyToGherkin(request, types, examples);
        newClauses = (List)triple2.component1();
        newTypes = (Map)triple2.component2();
        newExamples = (ExampleDeclarations)triple2.component3();
        triple = new Triple((Object)CollectionsKt.plus((Collection)clauses, (Iterable)newClauses), (Object)newTypes, (Object)newExamples);
        bl = false;
        bl2 = false;
        $dstr$clauses$types$examples = triple;
        boolean bl6 = false;
        clauses = (List)$dstr$clauses$types$examples.component1();
        types = (Map)$dstr$clauses$types$examples.component2();
        examples = (ExampleDeclarations)$dstr$clauses$types$examples.component3();
        return new Triple((Object)clauses, (Object)types, (Object)examples);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Value> stringMapToValueMap(@NotNull Map<String, String> stringStringMap) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(stringStringMap, (String)"stringStringMap");
        Map<String, String> $this$mapValues$iv = stringStringMap;
        boolean $i$f$mapValues = false;
        Map<String, String> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl2 = false;
            Value value = PostmanKt.guessType(GrammarKt.parsedValue((String)it.getValue()));
            map3.put(k2, value);
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final Triple<List<GherkinClause>, Map<String, Pattern>, ExampleDeclarations> bodyToGherkin(@NotNull HttpRequest request, @NotNull Map<String, ? extends Pattern> types, @NotNull ExampleDeclarations exampleDeclarations) {
        Triple<List<GherkinClause>, Map<String, Pattern>, ExampleDeclarations> triple;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)exampleDeclarations, (String)"exampleDeclarations");
        Object object = request.getMultiPartFormData();
        boolean bl = false;
        if (!object.isEmpty()) {
            triple = HttpRequestKt.multiPartFormDataToGherkin(request.getMultiPartFormData(), types, exampleDeclarations);
        } else {
            object = request.getFormFields();
            bl = false;
            triple = !object.isEmpty() ? HttpRequestKt.formFieldsToGherkin(request.getFormFields(), types, exampleDeclarations) : GherkinClauseKt.requestBodyToGherkinClauses(request.getBody(), types, exampleDeclarations);
        }
        return triple;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Triple<List<GherkinClause>, Map<String, Pattern>, ExampleDeclarations> multiPartFormDataToGherkin(@NotNull List<? extends MultiPartFormDataValue> multiPartFormData, @NotNull Map<String, ? extends Pattern> types, @NotNull ExampleDeclarations exampleDeclarations) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(multiPartFormData, (String)"multiPartFormData");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)exampleDeclarations, (String)"exampleDeclarations");
        Iterable iterable = multiPartFormData;
        Triple<List<GherkinClause>, Map<String, Pattern>, ExampleDeclarations> initial$iv = new Triple<List<GherkinClause>, Map<String, Pattern>, ExampleDeclarations>((Object)CollectionsKt.emptyList(), types, (Object)exampleDeclarations);
        boolean $i$f$fold = false;
        Triple<List<GherkinClause>, Map<String, Pattern>, ExampleDeclarations> accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void part;
            MultiPartFormDataValue multiPartFormDataValue = (MultiPartFormDataValue)element$iv;
            Triple<List<GherkinClause>, Map<String, Pattern>, ExampleDeclarations> $dstr$clauses$newTypes$examples = accumulator$iv;
            boolean bl = false;
            List clauses = (List)$dstr$clauses$newTypes$examples.component1();
            Map newTypes = (Map)$dstr$clauses$newTypes$examples.component2();
            ExampleDeclarations examples = (ExampleDeclarations)$dstr$clauses$newTypes$examples.component3();
            accumulator$iv = part.toClauseData(clauses, newTypes, examples);
        }
        return accumulator$iv;
    }

    @NotNull
    public static final Triple<List<GherkinClause>, Map<String, Pattern>, ExampleDeclarations> firstLineToGherkin(@NotNull HttpRequest request, @NotNull Map<String, ? extends Pattern> types, @NotNull ExampleDeclarations exampleDeclarationsStore) {
        Triple triple;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)exampleDeclarationsStore, (String)"exampleDeclarationsStore");
        String string = request.getMethod();
        if (string == null) {
            throw new ContractException("Can't generate a spec file without the http method.", null, null, null, 14, null);
        }
        String method = string;
        if (request.getPath() == null) {
            throw new ContractException("Can't generate a contract without the url.", null, null, null, 14, null);
        }
        Map<String, String> map = request.getQueryParams();
        boolean bl = false;
        if (!map.isEmpty()) {
            map = JSONObjectValueKt.dictionaryToDeclarations(HttpRequestKt.stringMapToValueMap(request.getQueryParams()), types, exampleDeclarationsStore);
            Map dictionaryType = (Map)map.component1();
            Map newTypes = (Map)map.component2();
            ExampleDeclarations examples = (ExampleDeclarations)map.component3();
            String query2 = CollectionsKt.joinToString$default((Iterable)dictionaryType.entrySet(), (CharSequence)"&", null, null, (int)0, null, (Function1)firstLineToGherkin.query.1.INSTANCE, (int)30, null);
            triple = new Triple((Object)Intrinsics.stringPlus((String)"?", (Object)query2), (Object)newTypes, (Object)examples);
        } else {
            triple = new Triple((Object)"", (Object)MapsKt.emptyMap(), (Object)exampleDeclarationsStore);
        }
        string = triple;
        String query3 = (String)string.component1();
        Map newTypes = (Map)string.component2();
        ExampleDeclarations newExamples = (ExampleDeclarations)string.component3();
        String path = Intrinsics.stringPlus((String)request.getPath(), (Object)query3);
        GherkinClause requestLineGherkin = new GherkinClause(method + ' ' + path, GherkinSection.When);
        return new Triple((Object)CollectionsKt.listOf((Object)requestLineGherkin), (Object)newTypes, (Object)newExamples);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Triple<List<GherkinClause>, Map<String, Pattern>, ExampleDeclarations> formFieldsToGherkin(@NotNull Map<String, String> formFields, @NotNull Map<String, ? extends Pattern> types, @NotNull ExampleDeclarations exampleDeclarations) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(formFields, (String)"formFields");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)exampleDeclarations, (String)"exampleDeclarations");
        Triple<Map<String, DeferredPattern>, Map<String, Pattern>, ExampleDeclarations> triple = JSONObjectValueKt.dictionaryToDeclarations(HttpRequestKt.stringMapToValueMap(formFields), types, exampleDeclarations);
        Map dictionaryTypeMap = (Map)triple.component1();
        Map newTypes = (Map)triple.component2();
        ExampleDeclarations newExamples = (ExampleDeclarations)triple.component3();
        Iterable $this$map$iv = dictionaryTypeMap.entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void entry;
            Map.Entry entry2 = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            GherkinClause gherkinClause = new GherkinClause("form-field " + (String)entry.getKey() + ' ' + ((DeferredPattern)entry.getValue()).getPattern(), GherkinSection.When);
            collection.add(gherkinClause);
        }
        List formFieldClauses = (List)destination$iv$iv;
        return new Triple((Object)formFieldClauses, (Object)newTypes, (Object)exampleDeclarations.plus(newExamples));
    }

    public static final /* synthetic */ void access$setIfNotEmpty(Map dest, String key, Map data) {
        HttpRequestKt.setIfNotEmpty(dest, key, data);
    }
}

