/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core;

import in.specmatic.core.HttpRequestKt;
import in.specmatic.core.HttpResponseKt;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.pattern.GrammarKt;
import in.specmatic.core.value.EmptyStringKt;
import in.specmatic.core.value.JSONObjectValue;
import in.specmatic.core.value.NullValue;
import in.specmatic.core.value.NumberValue;
import in.specmatic.core.value.StringValue;
import in.specmatic.core.value.Value;
import io.ktor.http.HttpStatusCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u0000 *2\u00020\u0001:\u0001*B3\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bB9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007\u0012\b\b\u0002\u0010\u0004\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J=\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00072\b\b\u0002\u0010\u0004\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J&\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00072\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005J\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u00020\u00052\b\b\u0002\u0010&\u001a\u00020\u0005J\t\u0010'\u001a\u00020\u0005H\u00d6\u0001J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000f\u00a8\u0006+"}, d2={"Lin/specmatic/core/HttpResponse;", "", "status", "", "body", "", "headers", "", "(ILjava/lang/String;Ljava/util/Map;)V", "Lin/specmatic/core/value/Value;", "externalisedResponseCommand", "(ILjava/util/Map;Lin/specmatic/core/value/Value;Ljava/lang/String;)V", "getBody", "()Lin/specmatic/core/value/Value;", "getExternalisedResponseCommand", "()Ljava/lang/String;", "getHeaders", "()Ljava/util/Map;", "getStatus", "()I", "statusText", "getStatusText", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "export", "bindings", "hashCode", "selectValue", "selector", "toJSON", "Lin/specmatic/core/value/JSONObjectValue;", "toLogString", "prefix", "toString", "updateBodyWith", "content", "Companion", "core"})
public final class HttpResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int status;
    @NotNull
    private final Map<String, String> headers;
    @NotNull
    private final Value body;
    @NotNull
    private final String externalisedResponseCommand;
    @NotNull
    private static final HttpResponse ERROR_400 = new HttpResponse(400, "This request did not match any scenario.", MapsKt.emptyMap());
    @NotNull
    private static final HttpResponse OK = new HttpResponse(200, MapsKt.emptyMap(), null, null, 12, null);
    @NotNull
    private static final HttpResponse EMPTY = new HttpResponse(0, MapsKt.emptyMap(), null, null, 12, null);

    public HttpResponse(int status, @NotNull Map<String, String> headers, @NotNull Value body, @NotNull String externalisedResponseCommand) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)externalisedResponseCommand, (String)"externalisedResponseCommand");
        this.status = status;
        this.headers = headers;
        this.body = body;
        this.externalisedResponseCommand = externalisedResponseCommand;
    }

    public /* synthetic */ HttpResponse(int n, Map map, Value value, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"text/plain"));
        }
        if ((n2 & 4) != 0) {
            value = EmptyStringKt.getEmptyString();
        }
        if ((n2 & 8) != 0) {
            string = "";
        }
        this(n, map, value, string);
    }

    public final int getStatus() {
        return this.status;
    }

    @NotNull
    public final Map<String, String> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final Value getBody() {
        return this.body;
    }

    @NotNull
    public final String getExternalisedResponseCommand() {
        return this.externalisedResponseCommand;
    }

    /*
     * WARNING - void declaration
     */
    public HttpResponse(int status, @Nullable String body, @NotNull Map<String, String> headers) {
        Value value;
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        HttpResponse httpResponse = this;
        int n = status;
        Map<String, String> map = headers;
        String string = body;
        if (string == null) {
            value = null;
        } else {
            void it;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String string3 = string2;
            Map<String, String> map2 = map;
            int n2 = n;
            HttpResponse httpResponse2 = httpResponse;
            boolean bl3 = false;
            Value value2 = GrammarKt.parsedValue((String)it);
            httpResponse = httpResponse2;
            n = n2;
            map = map2;
            value = value2;
        }
        Value value3 = value;
        httpResponse(n, map, value3 == null ? (Value)EmptyStringKt.getEmptyString() : value3, null, 8, null);
    }

    public /* synthetic */ HttpResponse(int n, String string, Map map, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            string = "";
        }
        if ((n2 & 4) != 0) {
            map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"text/plain"));
        }
        this(n, string, map);
    }

    private final String getStatusText() {
        int n = this.status;
        return n == 0 ? "" : HttpStatusCode.Companion.fromValue(this.status).getDescription();
    }

    @NotNull
    public final HttpResponse updateBodyWith(@NotNull Value content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Map map = MapsKt.plus((Map)MapsKt.minus(this.headers, (Object)"Content-Type"), (Pair)TuplesKt.to((Object)"Content-Type", (Object)content.getHttpContentType()));
        return HttpResponse.copy$default(this, 0, map, content, null, 9, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JSONObjectValue toJSON() {
        boolean bl = false;
        Map map = new LinkedHashMap();
        boolean bl2 = false;
        boolean bl3 = false;
        Map json = map;
        boolean bl4 = false;
        Map map2 = json;
        String string = "status";
        Value value = new NumberValue(this.getStatus());
        boolean bl5 = false;
        map2.put(string, value);
        map2 = json;
        string = "body";
        value = this.getBody();
        bl5 = false;
        map2.put(string, value);
        map2 = this.getStatusText();
        boolean bl6 = false;
        if (map2.length() > 0) {
            map2 = json;
            String string2 = "status-text";
            value = new StringValue(this.getStatusText());
            bl5 = false;
            map2.put(string2, value);
        }
        map2 = this.getHeaders();
        boolean bl7 = false;
        if (!map2.isEmpty()) {
            Map map3;
            void $this$mapValuesTo$iv$iv;
            map2 = json;
            String string3 = "headers";
            Map<String, String> $this$mapValues$iv = this.getHeaders();
            boolean $i$f$mapValues = false;
            Map<String, String> map4 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map5 = destination$iv$iv;
                boolean bl8 = false;
                Object k = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                map3 = map5;
                boolean bl9 = false;
                StringValue stringValue = new StringValue((String)it.getValue());
                map3.put(k2, stringValue);
            }
            Map map6 = map3 = destination$iv$iv;
            value = new JSONObjectValue(map6);
            bl5 = false;
            map2.put(string3, value);
        }
        Unit unit = Unit.INSTANCE;
        Map map7 = map;
        return new JSONObjectValue(map7);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toLogString(@NotNull String prefix2) {
        void $this$mapTo$iv$iv22;
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        String statusLine = "" + this.status + ' ' + this.getStatusText();
        Map<String, String> $this$map$iv = this.headers;
        boolean $i$f$map22 = false;
        Map<String, String> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var9_11 = $this$mapTo$iv$iv22;
        boolean bl = false;
        Iterator iterator = var9_11.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String string = (String)it.getKey() + ": " + (String)it.getValue();
            collection.add(string);
        }
        String headerString2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        Object $i$f$map22 = new String[]{statusLine, headerString2};
        $i$f$map22 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])$i$f$map22), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        boolean $this$mapTo$iv$iv22 = false;
        if ($i$f$map22 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String firstPart = ((Object)StringsKt.trim((CharSequence)((CharSequence)$i$f$map22))).toString();
        String formattedBody = this.body.toStringLiteral();
        Object[] objectArray = new String[]{firstPart, "", formattedBody};
        String responseString = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return HttpRequestKt.startLinesWith(responseString, prefix2);
    }

    public static /* synthetic */ String toLogString$default(HttpResponse httpResponse, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return httpResponse.toLogString(string);
    }

    @NotNull
    public final String selectValue(@NotNull String selector) {
        String string;
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        if (StringsKt.startsWith$default((String)selector, (String)"response-header.", (boolean)false, (int)2, null)) {
            String string2 = StringsKt.removePrefix((String)selector, (CharSequence)"response-header.");
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String headerName = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            string2 = this.headers.get(headerName);
            if (string2 == null) {
                throw new ContractException("Couldn't find header name " + headerName + " specified in " + selector, null, null, null, 14, null);
            }
            string = string2;
        } else if (StringsKt.startsWith$default((String)selector, (String)"response-body", (boolean)false, (int)2, null)) {
            String string4 = StringsKt.removePrefix((String)selector, (CharSequence)"response-body");
            boolean bl = false;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String bodySelector = ((Object)StringsKt.trim((CharSequence)string5)).toString();
            if (StringsKt.isBlank((CharSequence)bodySelector)) {
                string = this.body.toStringLiteral();
            } else {
                String string6;
                if (!(this.body instanceof JSONObjectValue)) {
                    throw new ContractException("JSON selector can only be used for JSON body", null, null, null, 14, null);
                }
                String jsonBodySelector = StringsKt.removePrefix((String)bodySelector, (CharSequence)".");
                Value value = ((JSONObjectValue)this.body).findFirstChildByPath(jsonBodySelector);
                String string7 = string6 = value == null ? null : value.toStringLiteral();
                if (string6 == null) {
                    throw new ContractException("JSON selector " + selector + " was not found", null, null, null, 14, null);
                }
                string = string6;
            }
        } else {
            throw new ContractException("Selector " + selector + " is unexpected. It must either start with response-header or response-body.", null, null, null, 14, null);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> export(@NotNull Map<String, String> bindings) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(bindings, (String)"bindings");
        Iterable iterable = bindings.entrySet();
        Map initial$iv = MapsKt.emptyMap();
        boolean $i$f$fold = false;
        Map accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void setter;
            Map.Entry entry = (Map.Entry)element$iv;
            Map acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = MapsKt.plus((Map)acc, (Pair)TuplesKt.to(setter.getKey(), (Object)this.selectValue((String)setter.getValue())));
        }
        return accumulator$iv;
    }

    public final int component1() {
        return this.status;
    }

    @NotNull
    public final Map<String, String> component2() {
        return this.headers;
    }

    @NotNull
    public final Value component3() {
        return this.body;
    }

    @NotNull
    public final String component4() {
        return this.externalisedResponseCommand;
    }

    @NotNull
    public final HttpResponse copy(int status, @NotNull Map<String, String> headers, @NotNull Value body, @NotNull String externalisedResponseCommand) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)externalisedResponseCommand, (String)"externalisedResponseCommand");
        return new HttpResponse(status, headers, body, externalisedResponseCommand);
    }

    public static /* synthetic */ HttpResponse copy$default(HttpResponse httpResponse, int n, Map map, Value value, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = httpResponse.status;
        }
        if ((n2 & 2) != 0) {
            map = httpResponse.headers;
        }
        if ((n2 & 4) != 0) {
            value = httpResponse.body;
        }
        if ((n2 & 8) != 0) {
            string = httpResponse.externalisedResponseCommand;
        }
        return httpResponse.copy(n, map, value, string);
    }

    @NotNull
    public String toString() {
        return "HttpResponse(status=" + this.status + ", headers=" + this.headers + ", body=" + this.body + ", externalisedResponseCommand=" + this.externalisedResponseCommand + ')';
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.status);
        result2 = result2 * 31 + ((Object)this.headers).hashCode();
        result2 = result2 * 31 + this.body.hashCode();
        result2 = result2 * 31 + this.externalisedResponseCommand.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpResponse)) {
            return false;
        }
        HttpResponse httpResponse = (HttpResponse)other;
        if (this.status != httpResponse.status) {
            return false;
        }
        if (!Intrinsics.areEqual(this.headers, httpResponse.headers)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.body, (Object)httpResponse.body)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.externalisedResponseCommand, (Object)httpResponse.externalisedResponseCommand);
    }

    public HttpResponse() {
        this(0, null, null, null, 15, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\rJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\u000eJ\u001a\u0010\u0013\u001a\u00020\u00042\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\u0015J\u0010\u0010\u0016\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u0018\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lin/specmatic/core/HttpResponse$Companion;", "", "()V", "EMPTY", "Lin/specmatic/core/HttpResponse;", "getEMPTY", "()Lin/specmatic/core/HttpResponse;", "ERROR_400", "getERROR_400", "OK", "getOK", "body", "Lin/specmatic/core/value/Value;", "", "", "bodyToHttpResponse", "status", "", "from", "fromJSON", "jsonObject", "", "jsonResponse", "jsonData", "xmlResponse", "xmlData", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HttpResponse getERROR_400() {
            return ERROR_400;
        }

        @NotNull
        public final HttpResponse getOK() {
            return OK;
        }

        @NotNull
        public final HttpResponse OK(@NotNull Number body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            NumberValue bodyValue = new NumberValue(body);
            return new HttpResponse(200, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)bodyValue.getHttpContentType())), bodyValue, null, 8, null);
        }

        @NotNull
        public final HttpResponse OK(@NotNull String body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            StringValue bodyValue = new StringValue(body);
            return new HttpResponse(200, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)bodyValue.getHttpContentType())), bodyValue, null, 8, null);
        }

        @NotNull
        public final HttpResponse OK(@NotNull Value body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            return new HttpResponse(200, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)body.getHttpContentType())), body, null, 8, null);
        }

        @NotNull
        public final HttpResponse getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final HttpResponse jsonResponse(@Nullable String jsonData) {
            return new HttpResponse(200, jsonData, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"application/json")));
        }

        @NotNull
        public final HttpResponse xmlResponse(@Nullable String xmlData) {
            return new HttpResponse(200, xmlData, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"application/xml")));
        }

        @NotNull
        public final HttpResponse from(int status, @Nullable String body) {
            return this.bodyToHttpResponse(body, status);
        }

        private final HttpResponse bodyToHttpResponse(String body, int status) {
            Value bodyValue = GrammarKt.parsedValue(body);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Content-Type", (Object)bodyValue.getHttpContentType())};
            return new HttpResponse(status, MapsKt.mutableMapOf((Pair[])pairArray), bodyValue, null, 8, null);
        }

        @NotNull
        public final HttpResponse fromJSON(@NotNull Map<String, ? extends Value> jsonObject) {
            Intrinsics.checkNotNullParameter(jsonObject, (String)"jsonObject");
            Value body = jsonObject.get("body");
            if (body instanceof NullValue) {
                throw new ContractException("Either body should have a value or the key should be absent from http-request", null, null, null, 14, null);
            }
            Object object = HttpResponseKt.nativeInteger(jsonObject, "status");
            if (object == null) {
                throw new ContractException("http-response must contain a key named status, whose value is the http status in the response", null, null, null, 14, null);
            }
            int n = (Integer)object;
            object = jsonObject;
            String string = "externalisedResponseCommand";
            String string2 = "";
            boolean bl = false;
            return new HttpResponse(n, MapsKt.toMutableMap(HttpRequestKt.nativeStringStringMap(jsonObject, "headers")), jsonObject.getOrDefault("body", new StringValue(null, 1, null)), object.getOrDefault(string, string2).toString());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

