/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core;

import in.specmatic.core.Configuration;
import in.specmatic.core.Feature;
import in.specmatic.core.FeatureKt;
import in.specmatic.core.SpecmaticConfigJson;
import in.specmatic.core.SpecmaticConfigKt;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.utilities.Utilities;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001\u001a\u0010\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001\u001a\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0001\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u000e\u0010\t\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"APPLICATION_NAME", "", "APPLICATION_NAME_LOWER_CASE", "APPLICATION_NAME_LOWER_CASE_LEGACY", "CONTRACT_EXTENSION", "CONTRACT_EXTENSIONS", "", "getCONTRACT_EXTENSIONS", "()Ljava/util/List;", "DATA_DIR_SUFFIX", "DEFAULT_WORKING_DIRECTORY", "LEGACY_CONTRACT_EXTENSION", "SPECMATIC_GITHUB_ISSUES", "SpecmaticJsonFormat", "Lkotlinx/serialization/json/Json;", "getSpecmaticJsonFormat", "()Lkotlinx/serialization/json/Json;", "invalidContractExtensionMessage", "filename", "loadSpecmaticJsonConfig", "Lin/specmatic/core/SpecmaticConfigJson;", "configFileName", "isContractFile", "", "loadContract", "Lin/specmatic/core/Feature;", "core"})
public final class SpecmaticConfigKt {
    @NotNull
    public static final String APPLICATION_NAME = "Specmatic";
    @NotNull
    public static final String APPLICATION_NAME_LOWER_CASE = "specmatic";
    @NotNull
    public static final String APPLICATION_NAME_LOWER_CASE_LEGACY = "qontract";
    @NotNull
    public static final String CONTRACT_EXTENSION = "spec";
    @NotNull
    public static final String LEGACY_CONTRACT_EXTENSION = "qontract";
    @NotNull
    private static final List<String> CONTRACT_EXTENSIONS;
    @NotNull
    public static final String DATA_DIR_SUFFIX = "_data";
    @NotNull
    public static final String SPECMATIC_GITHUB_ISSUES = "https://github.com/znsio/specmatic/issues";
    @NotNull
    public static final String DEFAULT_WORKING_DIRECTORY = ".specmatic";
    @NotNull
    private static final Json SpecmaticJsonFormat;

    @NotNull
    public static final List<String> getCONTRACT_EXTENSIONS() {
        return CONTRACT_EXTENSIONS;
    }

    @NotNull
    public static final String invalidContractExtensionMessage(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return "The file " + filename + " does not seem like a contract file. Valid extensions for contract files are " + CollectionsKt.joinToString$default((Iterable)CONTRACT_EXTENSIONS, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
    }

    public static final boolean isContractFile(@NotNull String $this$isContractFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isContractFile, (String)"<this>");
        return CONTRACT_EXTENSIONS.contains(FilesKt.getExtension((File)new File($this$isContractFile)));
    }

    @NotNull
    public static final Feature loadContract(@NotNull String $this$loadContract) {
        Intrinsics.checkNotNullParameter((Object)$this$loadContract, (String)"<this>");
        if (!SpecmaticConfigKt.isContractFile($this$loadContract)) {
            throw new ContractException(SpecmaticConfigKt.invalidContractExtensionMessage($this$loadContract), null, null, null, 14, null);
        }
        return FeatureKt.parseGherkinStringToFeature$default(Utilities.readFile($this$loadContract), null, 2, null);
    }

    @NotNull
    public static final Json getSpecmaticJsonFormat() {
        return SpecmaticJsonFormat;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SpecmaticConfigJson loadSpecmaticJsonConfig(@Nullable String configFileName) {
        void $this$decodeFromString$iv;
        StringFormat stringFormat = (StringFormat)SpecmaticJsonFormat;
        String string = configFileName;
        String string$iv = FilesKt.readText$default((File)new File(string == null ? Configuration.Companion.getGlobalConfigFileName() : string), null, (int)1, null);
        boolean $i$f$decodeFromString = false;
        SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(SpecmaticConfigJson.class));
        boolean $i$f$cast = false;
        return (SpecmaticConfigJson)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, string$iv);
    }

    static {
        Object[] objectArray = new String[]{CONTRACT_EXTENSION, "qontract", "yaml", "wsdl"};
        CONTRACT_EXTENSIONS = CollectionsKt.listOf((Object[])objectArray);
        SpecmaticJsonFormat = JsonKt.Json$default(null, (Function1)SpecmaticJsonFormat.1.INSTANCE, (int)1, null);
    }
}

