/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core;

import in.specmatic.core.FailureReason;
import in.specmatic.core.HttpRequest;
import in.specmatic.core.MatchFailure;
import in.specmatic.core.MatchSuccess;
import in.specmatic.core.MatchingResult;
import in.specmatic.core.RailwayOrientedProgrammingKt;
import in.specmatic.core.Resolver;
import in.specmatic.core.Result;
import in.specmatic.core.ResultKt;
import in.specmatic.core.URLMatcher;
import in.specmatic.core.URLMatcherKt;
import in.specmatic.core.URLPathPattern;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.pattern.ContractExceptionKt;
import in.specmatic.core.pattern.ExactValuePattern;
import in.specmatic.core.pattern.GrammarKt;
import in.specmatic.core.pattern.JSONArrayPatternKt;
import in.specmatic.core.pattern.Pattern;
import in.specmatic.core.pattern.Row;
import in.specmatic.core.pattern.TabularPatternKt;
import in.specmatic.core.value.Value;
import io.ktor.util.reflect.TypeInfoJvmKt;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0004H\u00c6\u0003J9\u0010\u0014\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0019\u001a\u00020\u001aJ\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001aJ.\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#2\u0014\b\u0002\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010%\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J.\u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001a0'0&2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001a0'H\u0002J.\u0010)\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001a0'0&2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001a0'H\u0002J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00000\u00072\u0006\u0010\u0019\u001a\u00020\u001aJ\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00000\u00072\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0019\u001a\u00020\u001aJ\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0006\u0010.\u001a\u00020\u0004J\b\u0010/\u001a\u00020\u0004H\u0016R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00060"}, d2={"Lin/specmatic/core/URLMatcher;", "", "queryPattern", "", "", "Lin/specmatic/core/pattern/Pattern;", "pathPattern", "", "Lin/specmatic/core/URLPathPattern;", "path", "(Ljava/util/Map;Ljava/util/List;Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "getPathPattern", "()Ljava/util/List;", "getQueryPattern", "()Ljava/util/Map;", "component1", "component2", "component3", "copy", "equals", "", "other", "generatePath", "resolver", "Lin/specmatic/core/Resolver;", "generateQuery", "hashCode", "", "matches", "Lin/specmatic/core/Result;", "httpRequest", "Lin/specmatic/core/HttpRequest;", "uri", "Ljava/net/URI;", "sampleQuery", "matchesPath", "Lin/specmatic/core/MatchingResult;", "Lkotlin/Pair;", "parameters", "matchesQuery", "newBasedOn", "row", "Lin/specmatic/core/pattern/Row;", "pathParameters", "toOpenApiPath", "toString", "core"})
public final class URLMatcher {
    @NotNull
    private final Map<String, Pattern> queryPattern;
    @NotNull
    private final List<URLPathPattern> pathPattern;
    @NotNull
    private final String path;

    public URLMatcher(@NotNull Map<String, ? extends Pattern> queryPattern, @NotNull List<URLPathPattern> pathPattern, @NotNull String path) {
        Intrinsics.checkNotNullParameter(queryPattern, (String)"queryPattern");
        Intrinsics.checkNotNullParameter(pathPattern, (String)"pathPattern");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.queryPattern = queryPattern;
        this.pathPattern = pathPattern;
        this.path = path;
    }

    @NotNull
    public final Map<String, Pattern> getQueryPattern() {
        return this.queryPattern;
    }

    @NotNull
    public final List<URLPathPattern> getPathPattern() {
        return this.pathPattern;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final Result matches(@NotNull URI uri, @NotNull Map<String, String> sampleQuery, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(sampleQuery, (String)"sampleQuery");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        HttpRequest httpRequest = new HttpRequest(null, uri.getPath(), null, null, sampleQuery, null, null, 109, null);
        return this.matches(httpRequest, resolver);
    }

    public static /* synthetic */ Result matches$default(URLMatcher uRLMatcher, URI uRI, Map map, Resolver resolver, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            resolver = new Resolver();
        }
        return uRLMatcher.matches(uRI, map, resolver);
    }

    @NotNull
    public final Result matches(@NotNull HttpRequest httpRequest, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return RailwayOrientedProgrammingKt.toResult(RailwayOrientedProgrammingKt.otherwise(RailwayOrientedProgrammingKt.then(RailwayOrientedProgrammingKt.to(TuplesKt.to((Object)httpRequest, (Object)resolver), (Function1)new Function1<Pair<? extends HttpRequest, ? extends Resolver>, MatchingResult<Pair<? extends HttpRequest, ? extends Resolver>>>((Object)this){

            @NotNull
            public final MatchingResult<Pair<HttpRequest, Resolver>> invoke(@NotNull Pair<HttpRequest, Resolver> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return URLMatcher.access$matchesPath((URLMatcher)this.receiver, p0);
            }
        }), (Function1)new Function1<Pair<? extends HttpRequest, ? extends Resolver>, MatchingResult<Pair<? extends HttpRequest, ? extends Resolver>>>((Object)this){

            @NotNull
            public final MatchingResult<Pair<HttpRequest, Resolver>> invoke(@NotNull Pair<HttpRequest, Resolver> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return URLMatcher.access$matchesQuery((URLMatcher)this.receiver, p0);
            }
        }), matches.3.INSTANCE), (Function1<? super Result, ? extends Result>)((Function1)matches.4.INSTANCE));
    }

    private final MatchingResult<Pair<HttpRequest, Resolver>> matchesPath(Pair<HttpRequest, Resolver> parameters) {
        Pair<HttpRequest, Resolver> pair = parameters;
        HttpRequest httpRequest = (HttpRequest)pair.component1();
        Resolver resolver = (Resolver)pair.component2();
        String string = httpRequest.getPath();
        Intrinsics.checkNotNull((Object)string);
        Result pathResult = this.matchesPath(new URI(string), resolver);
        return pathResult instanceof Result.Failure ? (MatchingResult)new MatchFailure(Result.Failure.copy$default((Result.Failure)pathResult, null, null, null, FailureReason.URLPathMisMatch, 7, null)) : (MatchingResult)new MatchSuccess<Pair<HttpRequest, Resolver>>(parameters);
    }

    private final MatchingResult<Pair<HttpRequest, Resolver>> matchesQuery(Pair<HttpRequest, Resolver> parameters) {
        Pair<HttpRequest, Resolver> pair = parameters;
        HttpRequest httpRequest = (HttpRequest)pair.component1();
        Resolver resolver = (Resolver)pair.component2();
        Result queryResult = URLMatcherKt.matchesQuery(this.queryPattern, httpRequest.getQueryParams(), resolver);
        return queryResult instanceof Result.Failure ? (MatchingResult)new MatchFailure(((Result.Failure)queryResult).breadCrumb("QUERY-PARAMS")) : (MatchingResult)new MatchSuccess<Pair<HttpRequest, Resolver>>(parameters);
    }

    /*
     * WARNING - void declaration
     */
    private final Result matchesPath(URI uri, Resolver resolver) {
        void $this$toTypedArray$iv;
        boolean bl;
        Object object;
        void $this$filterTo$iv$iv;
        Collection $this$filter$iv;
        Object object2 = uri.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"uri.path");
        object2 = (CharSequence)object2;
        String string = "/";
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl2 = false;
        object2 = string.split((CharSequence)object2, n);
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            object = it;
            bl = false;
            boolean bl4 = object.length() > 0;
            if (!bl4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new String[0]);
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] pathParts = objectArray;
        if (this.pathPattern.size() != pathParts.length) {
            return new Result.Failure("Expected " + uri + " (having " + pathParts.length + " path segments) to match " + this.path + " (which has " + this.pathPattern.size() + " path segments).", null, "PATH", null, 10, null);
        }
        Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)this.pathPattern, (Object[])pathParts);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Result.Failure failure;
            String it;
            boolean bl5;
            boolean bl6;
            String string2;
            String string3;
            Object failure2;
            boolean bl7;
            Pair $dstr$urlPathPattern$token = (Pair)element$iv;
            boolean bl8 = false;
            URLPathPattern urlPathPattern = (URLPathPattern)$dstr$urlPathPattern$token.component1();
            String token = (String)$dstr$urlPathPattern$token.component2();
            try {
                Value parsedValue = urlPathPattern.tryParse(token, resolver);
                Result result2 = resolver.matchesPattern(urlPathPattern.getKey(), urlPathPattern.getPattern(), parsedValue);
                if (!(result2 instanceof Result.Failure)) continue;
                String string4 = urlPathPattern.getKey();
                return string4 == null ? (Result)((Result.Failure)result2).breadCrumb("PATH (" + uri + ')') : (Result)((Result.Failure)result2).breadCrumb("PATH (" + uri + ')').breadCrumb(urlPathPattern.getKey());
            }
            catch (ContractException e) {
                object = e.failure().breadCrumb("PATH (" + uri + ')');
                bl = false;
                bl7 = false;
                failure2 = object;
                boolean bl9 = false;
                string3 = urlPathPattern.getKey();
                if (string3 == null) continue;
                string2 = string3;
                bl6 = false;
                bl5 = false;
                it = string2;
                boolean bl10 = false;
                failure = ((Result.Failure)failure2).breadCrumb(urlPathPattern.getKey());
                if (failure != null) continue;
            }
            catch (Throwable e) {
                object = e.getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.localizedMessage");
                object = new Result.Failure((String)object, null, null, null, 14, null).breadCrumb("PATH (" + uri + ')');
                bl = false;
                bl7 = false;
                failure2 = object;
                boolean bl11 = false;
                string3 = urlPathPattern.getKey();
                if (string3 == null) continue;
                string2 = string3;
                bl6 = false;
                bl5 = false;
                it = string2;
                boolean bl12 = false;
                failure = ((Result.Failure)failure2).breadCrumb(urlPathPattern.getKey());
                if (failure != null) continue;
            }
        }
        return new Result.Success(null, 1, null);
    }

    @NotNull
    public final String generatePath(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return (String)ContractExceptionKt.attempt$default(null, "PATH", (Function0)new Function0<String>(this, resolver){
            final /* synthetic */ URLMatcher this$0;
            final /* synthetic */ Resolver $resolver;
            {
                this.this$0 = $receiver;
                this.$resolver = $resolver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke() {
                Collection<Value> collection;
                void $this$mapIndexedTo$iv$iv;
                void $this$mapIndexed$iv;
                Iterable iterable = this.this$0.getPathPattern();
                Resolver resolver = this.$resolver;
                String string = "/";
                boolean $i$f$mapIndexed = false;
                void var4_5 = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void urlPathPattern;
                    void index;
                    int n = index$iv$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    URLPathPattern uRLPathPattern = (URLPathPattern)item$iv$iv;
                    int n2 = n;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    Value value = (Value)ContractExceptionKt.attempt$default(null, "" + '[' + (int)index + ']', (Function0)new Function0<Value>((URLPathPattern)urlPathPattern, resolver){
                        final /* synthetic */ URLPathPattern $urlPathPattern;
                        final /* synthetic */ Resolver $resolver;
                        {
                            this.$urlPathPattern = $urlPathPattern;
                            this.$resolver = $resolver;
                            super(0);
                        }

                        @NotNull
                        public final Value invoke() {
                            String key = this.$urlPathPattern.getKey();
                            return key != null ? this.$resolver.generate(key, this.$urlPathPattern.getPattern()) : this.$urlPathPattern.getPattern().generate(this.$resolver);
                        }
                    }, 1, null);
                    collection.add(value);
                }
                collection = (List)destination$iv$iv;
                return Intrinsics.stringPlus((String)string, (Object)CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null));
            }
        }, 1, null);
    }

    @NotNull
    public final Map<String, String> generateQuery(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return (Map)ContractExceptionKt.attempt$default(null, "QUERY-PARAMS", (Function0)new Function0<Map<String, ? extends String>>(this, resolver){
            final /* synthetic */ URLMatcher this$0;
            final /* synthetic */ Resolver $resolver;
            {
                this.this$0 = $receiver;
                this.$resolver = $resolver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<String, String> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Map map;
                String string;
                String string2;
                Object object;
                void $this$mapKeysTo$iv$iv;
                Map $this$mapKeys$iv = this.this$0.getQueryPattern();
                boolean $i$f$mapKeys = false;
                Map map2 = $this$mapKeys$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                boolean $i$f$mapKeysTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv$iv;
                    V it;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    object = destination$iv$iv;
                    boolean bl3 = false;
                    string2 = StringsKt.removeSuffix((String)((String)it.getKey()), (CharSequence)"?");
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    string = string2;
                    map = object;
                    boolean bl2 = false;
                    it = it$iv$iv.getValue();
                    map.put(string, it);
                }
                $this$mapKeys$iv = destination$iv$iv;
                Resolver resolver = this.$resolver;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList<E>($this$map$iv.size());
                boolean $i$f$mapTo = false;
                void var7_12 = $this$mapTo$iv$iv;
                boolean bl = false;
                Iterator<Map.Entry<K, V>> iterator = var7_12.entrySet().iterator();
                while (iterator.hasNext()) {
                    void $dstr$name$pattern;
                    Map.Entry<K, V> item$iv$iv;
                    Map.Entry<K, V> bl3 = item$iv$iv = iterator.next();
                    object = destination$iv$iv2;
                    boolean bl4 = false;
                    string = $dstr$name$pattern;
                    boolean bl5 = false;
                    String name = (String)string.getKey();
                    map = $dstr$name$pattern;
                    boolean bl6 = false;
                    Pattern pattern2 = (Pattern)map.getValue();
                    string2 = (Pair)ContractExceptionKt.attempt$default(null, name, (Function0)new Function0<Pair<? extends String, ? extends String>>(name, resolver, pattern2){
                        final /* synthetic */ String $name;
                        final /* synthetic */ Resolver $resolver;
                        final /* synthetic */ Pattern $pattern;
                        {
                            this.$name = $name;
                            this.$resolver = $resolver;
                            this.$pattern = $pattern;
                            super(0);
                        }

                        @NotNull
                        public final Pair<String, String> invoke() {
                            return TuplesKt.to((Object)this.$name, (Object)this.$resolver.generate(this.$name, this.$pattern).toString());
                        }
                    }, 1, null);
                    object.add(string2);
                }
                return MapsKt.toMap((Iterable)((List)destination$iv$iv2));
            }
        }, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<URLMatcher> newBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        void $this$flatMapTo$iv$iv;
        Object object;
        Iterable destination$iv$iv;
        void $this$mapTo$iv$iv;
        Object object2;
        Collection collection;
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Iterable $this$mapIndexed$iv = this.pathPattern;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void urlPathPattern;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            URLPathPattern uRLPathPattern = (URLPathPattern)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            String key = urlPathPattern.getKey();
            object2 = (URLPathPattern)ContractExceptionKt.attempt$default(null, "" + '[' + (int)index + ']', (Function0)new Function0<URLPathPattern>(key, row, (URLPathPattern)urlPathPattern, resolver){
                final /* synthetic */ String $key;
                final /* synthetic */ Row $row;
                final /* synthetic */ URLPathPattern $urlPathPattern;
                final /* synthetic */ Resolver $resolver;
                {
                    this.$key = $key;
                    this.$row = $row;
                    this.$urlPathPattern = $urlPathPattern;
                    this.$resolver = $resolver;
                    super(0);
                }

                @NotNull
                public final URLPathPattern invoke() {
                    URLPathPattern uRLPathPattern;
                    if (this.$key != null && this.$row.containsField(this.$key)) {
                        String rowValue = this.$row.getField(this.$key);
                        uRLPathPattern = GrammarKt.isPatternToken(rowValue) ? (URLPathPattern)ContractExceptionKt.attempt$default("Pattern mismatch in example of path param \"" + this.$urlPathPattern.getKey() + '\"', null, (Function0)new Function0<URLPathPattern>(this.$resolver, rowValue, this.$urlPathPattern){
                            final /* synthetic */ Resolver $resolver;
                            final /* synthetic */ String $rowValue;
                            final /* synthetic */ URLPathPattern $urlPathPattern;
                            {
                                this.$resolver = $resolver;
                                this.$rowValue = $rowValue;
                                this.$urlPathPattern = $urlPathPattern;
                                super(0);
                            }

                            @NotNull
                            public final URLPathPattern invoke() {
                                Pattern rowPattern = this.$resolver.getPattern(this.$rowValue);
                                Result result2 = Pattern.DefaultImpls.encompasses$default(this.$urlPathPattern, rowPattern, this.$resolver, this.$resolver, null, 8, null);
                                if (!(result2 instanceof Result.Success)) {
                                    throw new ContractException(ResultKt.resultReport$default(result2, null, 2, null), null, null, null, 14, null);
                                }
                                return URLPathPattern.copy$default(this.$urlPathPattern, rowPattern, null, null, 6, null);
                            }
                        }, 2, null) : (URLPathPattern)ContractExceptionKt.attempt$default("Format error in example of \"" + this.$key + '\"', null, (Function0)new Function0<URLPathPattern>(this.$urlPathPattern, rowValue, this.$resolver){
                            final /* synthetic */ URLPathPattern $urlPathPattern;
                            final /* synthetic */ String $rowValue;
                            final /* synthetic */ Resolver $resolver;
                            {
                                this.$urlPathPattern = $urlPathPattern;
                                this.$rowValue = $rowValue;
                                this.$resolver = $resolver;
                                super(0);
                            }

                            @NotNull
                            public final URLPathPattern invoke() {
                                return new URLPathPattern(new ExactValuePattern(this.$urlPathPattern.parse(this.$rowValue, this.$resolver), null, 2, null), null, null, 6, null);
                            }
                        }, 2, null);
                    } else {
                        uRLPathPattern = this.$urlPathPattern;
                    }
                    return uRLPathPattern;
                }
            }, 1, null);
            collection.add(object2);
        }
        List<List<Pattern>> newPathPartsList2 = JSONArrayPatternKt.newBasedOn((List)destination$iv$iv2, row, resolver);
        Iterable $this$map$iv = newPathPartsList2;
        boolean $i$f$map = false;
        destination$iv$iv2 = $this$map$iv;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void list;
            List list2 = (List)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            Iterable $this$map$iv2 = (Iterable)list;
            boolean $i$f$map2 = false;
            Iterable bl2 = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                Pattern pattern2 = (Pattern)item$iv$iv2;
                object = destination$iv$iv;
                boolean bl3 = false;
                URLPathPattern uRLPathPattern = (URLPathPattern)it;
                object.add(uRLPathPattern);
            }
            object2 = (List)destination$iv$iv;
            collection.add(object2);
        }
        List newURLPathPatternsList = (List)destination$iv$iv3;
        List newQueryParamsList2 = (List)ContractExceptionKt.attempt$default(null, "QUERY-PARAMS", (Function0)new Function0<List<? extends Map<String, ? extends Pattern>>>(this, row, resolver){
            final /* synthetic */ URLMatcher this$0;
            final /* synthetic */ Row $row;
            final /* synthetic */ Resolver $resolver;
            {
                this.this$0 = $receiver;
                this.$row = $row;
                this.$resolver = $resolver;
                super(0);
            }

            @NotNull
            public final List<Map<String, Pattern>> invoke() {
                Map<String, Pattern> optionalQueryParams = this.this$0.getQueryPattern();
                return TabularPatternKt.forEachKeyCombinationIn(optionalQueryParams, this.$row, (Function1)new Function1<Map<String, ? extends Pattern>, List<? extends Map<String, ? extends Pattern>>>(this.$row, this.$resolver){
                    final /* synthetic */ Row $row;
                    final /* synthetic */ Resolver $resolver;
                    {
                        this.$row = $row;
                        this.$resolver = $resolver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final List<Map<String, Pattern>> invoke(@NotNull Map<String, ? extends Pattern> entry) {
                        void $this$mapKeysTo$iv$iv;
                        Intrinsics.checkNotNullParameter(entry, (String)"entry");
                        Map<String, ? extends Pattern> $this$mapKeys$iv = entry;
                        boolean $i$f$mapKeys = false;
                        Map<String, ? extends Pattern> map = $this$mapKeys$iv;
                        Map destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                        boolean $i$f$mapKeysTo = false;
                        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                        boolean $i$f$associateByTo = false;
                        for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                            void it$iv$iv;
                            void it;
                            Map.Entry<K, V> entry2 = (Map.Entry)element$iv$iv$iv;
                            Map map2 = destination$iv$iv;
                            boolean bl = false;
                            String string = GrammarKt.withoutOptionality((String)it.getKey());
                            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                            String string2 = string;
                            Map map3 = map2;
                            boolean bl2 = false;
                            entry2 = it$iv$iv.getValue();
                            map3.put(string2, entry2);
                        }
                        return TabularPatternKt.newBasedOn(destination$iv$iv, this.$row, this.$resolver);
                    }
                });
            }
        }, 1, null);
        Iterable $this$flatMap$iv = newURLPathPatternsList;
        boolean $i$f$flatMap = false;
        destination$iv$iv3 = $this$flatMap$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv3;
            List newURLPathPatterns = (List)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv3 = newQueryParamsList2;
            boolean $i$f$map3 = false;
            destination$iv$iv = $this$map$iv3;
            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void newQueryParams;
                object = (Map)item$iv$iv;
                Collection collection2 = destination$iv$iv5;
                boolean bl4 = false;
                URLMatcher uRLMatcher = new URLMatcher((Map<String, ? extends Pattern>)newQueryParams, newURLPathPatterns, this.getPath());
                collection2.add(uRLMatcher);
            }
            Iterable list$iv$iv = (List)destination$iv$iv5;
            CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<URLMatcher> newBasedOn(@NotNull Resolver resolver) {
        void $this$flatMapTo$iv$iv;
        Object object;
        Iterable destination$iv$iv;
        void $this$mapTo$iv$iv;
        Object object2;
        Collection collection;
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Iterable $this$mapIndexed$iv = this.pathPattern;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void urlPathPattern;
            void index;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            URLPathPattern uRLPathPattern = (URLPathPattern)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            object2 = (URLPathPattern)ContractExceptionKt.attempt$default(null, "" + '[' + (int)index + ']', (Function0)new Function0<URLPathPattern>((URLPathPattern)urlPathPattern){
                final /* synthetic */ URLPathPattern $urlPathPattern;
                {
                    this.$urlPathPattern = $urlPathPattern;
                    super(0);
                }

                @NotNull
                public final URLPathPattern invoke() {
                    return this.$urlPathPattern;
                }
            }, 1, null);
            collection.add(object2);
        }
        List<List<Pattern>> newPathPartsList2 = JSONArrayPatternKt.newBasedOn((List)destination$iv$iv2, resolver);
        Iterable $this$map$iv = newPathPartsList2;
        boolean $i$f$map = false;
        destination$iv$iv2 = $this$map$iv;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void list;
            List list2 = (List)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            Iterable $this$map$iv2 = (Iterable)list;
            boolean $i$f$map2 = false;
            Iterable bl2 = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                Pattern pattern2 = (Pattern)item$iv$iv2;
                object = destination$iv$iv;
                boolean bl3 = false;
                URLPathPattern uRLPathPattern = (URLPathPattern)it;
                object.add(uRLPathPattern);
            }
            object2 = (List)destination$iv$iv;
            collection.add(object2);
        }
        List newURLPathPatternsList = (List)destination$iv$iv3;
        List newQueryParamsList2 = (List)ContractExceptionKt.attempt$default(null, "QUERY-PARAMS", (Function0)new Function0<List<? extends Map<String, ? extends Pattern>>>(this, resolver){
            final /* synthetic */ URLMatcher this$0;
            final /* synthetic */ Resolver $resolver;
            {
                this.this$0 = $receiver;
                this.$resolver = $resolver;
                super(0);
            }

            @NotNull
            public final List<Map<String, Pattern>> invoke() {
                Map<String, Pattern> optionalQueryParams = this.this$0.getQueryPattern();
                return TabularPatternKt.allOrNothingCombinationIn(optionalQueryParams, (Function1)new Function1<Map<String, ? extends Pattern>, List<? extends Map<String, ? extends Pattern>>>(this.$resolver){
                    final /* synthetic */ Resolver $resolver;
                    {
                        this.$resolver = $resolver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final List<Map<String, Pattern>> invoke(@NotNull Map<String, ? extends Pattern> entry) {
                        void $this$mapKeysTo$iv$iv;
                        Intrinsics.checkNotNullParameter(entry, (String)"entry");
                        Map<String, ? extends Pattern> $this$mapKeys$iv = entry;
                        boolean $i$f$mapKeys = false;
                        Map<String, ? extends Pattern> map = $this$mapKeys$iv;
                        Map destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                        boolean $i$f$mapKeysTo = false;
                        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                        boolean $i$f$associateByTo = false;
                        for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                            void it$iv$iv;
                            void it;
                            Map.Entry<K, V> entry2 = (Map.Entry)element$iv$iv$iv;
                            Map map2 = destination$iv$iv;
                            boolean bl = false;
                            String string = GrammarKt.withoutOptionality((String)it.getKey());
                            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                            String string2 = string;
                            Map map3 = map2;
                            boolean bl2 = false;
                            entry2 = it$iv$iv.getValue();
                            map3.put(string2, entry2);
                        }
                        return TabularPatternKt.newBasedOn(destination$iv$iv, this.$resolver);
                    }
                });
            }
        }, 1, null);
        Iterable $this$flatMap$iv = newURLPathPatternsList;
        boolean $i$f$flatMap = false;
        destination$iv$iv3 = $this$flatMap$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv3;
            List newURLPathPatterns = (List)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv3 = newQueryParamsList2;
            boolean $i$f$map3 = false;
            destination$iv$iv = $this$map$iv3;
            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void newQueryParams;
                object = (Map)item$iv$iv;
                Collection collection2 = destination$iv$iv5;
                boolean bl4 = false;
                URLMatcher uRLMatcher = new URLMatcher((Map<String, ? extends Pattern>)newQueryParams, newURLPathPatterns, this.getPath());
                collection2.add(uRLMatcher);
            }
            Iterable list$iv$iv = (List)destination$iv$iv5;
            CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void it$iv$iv;
        String string;
        String string2;
        Object it;
        Object object;
        void $this$mapKeysTo$iv$iv;
        Map $this$mapKeys$iv;
        StringBuilder url = new StringBuilder();
        url.append(this.path);
        Object object2 = this.queryPattern;
        boolean bl = false;
        if (!object2.isEmpty()) {
            url.append("?");
        }
        object2 = this.queryPattern;
        StringBuilder stringBuilder = url;
        boolean $i$f$mapKeys = false;
        void var4_5 = $this$mapKeys$iv;
        Object destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object t : $this$associateByTo$iv$iv$iv) {
            Map.Entry entry = (Map.Entry)t;
            object = destination$iv$iv;
            boolean bl2 = false;
            string2 = StringsKt.removeSuffix((String)((String)it.getKey()), (CharSequence)"?");
            Map.Entry entry2 = (Map.Entry)t;
            string = string2;
            Map map = object;
            boolean bl3 = false;
            it = it$iv$iv.getValue();
            map.put(string, it);
        }
        object = destination$iv$iv;
        $this$mapKeys$iv = object;
        boolean $i$f$map = false;
        $this$mapKeysTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var7_8 = $this$mapTo$iv$iv;
        boolean bl4 = false;
        for (Map.Entry entry : var7_8.entrySet()) {
            void $dstr$key$value;
            it = entry;
            object = destination$iv$iv;
            boolean bl5 = false;
            it$iv$iv = $dstr$key$value;
            boolean bl2 = false;
            String key = (String)it$iv$iv.getKey();
            string = $dstr$key$value;
            boolean bl3 = false;
            Pattern value = (Pattern)string.getValue();
            string2 = key + '=' + value;
            object.add(string2);
        }
        object = (List)destination$iv$iv;
        stringBuilder.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.toList((Iterable)((Iterable)object)), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null));
        object2 = url.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"url.toString()");
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toOpenApiPath() {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        Object object = new String[]{"/"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)this.path, (String[])object, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)"(", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{":"};
            List list = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)StringsKt.replace$default((String)it, (String)"(", (String)"", (boolean)false, (int)4, null), (String)")", (String)"", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            collection.add(list);
        }
        List pathParamsWithPattern = (List)destination$iv$iv;
        object = StringsKt.replace$default((String)this.path, (String)"(", (String)"{", (boolean)false, (int)4, null);
        String string = ":[a-z,A-Z]*\\)";
        boolean bl = false;
        string = new Regex(string);
        String string2 = "}";
        boolean bl2 = false;
        return string.replace((CharSequence)object, string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<URLPathPattern> pathParameters() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.pathPattern;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            URLPathPattern it = (URLPathPattern)element$iv$iv;
            boolean bl = false;
            if (!(!TypeInfoJvmKt.instanceOf((Object)it.getPattern(), (KClass)Reflection.getOrCreateKotlinClass(ExactValuePattern.class)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Map<String, Pattern> component1() {
        return this.queryPattern;
    }

    @NotNull
    public final List<URLPathPattern> component2() {
        return this.pathPattern;
    }

    @NotNull
    public final String component3() {
        return this.path;
    }

    @NotNull
    public final URLMatcher copy(@NotNull Map<String, ? extends Pattern> queryPattern, @NotNull List<URLPathPattern> pathPattern, @NotNull String path) {
        Intrinsics.checkNotNullParameter(queryPattern, (String)"queryPattern");
        Intrinsics.checkNotNullParameter(pathPattern, (String)"pathPattern");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new URLMatcher(queryPattern, pathPattern, path);
    }

    public static /* synthetic */ URLMatcher copy$default(URLMatcher uRLMatcher, Map map, List list, String string, int n, Object object) {
        if ((n & 1) != 0) {
            map = uRLMatcher.queryPattern;
        }
        if ((n & 2) != 0) {
            list = uRLMatcher.pathPattern;
        }
        if ((n & 4) != 0) {
            string = uRLMatcher.path;
        }
        return uRLMatcher.copy(map, list, string);
    }

    public int hashCode() {
        int result2 = ((Object)this.queryPattern).hashCode();
        result2 = result2 * 31 + ((Object)this.pathPattern).hashCode();
        result2 = result2 * 31 + this.path.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof URLMatcher)) {
            return false;
        }
        URLMatcher uRLMatcher = (URLMatcher)other;
        if (!Intrinsics.areEqual(this.queryPattern, uRLMatcher.queryPattern)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.pathPattern, uRLMatcher.pathPattern)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.path, (Object)uRLMatcher.path);
    }

    public static final /* synthetic */ MatchingResult access$matchesPath(URLMatcher $this, Pair parameters) {
        return $this.matchesPath((Pair<HttpRequest, Resolver>)parameters);
    }

    public static final /* synthetic */ MatchingResult access$matchesQuery(URLMatcher $this, Pair parameters) {
        return $this.matchesQuery((Pair<HttpRequest, Resolver>)parameters);
    }
}

