/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.git;

import in.specmatic.core.Configuration;
import in.specmatic.core.OutputKt;
import in.specmatic.core.git.SystemGit;
import in.specmatic.core.pattern.GrammarKt;
import in.specmatic.core.utilities.GitRepo;
import in.specmatic.core.utilities.Utilities;
import in.specmatic.core.value.JSONObjectValue;
import in.specmatic.core.value.Value;
import io.ktor.http.CodecsKt;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u001a\b\u0010\n\u001a\u0004\u0018\u00010\u0007\u001a;\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012!\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00050\rH\u0002\u001a \u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016\u001a\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u0013H\u0002\u001a\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u0013H\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0001H\u0002\u00a8\u0006\u001d"}, d2={"clone", "Ljava/io/File;", "workingDirectory", "gitRepo", "Lin/specmatic/core/utilities/GitRepo;", "", "gitRepositoryURI", "", "cloneDirectory", "getBearerToken", "getPersonalAccessToken", "jgitClone", "onFailure", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "exception", "loadFromPath", "Lin/specmatic/core/value/Value;", "json", "path", "", "readBearerFromEnvVariable", "qontractConfig", "readBearerFromFile", "readQontractConfig", "qontractConfigFile", "resetCloneDirectory", "core"})
@JvmName(name="GitOperations")
public final class GitOperations {
    @NotNull
    public static final File clone(@NotNull File workingDirectory, @NotNull GitRepo gitRepo) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)gitRepo, (String)"gitRepo");
        File cloneDirectory = gitRepo.directoryRelativeTo(workingDirectory);
        GitOperations.resetCloneDirectory(cloneDirectory);
        GitOperations.clone(gitRepo.getGitRepositoryURL(), cloneDirectory);
        return cloneDirectory;
    }

    private static final void clone(String gitRepositoryURI, File cloneDirectory) {
        GitOperations.jgitClone(gitRepositoryURI, cloneDirectory, (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(cloneDirectory, gitRepositoryURI){
            final /* synthetic */ File $cloneDirectory;
            final /* synthetic */ String $gitRepositoryURI;
            {
                this.$cloneDirectory = $cloneDirectory;
                this.$gitRepositoryURI = $gitRepositoryURI;
                super(1);
            }

            public final void invoke(@NotNull Throwable exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                OutputKt.getInformation().forDebugging("Falling back to git command after getting error from jgit (" + exception.getClass().getName() + ": " + exception.getMessage() + ')');
                String string = this.$cloneDirectory.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cloneDirectory.parent");
                new SystemGit(string, "-").clone(this.$gitRepositoryURI, this.$cloneDirectory);
            }
        }));
    }

    private static final void resetCloneDirectory(File cloneDirectory) {
        OutputKt.getInformation().forTheUser(Intrinsics.stringPlus((String)"Resetting ", (Object)cloneDirectory.getAbsolutePath()));
        if (cloneDirectory.exists()) {
            FilesKt.deleteRecursively((File)cloneDirectory);
        }
        cloneDirectory.mkdirs();
    }

    private static final void jgitClone(String gitRepositoryURI, File cloneDirectory, Function1<? super Throwable, Unit> onFailure) {
        try {
            CloneCommand cloneCommand = Git.cloneRepository();
            boolean bl = false;
            boolean bl2 = false;
            CloneCommand $this$jgitClone_u24lambda_u2d0 = cloneCommand;
            boolean bl3 = false;
            $this$jgitClone_u24lambda_u2d0.setTransportConfigCallback(Utilities.getTransportCallingCallback$default(null, 1, null));
            $this$jgitClone_u24lambda_u2d0.setURI(gitRepositoryURI);
            $this$jgitClone_u24lambda_u2d0.setDirectory(cloneDirectory);
            CloneCommand cloneCommand2 = cloneCommand;
            String accessToken = GitOperations.getPersonalAccessToken();
            if (accessToken != null) {
                CredentialsProvider credentialsProvider = (CredentialsProvider)new UsernamePasswordCredentialsProvider(accessToken, "");
                cloneCommand2.setCredentialsProvider(credentialsProvider);
            } else {
                String ciBearerToken = GitOperations.getBearerToken();
                if (ciBearerToken != null) {
                    cloneCommand2.setTransportConfigCallback(Utilities.getTransportCallingCallback(CodecsKt.encodeOAuth((String)ciBearerToken)));
                }
            }
            cloneCommand2.call();
        }
        catch (Throwable e) {
            onFailure.invoke((Object)e);
        }
    }

    @Nullable
    public static final Value loadFromPath(@Nullable Value json, @NotNull List<String> path) {
        Value value;
        Intrinsics.checkNotNullParameter(path, (String)"path");
        if (!(json instanceof JSONObjectValue)) {
            return null;
        }
        int n = path.size();
        switch (n) {
            case 0: {
                value = null;
                break;
            }
            case 1: {
                value = ((JSONObjectValue)json).getJsonObject().get(CollectionsKt.first(path));
                break;
            }
            default: {
                value = GitOperations.loadFromPath(((JSONObjectValue)json).getJsonObject().get(CollectionsKt.first(path)), CollectionsKt.drop((Iterable)path, (int)1));
            }
        }
        return value;
    }

    @Nullable
    public static final String getBearerToken() {
        String string;
        File qontractConfigFile = new File(Configuration.Companion.getGlobalConfigFileName());
        if (qontractConfigFile.exists()) {
            Value value = GitOperations.readQontractConfig(qontractConfigFile);
            boolean bl = false;
            boolean bl2 = false;
            Value qontractConfig = value;
            boolean bl3 = false;
            String string2 = GitOperations.readBearerFromEnvVariable(qontractConfig);
            string = string2 == null ? GitOperations.readBearerFromFile(qontractConfig) : string2;
        } else {
            Object var1_2 = null;
            boolean bl = false;
            boolean bl4 = false;
            Void it = var1_2;
            boolean bl5 = false;
            OutputKt.getInformation().forTheUser(Intrinsics.stringPlus((String)Configuration.Companion.getGlobalConfigFileName(), (Object)" not found"));
            OutputKt.getInformation().forTheUser(Intrinsics.stringPlus((String)"Current working directory is ", (Object)new File(".").getAbsolutePath()));
            string = var1_2;
        }
        return string;
    }

    private static final String readBearerFromEnvVariable(Value qontractConfig) {
        String string;
        Object object = new String[]{"auth", "bearer-environment-variable"};
        Value value = GitOperations.loadFromPath(qontractConfig, CollectionsKt.listOf((Object[])object));
        if (value == null) {
            string = null;
        } else {
            object = value.toStringLiteral();
            if (object == null) {
                string = null;
            } else {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object bearerName = object2;
                boolean bl3 = false;
                OutputKt.getInformation().forTheUser(Intrinsics.stringPlus((String)"Found bearer name ", (Object)bearerName));
                String string2 = System.getenv((String)bearerName);
                boolean bl4 = false;
                boolean bl5 = false;
                String it = string2;
                boolean bl6 = false;
                if (it != null) {
                    OutputKt.getInformation().forTheUser(Intrinsics.stringPlus((String)bearerName, (Object)" is not empty"));
                }
                string = string2;
            }
        }
        return string;
    }

    private static final String readBearerFromFile(Value qontractConfig) {
        String string;
        Object object = new String[]{"auth", "bearer-file"};
        Value value = GitOperations.loadFromPath(qontractConfig, CollectionsKt.listOf((Object[])object));
        if (value == null) {
            string = null;
        } else {
            object = value.toStringLiteral();
            if (object == null) {
                string = null;
            } else {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object bearerFileName = object2;
                boolean bl3 = false;
                OutputKt.getInformation().forTheUser(Intrinsics.stringPlus((String)"Found bearer file name ", (Object)bearerFileName));
                File bearerFile = new File((String)bearerFileName).getAbsoluteFile();
                if (bearerFile.exists()) {
                    OutputKt.getInformation().forTheUser(Intrinsics.stringPlus((String)"Found bearer file ", (Object)bearerFile.getAbsolutePath()));
                    Intrinsics.checkNotNullExpressionValue((Object)bearerFile, (String)"bearerFile");
                    String string2 = FilesKt.readText$default((File)bearerFile, null, (int)1, null);
                    boolean bl4 = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                } else {
                    OutputKt.getInformation().forTheUser(Intrinsics.stringPlus((String)"Could not find bearer file ", (Object)bearerFile.getAbsolutePath()));
                    string = null;
                }
            }
        }
        return string;
    }

    @Nullable
    public static final String getPersonalAccessToken() {
        File configFile;
        File homeDir = new File(System.getProperty("user.home"));
        if (homeDir.exists() && (configFile = FilesKt.resolve((File)homeDir, (String)Configuration.Companion.getGlobalConfigFileName())).exists()) {
            Value qontractConfig = GitOperations.readQontractConfig(configFile);
            String azureAccessTokenKey = "azure-access-token";
            if (qontractConfig instanceof JSONObjectValue && ((JSONObjectValue)qontractConfig).getJsonObject().containsKey(azureAccessTokenKey)) {
                return ((JSONObjectValue)qontractConfig).getString(azureAccessTokenKey);
            }
        }
        return null;
    }

    private static final Value readQontractConfig(File qontractConfigFile) {
        return GrammarKt.parsedJSON(FilesKt.readText$default((File)qontractConfigFile, null, (int)1, null));
    }
}

