/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.git;

import in.specmatic.core.OutputKt;
import in.specmatic.core.git.GitCommand;
import in.specmatic.core.utilities.ExternalCommand;
import in.specmatic.core.utilities.Utilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0000H\u0016J\u0010\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0000H\u0016J!\u0010\u000f\u001a\u00020\u00032\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0011\"\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0012J+\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\u0010\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\u001e\u001a\u00020\u0000H\u0016J\b\u0010\u001f\u001a\u00020\u0000H\u0016J\b\u0010 \u001a\u00020\u0000H\u0016J\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00030\"2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\b\u0010#\u001a\u00020\u0000H\u0016J\b\u0010$\u001a\u00020\u0000H\u0016J\u0018\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010'\u001a\u00020\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lin/specmatic/core/git/SystemGit;", "Lin/specmatic/core/git/GitCommand;", "workingDirectory", "", "prefix", "(Ljava/lang/String;Ljava/lang/String;)V", "add", "relativePath", "checkout", "branchName", "clone", "gitRepositoryURI", "cloneDirectory", "Ljava/io/File;", "commit", "execute", "command", "", "([Ljava/lang/String;)Ljava/lang/String;", "executeCommandWithWorkingDirectory", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "fileIsInGitDir", "", "newerContractPath", "getChangedFiles", "", "gitRoot", "inGitRootOf", "contractPath", "merge", "mergeAbort", "pull", "push", "relativeGitPath", "Lkotlin/Pair;", "resetHard", "resetMixed", "show", "treeish", "workingDirectoryIsGitRepo", "core"})
public final class SystemGit
implements GitCommand {
    @NotNull
    private final String workingDirectory;
    @NotNull
    private final String prefix;

    public SystemGit(@NotNull String workingDirectory, @NotNull String prefix2) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        this.workingDirectory = workingDirectory;
        this.prefix = prefix2;
    }

    public /* synthetic */ SystemGit(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = ".";
        }
        if ((n & 2) != 0) {
            string2 = "- ";
        }
        this(string, string2);
    }

    private final String execute(String ... command) {
        Collection $this$toTypedArray$iv = ArraysKt.toList((Object[])command);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return this.executeCommandWithWorkingDirectory(this.prefix, this.workingDirectory, stringArray);
    }

    private final String executeCommandWithWorkingDirectory(String prefix2, String workingDirectory, String[] command) {
        OutputKt.getInformation().forDebugging(prefix2 + "Executing: " + ArraysKt.joinToString$default((Object[])command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        Collection $this$toTypedArray$iv = CollectionsKt.listOf((Object)"GIT_SSL_NO_VERIFY=true");
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return new ExternalCommand(command, workingDirectory, stringArray).executeAsSeparateProcess();
    }

    @Override
    @NotNull
    public SystemGit add() {
        SystemGit systemGit = this;
        boolean bl = false;
        boolean bl2 = false;
        SystemGit it = systemGit;
        boolean bl3 = false;
        String[] stringArray = new String[]{"git", "add", "."};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit add(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        SystemGit systemGit = this;
        boolean bl = false;
        boolean bl2 = false;
        SystemGit it = systemGit;
        boolean bl3 = false;
        String[] stringArray = new String[]{"git", "add", relativePath};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit commit() {
        SystemGit systemGit = this;
        boolean bl = false;
        boolean bl2 = false;
        SystemGit it = systemGit;
        boolean bl3 = false;
        String[] stringArray = new String[]{"git", "commit", "-m", "Updated contract"};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit push() {
        SystemGit systemGit = this;
        boolean bl = false;
        boolean bl2 = false;
        SystemGit it = systemGit;
        boolean bl3 = false;
        String[] stringArray = new String[]{"git", "push"};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit pull() {
        SystemGit systemGit = this;
        boolean bl = false;
        boolean bl2 = false;
        SystemGit it = systemGit;
        boolean bl3 = false;
        String[] stringArray = new String[]{"git", "pull"};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit resetHard() {
        SystemGit systemGit = this;
        boolean bl = false;
        boolean bl2 = false;
        SystemGit it = systemGit;
        boolean bl3 = false;
        String[] stringArray = new String[]{"git", "reset", "--hard", "HEAD"};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit resetMixed() {
        SystemGit systemGit = this;
        boolean bl = false;
        boolean bl2 = false;
        SystemGit it = systemGit;
        boolean bl3 = false;
        String[] stringArray = new String[]{"git", "reset", "--mixed", "HEAD"};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit mergeAbort() {
        SystemGit systemGit = this;
        boolean bl = false;
        boolean bl2 = false;
        SystemGit it = systemGit;
        boolean bl3 = false;
        String[] stringArray = new String[]{"git", "merge", "--aborg"};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit checkout(@NotNull String branchName) {
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        SystemGit systemGit = this;
        boolean bl = false;
        boolean bl2 = false;
        SystemGit it = systemGit;
        boolean bl3 = false;
        String[] stringArray = new String[]{"git", "checkout", branchName};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit merge(@NotNull String branchName) {
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        SystemGit systemGit = this;
        boolean bl = false;
        boolean bl2 = false;
        SystemGit it = systemGit;
        boolean bl3 = false;
        String[] stringArray = new String[]{"git", "merge", branchName};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit clone(@NotNull String gitRepositoryURI, @NotNull File cloneDirectory) {
        Intrinsics.checkNotNullParameter((Object)gitRepositoryURI, (String)"gitRepositoryURI");
        Intrinsics.checkNotNullParameter((Object)cloneDirectory, (String)"cloneDirectory");
        SystemGit systemGit = this;
        boolean bl = false;
        boolean bl2 = false;
        SystemGit it = systemGit;
        boolean bl3 = false;
        String[] stringArray = new String[4];
        stringArray[0] = "git";
        stringArray[1] = "clone";
        stringArray[2] = gitRepositoryURI;
        String string = cloneDirectory.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cloneDirectory.absolutePath");
        stringArray[3] = string;
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public String gitRoot() {
        Object object = new String[]{"git", "rev-parse", "--show-toplevel"};
        object = this.execute((String)object);
        boolean bl = false;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
    }

    @Override
    @NotNull
    public String show(@NotNull String treeish, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)treeish, (String)"treeish");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        String[] stringArray = new String[]{"git", "show", treeish + ':' + relativePath};
        return this.execute(stringArray);
    }

    @Override
    public boolean workingDirectoryIsGitRepo() {
        boolean bl;
        try {
            Object object = new String[]{"git", "rev-parse", "--is-inside-work-tree"};
            object = this.execute((String)object);
            boolean bl2 = false;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            bl = Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString(), (Object)"true");
        }
        catch (Throwable e) {
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean it = bl3;
            boolean bl6 = false;
            OutputKt.getInformation().forDebugging("This must not be a git dir, got error " + e.getClass().getName() + ": " + Utilities.exceptionCauseMessage(e));
            bl = bl3;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getChangedFiles() {
        void $this$mapTo$iv$iv;
        Object object = new String[]{"git", "status", "--porcelain=1"};
        object = this.execute((String[])object);
        boolean bl = false;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String result2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
        object = result2;
        bl = false;
        if (object.length() == 0) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = StringsKt.lines((CharSequence)result2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String[] stringArray = it;
            boolean bl3 = false;
            void v0 = stringArray;
            if (v0 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            stringArray = new String[]{" "};
            String string2 = (String)StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)((CharSequence)v0))).toString(), (String[])stringArray, (boolean)false, (int)2, (int)2, null).get(1);
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public Pair<SystemGit, String> relativeGitPath(@NotNull String newerContractPath) {
        Intrinsics.checkNotNullParameter((Object)newerContractPath, (String)"newerContractPath");
        String string = new File(newerContractPath).getAbsoluteFile().getParent();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(newerContractPath).absoluteFile.parent");
        File gitRoot = new File(new SystemGit(string, null, 2, null).gitRoot());
        String string2 = gitRoot.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"gitRoot.absolutePath");
        SystemGit git = new SystemGit(string2, null, 2, null);
        File file = new File(newerContractPath).getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"File(newerContractPath).absoluteFile");
        File file2 = file;
        file = gitRoot.getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"gitRoot.absoluteFile");
        String relativeContractPath = FilesKt.relativeTo((File)file2, (File)file).getPath();
        return new Pair((Object)git, (Object)relativeContractPath);
    }

    @Override
    public boolean fileIsInGitDir(@NotNull String newerContractPath) {
        Intrinsics.checkNotNullParameter((Object)newerContractPath, (String)"newerContractPath");
        String parentDir = new File(newerContractPath).getAbsoluteFile().getParentFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)parentDir, (String)"parentDir");
        return new SystemGit(parentDir, null, 2, null).workingDirectoryIsGitRepo();
    }

    @Override
    @NotNull
    public GitCommand inGitRootOf(@NotNull String contractPath) {
        Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
        String string = new File(contractPath).getParentFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(contractPath).parentFile.absolutePath");
        return new SystemGit(string, null, 2, null);
    }

    public SystemGit() {
        this(null, null, 3, null);
    }
}

