/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.pattern;

import in.specmatic.core.Resolver;
import in.specmatic.core.Result;
import in.specmatic.core.ResultKt;
import in.specmatic.core.pattern.ConsumeResult;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.pattern.DeferredPatternKt;
import in.specmatic.core.pattern.ExactValuePattern;
import in.specmatic.core.pattern.GrammarKt;
import in.specmatic.core.pattern.JSONArrayPatternKt;
import in.specmatic.core.pattern.MemberList;
import in.specmatic.core.pattern.PairOfTypes;
import in.specmatic.core.pattern.Pattern;
import in.specmatic.core.pattern.RestPattern;
import in.specmatic.core.pattern.ResultWithIndex;
import in.specmatic.core.pattern.Row;
import in.specmatic.core.pattern.SequenceType;
import in.specmatic.core.pattern.TypeStackKt;
import in.specmatic.core.utilities.JSONSerialisationKt;
import in.specmatic.core.utilities.Utilities;
import in.specmatic.core.value.JSONArrayValue;
import in.specmatic.core.value.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006B!\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J%\u0010\u0016\u001a\u00020\u00002\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J2\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0010\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\u001f0\u001ej\u0002` H\u0016J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001bH\u0016J\t\u0010(\u001a\u00020)H\u00d6\u0001J\u001e\u0010*\u001a\u00020&2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020&0\b2\u0006\u0010'\u001a\u00020\u001bH\u0016J\u001a\u0010,\u001a\u00020\u00182\b\u0010-\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u001bH\u0016J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00000\b2\u0006\u0010'\u001a\u00020\u001bH\u0016J\u001e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00000\b2\u0006\u0010/\u001a\u0002002\u0006\u0010'\u001a\u00020\u001bH\u0016J\u0018\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u001bH\u0016J\t\u00103\u001a\u00020\u0004H\u00d6\u0001J\u0018\u00104\u001a\u00020\u00182\u0006\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\u000bH\u0002R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u00067"}, d2={"Lin/specmatic/core/pattern/JSONArrayPattern;", "Lin/specmatic/core/pattern/Pattern;", "Lin/specmatic/core/pattern/SequenceType;", "jsonString", "", "typeAlias", "(Ljava/lang/String;Ljava/lang/String;)V", "pattern", "", "(Ljava/util/List;Ljava/lang/String;)V", "memberList", "Lin/specmatic/core/pattern/MemberList;", "getMemberList", "()Lin/specmatic/core/pattern/MemberList;", "getPattern", "()Ljava/util/List;", "getTypeAlias", "()Ljava/lang/String;", "typeName", "getTypeName", "component1", "component2", "copy", "encompasses", "Lin/specmatic/core/Result;", "otherPattern", "thisResolver", "Lin/specmatic/core/Resolver;", "otherResolver", "typeStack", "", "Lin/specmatic/core/pattern/PairOfTypes;", "Lin/specmatic/core/pattern/TypeStack;", "equals", "", "other", "", "generate", "Lin/specmatic/core/value/Value;", "resolver", "hashCode", "", "listOf", "valueList", "matches", "sampleData", "newBasedOn", "row", "Lin/specmatic/core/pattern/Row;", "parse", "value", "toString", "validateInfiniteLength", "otherMembers", "theseMembers", "core"})
public final class JSONArrayPattern
implements Pattern,
SequenceType {
    @NotNull
    private final List<Pattern> pattern;
    @Nullable
    private final String typeAlias;
    @NotNull
    private final String typeName;

    public JSONArrayPattern(@NotNull List<? extends Pattern> pattern2, @Nullable String typeAlias) {
        Intrinsics.checkNotNullParameter(pattern2, (String)"pattern");
        this.pattern = pattern2;
        this.typeAlias = typeAlias;
        this.typeName = "json array";
    }

    public /* synthetic */ JSONArrayPattern(List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            string = null;
        }
        this(list, string);
    }

    @Override
    @NotNull
    public List<Pattern> getPattern() {
        return this.pattern;
    }

    @Override
    @Nullable
    public String getTypeAlias() {
        return this.typeAlias;
    }

    @Override
    @NotNull
    public MemberList getMemberList() {
        int n;
        block4: {
            if (this.getPattern().isEmpty()) {
                return new MemberList(CollectionsKt.emptyList(), null);
            }
            Object $this$indexOfFirst$iv = this.getPattern();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                Object item$iv = iterator.next();
                Pattern it = (Pattern)item$iv;
                boolean bl = false;
                if (it instanceof RestPattern) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = -1;
        }
        int n2 = n;
        boolean bl = false;
        boolean bl2 = false;
        int it = n2;
        boolean bl3 = false;
        boolean bl4 = it >= 0 && it < CollectionsKt.getLastIndex((List)this.getPattern());
        if (bl4) {
            throw new ContractException("A rest operator ... can only be used in the last entry of an array.", null, null, null, 14, null);
        }
        Object object = CollectionsKt.last((List)this.getPattern());
        bl = false;
        bl2 = false;
        Pattern last = (Pattern)object;
        boolean bl5 = false;
        Pattern pattern2 = last;
        return pattern2 instanceof RestPattern ? new MemberList(CollectionsKt.dropLast((List)this.getPattern(), (int)1), ((RestPattern)last).getPattern()) : new MemberList((List<? extends Pattern>)this.getPattern(), null);
    }

    public JSONArrayPattern(@NotNull String jsonString, @Nullable String typeAlias) {
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        this(JSONSerialisationKt.stringTooPatternArray(jsonString), typeAlias);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Result matches(@Nullable Value sampleData, @NotNull Resolver resolver) throws Exception {
        Object v1;
        block10: {
            void $this$mapIndexedTo$iv$iv;
            Object object;
            Result it;
            Collection collection;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            if (!(sampleData instanceof JSONArrayValue)) {
                return new Result.Failure("Value is not a JSON array", null, null, null, 14, null);
            }
            if (((JSONArrayValue)sampleData).getList().isEmpty()) {
                return new Result.Success(null, 1, null);
            }
            Resolver resolverWithNumberType = Utilities.withNumberType(Utilities.withNullPattern(resolver));
            Iterable $this$map$iv = (Iterable)this.getPattern();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pattern pattern2 = (Pattern)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                object = DeferredPatternKt.resolvedHop((Pattern)((Object)it), resolverWithNumberType);
                collection.add(object);
            }
            List resolvedTypes = (List)destination$iv$iv;
            Iterable $this$mapIndexed$iv = resolvedTypes;
            boolean $i$f$mapIndexed = false;
            destination$iv$iv = $this$mapIndexed$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                Result result2;
                void index;
                void patternValue;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pattern pattern3 = (Pattern)item$iv$iv;
                int n2 = n;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                if (patternValue instanceof RestPattern) {
                    void var19_31 = index;
                    List rest2 = var19_31 == ((JSONArrayValue)sampleData).getList().size() ? CollectionsKt.emptyList() : CollectionsKt.slice(((JSONArrayValue)sampleData).getList(), (IntRange)new IntRange((int)index, CollectionsKt.getLastIndex(((JSONArrayValue)sampleData).getList())));
                    result2 = ResultKt.breadCrumb(patternValue.matches(new JSONArrayValue(rest2), resolverWithNumberType), "" + '[' + (int)index + "..." + CollectionsKt.getLastIndex(((JSONArrayValue)sampleData).getList()) + ']');
                } else if (index == ((JSONArrayValue)sampleData).getList().size()) {
                    result2 = new Result.Failure("Expected an array of length " + this.getPattern().size() + ", actual length " + ((JSONArrayValue)sampleData).getList().size(), null, null, null, 14, null);
                } else {
                    Value sampleValue = ((JSONArrayValue)sampleData).getList().get((int)index);
                    result2 = ResultKt.breadCrumb(patternValue.matches(sampleValue, resolverWithNumberType), "" + '[' + (int)index + ']');
                }
                object = result2;
                collection.add(object);
            }
            Iterable iterable2 = (List)destination$iv$iv2;
            boolean bl = false;
            Iterable iterable3 = iterable2;
            boolean bl3 = false;
            for (Object t : iterable3) {
                it = (Result)t;
                boolean bl4 = false;
                if (!(it instanceof Result.Failure)) continue;
                v1 = t;
                break block10;
            }
            v1 = null;
        }
        Result result3 = v1;
        return result3 == null ? (Result)new Result.Success(null, 1, null) : result3;
    }

    @Override
    @NotNull
    public Value listOf(@NotNull List<? extends Value> valueList, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(valueList, (String)"valueList");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return new JSONArrayValue(valueList);
    }

    @Override
    @NotNull
    public Value generate(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Resolver resolverWithNullType = Utilities.withNullPattern(resolver);
        return new JSONArrayValue(JSONArrayPatternKt.generate((List<? extends Pattern>)this.getPattern(), resolverWithNullType));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<JSONArrayPattern> newBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Resolver resolverWithNullType = Utilities.withNullPattern(resolver);
        Iterable $this$map$iv = JSONArrayPatternKt.newBasedOn((List<? extends Pattern>)this.getPattern(), row, resolverWithNullType);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JSONArrayPattern jSONArrayPattern = new JSONArrayPattern((List)it, null, 2, null);
            collection.add(jSONArrayPattern);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<JSONArrayPattern> newBasedOn(@NotNull Resolver resolver) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Resolver resolverWithNullType = Utilities.withNullPattern(resolver);
        Iterable $this$map$iv = JSONArrayPatternKt.newBasedOn((List<? extends Pattern>)this.getPattern(), resolverWithNullType);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JSONArrayPattern jSONArrayPattern = new JSONArrayPattern((List)it, null, 2, null);
            collection.add(jSONArrayPattern);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Value parse(@NotNull String value, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return GrammarKt.parsedJSON(value);
    }

    @Override
    @NotNull
    public Result encompasses(@NotNull Pattern otherPattern, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        Result result2;
        Intrinsics.checkNotNullParameter((Object)otherPattern, (String)"otherPattern");
        Intrinsics.checkNotNullParameter((Object)thisResolver, (String)"thisResolver");
        Intrinsics.checkNotNullParameter((Object)otherResolver, (String)"otherResolver");
        Intrinsics.checkNotNullParameter(typeStack, (String)"typeStack");
        Resolver thisResolverWithNullType = Utilities.withNullPattern(thisResolver);
        Resolver otherResolverWithNullType = Utilities.withNullPattern(otherResolver);
        Pattern pattern2 = otherPattern;
        if (pattern2 instanceof ExactValuePattern) {
            result2 = otherPattern.fitsWithin(CollectionsKt.listOf((Object)this), otherResolverWithNullType, thisResolverWithNullType, typeStack);
        } else if (pattern2 instanceof SequenceType) {
            Result result3;
            try {
                MemberList otherMembers = ((SequenceType)((Object)otherPattern)).getMemberList();
                MemberList theseMembers = this.getMemberList();
                result3 = this.validateInfiniteLength(otherMembers, theseMembers).ifSuccess((Function0<? extends Result>)((Function0)new Function0<Result>(otherMembers, this, otherResolverWithNullType, theseMembers, thisResolverWithNullType, typeStack){
                    final /* synthetic */ MemberList $otherMembers;
                    final /* synthetic */ JSONArrayPattern this$0;
                    final /* synthetic */ Resolver $otherResolverWithNullType;
                    final /* synthetic */ MemberList $theseMembers;
                    final /* synthetic */ Resolver $thisResolverWithNullType;
                    final /* synthetic */ Set<PairOfTypes> $typeStack;
                    {
                        this.$otherMembers = $otherMembers;
                        this.this$0 = $receiver;
                        this.$otherResolverWithNullType = $otherResolverWithNullType;
                        this.$theseMembers = $theseMembers;
                        this.$thisResolverWithNullType = $thisResolverWithNullType;
                        this.$typeStack = $typeStack;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final Result invoke() {
                        Result result2;
                        Object v0;
                        boolean bl;
                        Object object;
                        Object object2;
                        Iterable iterable;
                        block5: {
                            void $this$mapIndexedTo$iv$iv2;
                            void $this$mapIndexed$iv;
                            List<Pattern> otherEncompassables = this.$otherMembers.getEncompassableList(this.this$0.getPattern().size(), this.$otherResolverWithNullType);
                            List<Pattern> encompassables = otherEncompassables.size() > this.this$0.getPattern().size() ? this.$theseMembers.getEncompassableList(otherEncompassables.size(), this.$thisResolverWithNullType) : this.this$0.getMemberList().getEncompassables(this.$thisResolverWithNullType);
                            iterable = CollectionsKt.zip((Iterable)encompassables, (Iterable)otherEncompassables);
                            object2 = this.$thisResolverWithNullType;
                            object = this.$otherResolverWithNullType;
                            Set<PairOfTypes> set = this.$typeStack;
                            boolean $i$f$mapIndexed = false;
                            void var9_11 = $this$mapIndexed$iv;
                            Object destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                            boolean $i$f$mapIndexedTo = false;
                            int index$iv$iv = 0;
                            for (T item$iv$iv : $this$mapIndexedTo$iv$iv2) {
                                void index;
                                void $dstr$bigger$smaller;
                                int n = index$iv$iv++;
                                boolean bl2 = false;
                                if (n < 0) {
                                    CollectionsKt.throwIndexOverflow();
                                }
                                Pair pair = (Pair)item$iv$iv;
                                int n2 = n;
                                Collection collection = destination$iv$iv;
                                boolean bl3 = false;
                                Pattern bigger = (Pattern)$dstr$bigger$smaller.component1();
                                Pattern smaller = (Pattern)$dstr$bigger$smaller.component2();
                                ResultWithIndex resultWithIndex = new ResultWithIndex((int)index, TypeStackKt.biggerEncompassesSmaller(bigger, smaller, (Resolver)object2, (Resolver)object, set));
                                collection.add(resultWithIndex);
                            }
                            List results2 = (List)destination$iv$iv;
                            object = results2;
                            bl = false;
                            Object object3 = object;
                            boolean $this$mapIndexedTo$iv$iv2 = false;
                            destination$iv$iv = object3.iterator();
                            while (destination$iv$iv.hasNext()) {
                                E e = destination$iv$iv.next();
                                ResultWithIndex it = (ResultWithIndex)e;
                                boolean bl4 = false;
                                if (!(it.getResult() instanceof Result.Failure)) continue;
                                v0 = e;
                                break block5;
                            }
                            v0 = null;
                        }
                        object2 = v0;
                        if (object2 == null) {
                            result2 = null;
                        } else {
                            object = object2;
                            bl = false;
                            boolean bl5 = false;
                            Object result3 = object;
                            boolean bl6 = false;
                            result2 = ResultKt.breadCrumb(((ResultWithIndex)result3).getResult(), "" + '[' + ((ResultWithIndex)result3).getIndex() + ']');
                        }
                        iterable = result2;
                        return iterable == null ? (Result)new Result.Success(null, 1, null) : iterable;
                    }
                }));
            }
            catch (ContractException e) {
                result3 = new Result.Failure(e.report(), null, null, null, 14, null);
            }
            result2 = result3;
        } else {
            result2 = new Result.Failure(Intrinsics.stringPlus((String)"Expected array or list, got ", (Object)otherPattern.getTypeName()), null, null, null, 14, null);
        }
        return result2;
    }

    private final Result validateInfiniteLength(MemberList otherMembers, MemberList theseMembers) {
        return otherMembers.isEndless() && !theseMembers.isEndless() ? (Result)new Result.Failure("Finite list is not a superset of an infinite list.", null, null, null, 14, null) : (Result)new Result.Success(null, 1, null);
    }

    @Override
    @NotNull
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @NotNull
    public ConsumeResult<Pattern, Pattern> encompasses(@NotNull List<? extends Pattern> others, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull String lengthError, @NotNull Set<PairOfTypes> typeStack) {
        return Pattern.DefaultImpls.encompasses(this, others, thisResolver, otherResolver, lengthError, typeStack);
    }

    @Override
    @NotNull
    public Result fitsWithin(@NotNull List<? extends Pattern> otherPatterns, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        return Pattern.DefaultImpls.fitsWithin(this, otherPatterns, thisResolver, otherResolver, typeStack);
    }

    @Override
    @NotNull
    public ConsumeResult<Value, Value> matches(@NotNull List<? extends Value> sampleData, @NotNull Resolver resolver) {
        return Pattern.DefaultImpls.matches(this, sampleData, resolver);
    }

    @Override
    @NotNull
    public Pattern parseToType(@NotNull String valueString, @NotNull Resolver resolver) {
        return Pattern.DefaultImpls.parseToType(this, valueString, resolver);
    }

    @Override
    @NotNull
    public List<Pattern> patternSet(@NotNull Resolver resolver) {
        return Pattern.DefaultImpls.patternSet(this, resolver);
    }

    @NotNull
    public final List<Pattern> component1() {
        return this.getPattern();
    }

    @Nullable
    public final String component2() {
        return this.getTypeAlias();
    }

    @NotNull
    public final JSONArrayPattern copy(@NotNull List<? extends Pattern> pattern2, @Nullable String typeAlias) {
        Intrinsics.checkNotNullParameter(pattern2, (String)"pattern");
        return new JSONArrayPattern(pattern2, typeAlias);
    }

    public static /* synthetic */ JSONArrayPattern copy$default(JSONArrayPattern jSONArrayPattern, List object, String string, int n, Object object2) {
        if ((n & 1) != 0) {
            object = jSONArrayPattern.getPattern();
        }
        if ((n & 2) != 0) {
            string = jSONArrayPattern.getTypeAlias();
        }
        return jSONArrayPattern.copy((List<? extends Pattern>)object, string);
    }

    @NotNull
    public String toString() {
        return "JSONArrayPattern(pattern=" + this.getPattern() + ", typeAlias=" + this.getTypeAlias() + ')';
    }

    public int hashCode() {
        int result2 = this.getPattern().hashCode();
        result2 = result2 * 31 + (this.getTypeAlias() == null ? 0 : this.getTypeAlias().hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JSONArrayPattern)) {
            return false;
        }
        JSONArrayPattern jSONArrayPattern = (JSONArrayPattern)other;
        if (!Intrinsics.areEqual((Object)this.getPattern(), (Object)jSONArrayPattern.getPattern())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getTypeAlias(), (Object)jSONArrayPattern.getTypeAlias());
    }

    public JSONArrayPattern() {
        this(null, null, 3, null);
    }
}

