/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.pattern;

import in.specmatic.core.Resolver;
import in.specmatic.core.Result;
import in.specmatic.core.ResultKt;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.pattern.ContractExceptionKt;
import in.specmatic.core.pattern.EmptyStringPattern;
import in.specmatic.core.pattern.Pattern;
import in.specmatic.core.pattern.Row;
import in.specmatic.core.pattern.StringPattern;
import in.specmatic.core.value.EmptyStringKt;
import in.specmatic.core.value.KafkaMessage;
import in.specmatic.core.value.StringValue;
import in.specmatic.core.value.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0015J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\u0018\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u001aH\u0002J\u0018\u0010!\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u0016\u0010\"\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0015J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00000$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\u0015J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0000H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006)"}, d2={"Lin/specmatic/core/pattern/KafkaMessagePattern;", "", "topic", "", "key", "Lin/specmatic/core/pattern/Pattern;", "value", "(Ljava/lang/String;Lin/specmatic/core/pattern/Pattern;Lin/specmatic/core/pattern/Pattern;)V", "getKey", "()Lin/specmatic/core/pattern/Pattern;", "getTopic", "()Ljava/lang/String;", "getValue", "component1", "component2", "component3", "copy", "encompasses", "Lin/specmatic/core/Result;", "other", "thisResolver", "Lin/specmatic/core/Resolver;", "otherResolver", "equals", "", "generate", "Lin/specmatic/core/value/KafkaMessage;", "resolver", "hashCode", "", "matchKey", "message", "matchTopics", "matchValue", "matches", "newBasedOn", "", "row", "Lin/specmatic/core/pattern/Row;", "toString", "topicsShouldMatch", "core"})
public final class KafkaMessagePattern {
    @NotNull
    private final String topic;
    @NotNull
    private final Pattern key;
    @NotNull
    private final Pattern value;

    public KafkaMessagePattern(@NotNull String topic, @NotNull Pattern key, @NotNull Pattern value) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.topic = topic;
        this.key = key;
        this.value = value;
    }

    public /* synthetic */ KafkaMessagePattern(String string, Pattern pattern2, Pattern pattern3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            pattern2 = EmptyStringPattern.INSTANCE;
        }
        if ((n & 4) != 0) {
            pattern3 = new StringPattern(null, null, null, 7, null);
        }
        this(string, pattern2, pattern3);
    }

    @NotNull
    public final String getTopic() {
        return this.topic;
    }

    @NotNull
    public final Pattern getKey() {
        return this.key;
    }

    @NotNull
    public final Pattern getValue() {
        return this.value;
    }

    @NotNull
    public final Result matches(@NotNull KafkaMessage message, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return (Result)ContractExceptionKt.attempt$default("KAFKA-MESSAGE", null, (Function0)new Function0<Result>(this, message, resolver){
            final /* synthetic */ KafkaMessagePattern this$0;
            final /* synthetic */ KafkaMessage $message;
            final /* synthetic */ Resolver $resolver;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                this.$resolver = $resolver;
                super(0);
            }

            @NotNull
            public final Result invoke() {
                Result result2;
                try {
                    result2 = KafkaMessagePattern.access$matchTopics(this.this$0, this.$message).ifSuccess((Function0<? extends Result>)((Function0)new Function0<Result>(this.this$0, this.$message, this.$resolver){
                        final /* synthetic */ KafkaMessagePattern this$0;
                        final /* synthetic */ KafkaMessage $message;
                        final /* synthetic */ Resolver $resolver;
                        {
                            this.this$0 = $receiver;
                            this.$message = $message;
                            this.$resolver = $resolver;
                            super(0);
                        }

                        @NotNull
                        public final Result invoke() {
                            return KafkaMessagePattern.access$matchKey(this.this$0, this.$message, this.$resolver);
                        }
                    })).ifSuccess((Function0<? extends Result>)((Function0)new Function0<Result>(this.this$0, this.$message, this.$resolver){
                        final /* synthetic */ KafkaMessagePattern this$0;
                        final /* synthetic */ KafkaMessage $message;
                        final /* synthetic */ Resolver $resolver;
                        {
                            this.this$0 = $receiver;
                            this.$message = $message;
                            this.$resolver = $resolver;
                            super(0);
                        }

                        @NotNull
                        public final Result invoke() {
                            return KafkaMessagePattern.access$matchValue(this.this$0, this.$message, this.$resolver);
                        }
                    }));
                }
                catch (ContractException e) {
                    result2 = e.failure();
                }
                return ResultKt.breadCrumb(result2, "KAFKA-MESSAGE");
            }
        }, 2, null);
    }

    private final Result matchValue(KafkaMessage message, Resolver resolver) {
        Result result2;
        try {
            Value value = message.getValue();
            Value parsedValue = value instanceof StringValue ? this.value.parse(((StringValue)message.getValue()).getString(), resolver) : message.getValue();
            result2 = this.value.matches(parsedValue, resolver);
        }
        catch (ContractException e) {
            result2 = e.failure();
        }
        return ResultKt.breadCrumb(result2, "VALUE");
    }

    private final Result matchKey(KafkaMessage message, Resolver resolver) {
        Result result2;
        try {
            Value value = message.getKey();
            Value parsedKey = value != null ? this.key.parse(message.getKey().getString(), resolver) : (Value)message.getKey();
            value = parsedKey;
            result2 = this.key.matches(value == null ? (Value)EmptyStringKt.getEmptyString() : value, resolver);
        }
        catch (ContractException e) {
            result2 = e.failure();
        }
        return ResultKt.breadCrumb(result2, "KEY");
    }

    private final Result matchTopics(KafkaMessage message) {
        String string = message.getTopic();
        return Intrinsics.areEqual((Object)string, (Object)this.topic) ? (Result)new Result.Success(null, 1, null) : (Result)new Result.Failure("Expected topic " + this.topic + ", got " + message + ".topic", null, null, null, 14, null).breadCrumb("TOPIC");
    }

    @NotNull
    public final Result encompasses(@NotNull KafkaMessagePattern other, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)thisResolver, (String)"thisResolver");
        Intrinsics.checkNotNullParameter((Object)otherResolver, (String)"otherResolver");
        return (Result)ContractExceptionKt.attempt$default("KAFKA-MESSAGE", null, (Function0)new Function0<Result>(this, other, otherResolver, thisResolver){
            final /* synthetic */ KafkaMessagePattern this$0;
            final /* synthetic */ KafkaMessagePattern $other;
            final /* synthetic */ Resolver $otherResolver;
            final /* synthetic */ Resolver $thisResolver;
            {
                this.this$0 = $receiver;
                this.$other = $other;
                this.$otherResolver = $otherResolver;
                this.$thisResolver = $thisResolver;
                super(0);
            }

            @NotNull
            public final Result invoke() {
                return ResultKt.breadCrumb(KafkaMessagePattern.access$topicsShouldMatch(this.this$0, this.$other).ifSuccess((Function0<? extends Result>)((Function0)new Function0<Result>(this.this$0, this.$other, this.$otherResolver, this.$thisResolver){
                    final /* synthetic */ KafkaMessagePattern this$0;
                    final /* synthetic */ KafkaMessagePattern $other;
                    final /* synthetic */ Resolver $otherResolver;
                    final /* synthetic */ Resolver $thisResolver;
                    {
                        this.this$0 = $receiver;
                        this.$other = $other;
                        this.$otherResolver = $otherResolver;
                        this.$thisResolver = $thisResolver;
                        super(0);
                    }

                    @NotNull
                    public final Result invoke() {
                        return ResultKt.breadCrumb(Pattern.DefaultImpls.encompasses$default(this.this$0.getKey(), this.$other.getKey(), this.$otherResolver, this.$thisResolver, null, 8, null), "KEY");
                    }
                })).ifSuccess((Function0<? extends Result>)((Function0)new Function0<Result>(this.this$0, this.$other, this.$thisResolver, this.$otherResolver){
                    final /* synthetic */ KafkaMessagePattern this$0;
                    final /* synthetic */ KafkaMessagePattern $other;
                    final /* synthetic */ Resolver $thisResolver;
                    final /* synthetic */ Resolver $otherResolver;
                    {
                        this.this$0 = $receiver;
                        this.$other = $other;
                        this.$thisResolver = $thisResolver;
                        this.$otherResolver = $otherResolver;
                        super(0);
                    }

                    @NotNull
                    public final Result invoke() {
                        return ResultKt.breadCrumb(Pattern.DefaultImpls.encompasses$default(this.this$0.getValue(), this.$other.getValue(), this.$thisResolver, this.$otherResolver, null, 8, null), "VALUE");
                    }
                })), "KAFKA-MESSAGE");
            }
        }, 2, null);
    }

    private final Result topicsShouldMatch(KafkaMessagePattern other) {
        String string = this.topic;
        return Intrinsics.areEqual((Object)string, (Object)other.topic) ? (Result)new Result.Success(null, 1, null) : (Result)new Result.Failure("Expected topic " + this.topic + ", got " + other.topic, null, null, null, 14, null).breadCrumb("TOPIC");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KafkaMessagePattern> newBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        List<Pattern> newKeys = this.key.newBasedOn(row, resolver);
        List<Pattern> newValues = this.value.newBasedOn(row, resolver);
        Iterable $this$flatMap$iv = newKeys;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            Pattern newKey = (Pattern)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = newValues;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void newValue;
                Pattern pattern2 = (Pattern)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                KafkaMessagePattern kafkaMessagePattern = new KafkaMessagePattern(this.getTopic(), newKey, (Pattern)newValue);
                collection.add(kafkaMessagePattern);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final KafkaMessage generate(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return new KafkaMessage(this.topic, (StringValue)this.key.generate(resolver), (StringValue)this.value.generate(resolver));
    }

    @NotNull
    public final String component1() {
        return this.topic;
    }

    @NotNull
    public final Pattern component2() {
        return this.key;
    }

    @NotNull
    public final Pattern component3() {
        return this.value;
    }

    @NotNull
    public final KafkaMessagePattern copy(@NotNull String topic, @NotNull Pattern key, @NotNull Pattern value) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new KafkaMessagePattern(topic, key, value);
    }

    public static /* synthetic */ KafkaMessagePattern copy$default(KafkaMessagePattern kafkaMessagePattern, String string, Pattern pattern2, Pattern pattern3, int n, Object object) {
        if ((n & 1) != 0) {
            string = kafkaMessagePattern.topic;
        }
        if ((n & 2) != 0) {
            pattern2 = kafkaMessagePattern.key;
        }
        if ((n & 4) != 0) {
            pattern3 = kafkaMessagePattern.value;
        }
        return kafkaMessagePattern.copy(string, pattern2, pattern3);
    }

    @NotNull
    public String toString() {
        return "KafkaMessagePattern(topic=" + this.topic + ", key=" + this.key + ", value=" + this.value + ')';
    }

    public int hashCode() {
        int result2 = this.topic.hashCode();
        result2 = result2 * 31 + this.key.hashCode();
        result2 = result2 * 31 + this.value.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KafkaMessagePattern)) {
            return false;
        }
        KafkaMessagePattern kafkaMessagePattern = (KafkaMessagePattern)other;
        if (!Intrinsics.areEqual((Object)this.topic, (Object)kafkaMessagePattern.topic)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.key, (Object)kafkaMessagePattern.key)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.value, (Object)kafkaMessagePattern.value);
    }

    public KafkaMessagePattern() {
        this(null, null, null, 7, null);
    }

    public static final /* synthetic */ Result access$matchTopics(KafkaMessagePattern $this, KafkaMessage message) {
        return $this.matchTopics(message);
    }

    public static final /* synthetic */ Result access$matchKey(KafkaMessagePattern $this, KafkaMessage message, Resolver resolver) {
        return $this.matchKey(message, resolver);
    }

    public static final /* synthetic */ Result access$matchValue(KafkaMessagePattern $this, KafkaMessage message, Resolver resolver) {
        return $this.matchValue(message, resolver);
    }

    public static final /* synthetic */ Result access$topicsShouldMatch(KafkaMessagePattern $this, KafkaMessagePattern other) {
        return $this.topicsShouldMatch(other);
    }
}

