/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.pattern;

import in.specmatic.core.Resolver;
import in.specmatic.core.Result;
import in.specmatic.core.ResultKt;
import in.specmatic.core.pattern.ConsumeResult;
import in.specmatic.core.pattern.NumberPatternKt;
import in.specmatic.core.pattern.PairOfTypes;
import in.specmatic.core.pattern.Pattern;
import in.specmatic.core.pattern.Row;
import in.specmatic.core.pattern.ScalarType;
import in.specmatic.core.pattern.StringPatternKt;
import in.specmatic.core.value.EmptyStringKt;
import in.specmatic.core.value.JSONArrayValue;
import in.specmatic.core.value.StringValue;
import in.specmatic.core.value.Value;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ2\u0010\u0019\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001aJ2\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0010\u0010!\u001a\f\u0012\u0004\u0012\u00020#0\"j\u0002`$H\u0016J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001fH\u0016J\t\u0010+\u001a\u00020\u0006H\u00d6\u0001J\u001e\u0010,\u001a\u00020)2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020)0.2\u0006\u0010*\u001a\u00020\u001fH\u0016J\u001a\u0010/\u001a\u00020\u001c2\b\u00100\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u001fH\u0016J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\u00010.2\u0006\u0010*\u001a\u00020\u001fH\u0016J\u001e\u00101\u001a\b\u0012\u0004\u0012\u00020\u00010.2\u0006\u00102\u001a\u0002032\u0006\u0010*\u001a\u00020\u001fH\u0016J\u0018\u00104\u001a\u00020)2\u0006\u00105\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u001fH\u0016J\b\u00106\u001a\u00020\u0004H\u0016R\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u00067"}, d2={"Lin/specmatic/core/pattern/StringPattern;", "Lin/specmatic/core/pattern/Pattern;", "Lin/specmatic/core/pattern/ScalarType;", "typeAlias", "", "minLength", "", "maxLength", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)V", "getMaxLength", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getMinLength", "pattern", "", "getPattern", "()Ljava/lang/Object;", "randomStringLength", "getTypeAlias", "()Ljava/lang/String;", "typeName", "getTypeName", "component1", "component2", "component3", "copy", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Lin/specmatic/core/pattern/StringPattern;", "encompasses", "Lin/specmatic/core/Result;", "otherPattern", "thisResolver", "Lin/specmatic/core/Resolver;", "otherResolver", "typeStack", "", "Lin/specmatic/core/pattern/PairOfTypes;", "Lin/specmatic/core/pattern/TypeStack;", "equals", "", "other", "generate", "Lin/specmatic/core/value/Value;", "resolver", "hashCode", "listOf", "valueList", "", "matches", "sampleData", "newBasedOn", "row", "Lin/specmatic/core/pattern/Row;", "parse", "value", "toString", "core"})
public final class StringPattern
implements Pattern,
ScalarType {
    @Nullable
    private final String typeAlias;
    @Nullable
    private final Integer minLength;
    @Nullable
    private final Integer maxLength;
    private final int randomStringLength;
    @NotNull
    private final String typeName;
    @NotNull
    private final Object pattern;

    public StringPattern(@Nullable String typeAlias, @Nullable Integer minLength, @Nullable Integer maxLength) {
        boolean bl;
        this.typeAlias = typeAlias;
        this.minLength = minLength;
        this.maxLength = maxLength;
        Integer n = this.minLength;
        if (n == null) {
            bl = true;
        } else {
            Boolean bl2;
            Integer n2 = n;
            boolean bl3 = false;
            boolean bl4 = false;
            int it = ((Number)n2).intValue();
            boolean bl5 = false;
            Integer n3 = this.getMaxLength();
            if (n3 == null) {
                bl2 = null;
            } else {
                Integer n4 = n3;
                boolean bl6 = false;
                boolean bl7 = false;
                int it2 = ((Number)n4).intValue();
                boolean bl8 = false;
                bl2 = this.getMinLength() <= this.getMaxLength();
            }
            Boolean bl9 = bl2;
            bl = bl9 == null ? true : bl9;
        }
        boolean bl10 = bl;
        boolean bl11 = false;
        boolean bl12 = false;
        if (!bl10) {
            boolean bl13 = false;
            String string = "maxLength cannot be less than minLength";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.randomStringLength = this.minLength != null && 5 < this.minLength ? this.minLength : (this.maxLength != null && 5 > this.maxLength ? this.maxLength : 5);
        this.typeName = "string";
        this.pattern = "(string)";
    }

    public /* synthetic */ StringPattern(String string, Integer n, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            string = null;
        }
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        this(string, n, n2);
    }

    @Override
    @Nullable
    public String getTypeAlias() {
        return this.typeAlias;
    }

    @Nullable
    public final Integer getMinLength() {
        return this.minLength;
    }

    @Nullable
    public final Integer getMaxLength() {
        return this.maxLength;
    }

    @Override
    @NotNull
    public Result matches(@Nullable Value sampleData, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Value value = sampleData;
        if (value instanceof StringValue ? true : Intrinsics.areEqual((Object)value, (Object)EmptyStringKt.getEmptyString())) {
            if (this.minLength != null && sampleData.toStringLiteral().length() < this.minLength) {
                return ResultKt.mismatchResult(Intrinsics.stringPlus((String)"string with minLength ", (Object)this.minLength), sampleData);
            }
            if (this.maxLength != null && sampleData.toStringLiteral().length() > this.maxLength) {
                return ResultKt.mismatchResult(Intrinsics.stringPlus((String)"string with maxLength ", (Object)this.maxLength), sampleData);
            }
            return new Result.Success(null, 1, null);
        }
        return ResultKt.mismatchResult("string", sampleData);
    }

    @Override
    @NotNull
    public Result encompasses(@NotNull Pattern otherPattern, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        Intrinsics.checkNotNullParameter((Object)otherPattern, (String)"otherPattern");
        Intrinsics.checkNotNullParameter((Object)thisResolver, (String)"thisResolver");
        Intrinsics.checkNotNullParameter((Object)otherResolver, (String)"otherResolver");
        Intrinsics.checkNotNullParameter(typeStack, (String)"typeStack");
        return NumberPatternKt.encompasses(this, otherPattern, thisResolver, otherResolver, typeStack);
    }

    @Override
    @NotNull
    public Value listOf(@NotNull List<? extends Value> valueList, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(valueList, (String)"valueList");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return new JSONArrayValue(valueList);
    }

    @Override
    @NotNull
    public Value generate(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return new StringValue(StringPatternKt.randomString(this.randomStringLength));
    }

    @Override
    @NotNull
    public List<Pattern> newBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return CollectionsKt.listOf((Object)this);
    }

    @Override
    @NotNull
    public List<Pattern> newBasedOn(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return CollectionsKt.listOf((Object)this);
    }

    @Override
    @NotNull
    public Value parse(@NotNull String value, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return new StringValue(value);
    }

    @Override
    @NotNull
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @NotNull
    public Object getPattern() {
        return this.pattern;
    }

    @NotNull
    public String toString() {
        return this.getPattern().toString();
    }

    @Override
    @NotNull
    public ConsumeResult<Pattern, Pattern> encompasses(@NotNull List<? extends Pattern> others, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull String lengthError, @NotNull Set<PairOfTypes> typeStack) {
        return Pattern.DefaultImpls.encompasses(this, others, thisResolver, otherResolver, lengthError, typeStack);
    }

    @Override
    @NotNull
    public Result fitsWithin(@NotNull List<? extends Pattern> otherPatterns, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        return Pattern.DefaultImpls.fitsWithin(this, otherPatterns, thisResolver, otherResolver, typeStack);
    }

    @Override
    @NotNull
    public ConsumeResult<Value, Value> matches(@NotNull List<? extends Value> sampleData, @NotNull Resolver resolver) {
        return Pattern.DefaultImpls.matches(this, sampleData, resolver);
    }

    @Override
    @NotNull
    public Pattern parseToType(@NotNull String valueString, @NotNull Resolver resolver) {
        return Pattern.DefaultImpls.parseToType(this, valueString, resolver);
    }

    @Override
    @NotNull
    public List<Pattern> patternSet(@NotNull Resolver resolver) {
        return Pattern.DefaultImpls.patternSet(this, resolver);
    }

    @Nullable
    public final String component1() {
        return this.getTypeAlias();
    }

    @Nullable
    public final Integer component2() {
        return this.minLength;
    }

    @Nullable
    public final Integer component3() {
        return this.maxLength;
    }

    @NotNull
    public final StringPattern copy(@Nullable String typeAlias, @Nullable Integer minLength, @Nullable Integer maxLength) {
        return new StringPattern(typeAlias, minLength, maxLength);
    }

    public static /* synthetic */ StringPattern copy$default(StringPattern stringPattern, String string, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = stringPattern.getTypeAlias();
        }
        if ((n3 & 2) != 0) {
            n = stringPattern.minLength;
        }
        if ((n3 & 4) != 0) {
            n2 = stringPattern.maxLength;
        }
        return stringPattern.copy(string, n, n2);
    }

    public int hashCode() {
        int result2 = this.getTypeAlias() == null ? 0 : this.getTypeAlias().hashCode();
        result2 = result2 * 31 + (this.minLength == null ? 0 : ((Object)this.minLength).hashCode());
        result2 = result2 * 31 + (this.maxLength == null ? 0 : ((Object)this.maxLength).hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StringPattern)) {
            return false;
        }
        StringPattern stringPattern = (StringPattern)other;
        if (!Intrinsics.areEqual((Object)this.getTypeAlias(), (Object)stringPattern.getTypeAlias())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.minLength, (Object)stringPattern.minLength)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.maxLength, (Object)stringPattern.maxLength);
    }

    public StringPattern() {
        this(null, null, null, 7, null);
    }
}

