/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.utilities;

import in.specmatic.core.git.NonZeroExitError;
import in.specmatic.core.pattern.ContractException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\t\u001a\u00020\u0004R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lin/specmatic/core/utilities/ExternalCommand;", "", "command", "", "", "workingDirect", "environmentParameters", "([Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "[Ljava/lang/String;", "executeAsSeparateProcess", "core"})
public final class ExternalCommand {
    @NotNull
    private final String[] command;
    @NotNull
    private final String workingDirect;
    @NotNull
    private final String[] environmentParameters;

    public ExternalCommand(@NotNull String[] command, @NotNull String workingDirect, @NotNull String[] environmentParameters) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)workingDirect, (String)"workingDirect");
        Intrinsics.checkNotNullParameter((Object)environmentParameters, (String)"environmentParameters");
        this.command = command;
        this.workingDirect = workingDirect;
        this.environmentParameters = environmentParameters;
    }

    @NotNull
    public final String executeAsSeparateProcess() {
        String string;
        String commandWithParameters = ArraysKt.joinToString$default((Object[])this.command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        try {
            Process process = Runtime.getRuntime().exec(this.command, this.environmentParameters, new File(this.workingDirect));
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
            Object object = Charsets.UTF_8;
            boolean bl = false;
            Closeable closeable = inputStream;
            int n = 0;
            closeable = new InputStreamReader((InputStream)closeable, (Charset)object);
            n = 8192;
            int n2 = 0;
            String out = TextStreamsKt.readText((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)));
            object = process.getErrorStream();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"process.errorStream");
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            Object object2 = object;
            n2 = 0;
            object2 = new InputStreamReader((InputStream)object2, charset);
            n2 = 8192;
            boolean bl3 = false;
            String err = TextStreamsKt.readText((Reader)(object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n2)));
            process.waitFor();
            if (process.exitValue() != 0) {
                Object object3;
                StringBuilder stringBuilder = new StringBuilder().append("Error executing ").append(commandWithParameters).append(": ");
                object = err;
                boolean bl4 = false;
                Object object4 = object;
                boolean bl5 = false;
                if (object4.length() == 0) {
                    StringBuilder stringBuilder2 = stringBuilder;
                    boolean bl6 = false;
                    String string2 = out;
                    stringBuilder = stringBuilder2;
                    object3 = string2;
                } else {
                    object3 = object;
                }
                String string3 = stringBuilder.append((String)object3).toString();
                throw new NonZeroExitError(string3);
            }
            string = out;
        }
        catch (Exception otherExceptions) {
            throw new ContractException("Error running " + commandWithParameters + ": " + otherExceptions.getMessage(), null, null, null, 14, null);
        }
        return string;
    }
}

