/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.utilities;

import in.specmatic.core.git.SystemGit;
import in.specmatic.core.utilities.ContractPathData;
import in.specmatic.core.utilities.ContractSource;
import in.specmatic.core.utilities.ContractsSelectorPredicate;
import in.specmatic.core.utilities.Utilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00032\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0016J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0016J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010#\u001a\u00020\u0004H\u00d6\u0001R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006$"}, d2={"Lin/specmatic/core/utilities/GitMonoRepo;", "Lin/specmatic/core/utilities/ContractSource;", "testContracts", "", "", "stubContracts", "(Ljava/util/List;Ljava/util/List;)V", "getStubContracts", "()Ljava/util/List;", "getTestContracts", "component1", "component2", "copy", "directoryRelativeTo", "Ljava/io/File;", "workingDirectory", "equals", "", "other", "", "getLatest", "", "sourceGit", "Lin/specmatic/core/git/SystemGit;", "hashCode", "", "install", "loadContracts", "Lin/specmatic/core/utilities/ContractPathData;", "selector", "Lin/specmatic/core/utilities/ContractsSelectorPredicate;", "configFilePath", "pathDescriptor", "path", "pushUpdates", "toString", "core"})
public final class GitMonoRepo
extends ContractSource {
    @NotNull
    private final List<String> testContracts;
    @NotNull
    private final List<String> stubContracts;

    public GitMonoRepo(@NotNull List<String> testContracts, @NotNull List<String> stubContracts) {
        Intrinsics.checkNotNullParameter(testContracts, (String)"testContracts");
        Intrinsics.checkNotNullParameter(stubContracts, (String)"stubContracts");
        super(null);
        this.testContracts = testContracts;
        this.stubContracts = stubContracts;
    }

    @Override
    @NotNull
    public List<String> getTestContracts() {
        return this.testContracts;
    }

    @Override
    @NotNull
    public List<String> getStubContracts() {
        return this.stubContracts;
    }

    @Override
    @NotNull
    public String pathDescriptor(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return path;
    }

    @Override
    public void install(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        String string = "Checking list of mono repo paths...";
        boolean bl = false;
        System.out.println((Object)string);
        List contracts = CollectionsKt.plus((Collection)this.getTestContracts(), (Iterable)this.getStubContracts());
        for (String path : contracts) {
            String existenceMessage = new File(path).exists() ? Intrinsics.stringPlus((String)path, (Object)" exists") : Intrinsics.stringPlus((String)path, (Object)" NOT FOUND!");
            boolean bl2 = false;
            System.out.println((Object)existenceMessage);
        }
    }

    @Override
    @NotNull
    public File directoryRelativeTo(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        return FilesKt.resolve((File)workingDirectory, (String)Utilities.gitRootDir());
    }

    @Override
    public void getLatest(@NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
    }

    @Override
    public void pushUpdates(@NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ContractPathData> loadContracts(@NotNull ContractsSelectorPredicate selector, @NotNull String workingDirectory, @NotNull String configFilePath) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        File monoRepoBaseDir = new File(new SystemGit(null, null, 3, null).gitRoot());
        File configFileLocation = new File(configFilePath).getAbsoluteFile().getParentFile();
        Iterable $this$map$iv = selector.select(this);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = monoRepoBaseDir.getCanonicalPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"monoRepoBaseDir.canonicalPath");
            String string3 = string2;
            Intrinsics.checkNotNullExpressionValue((Object)configFileLocation, (String)"configFileLocation");
            string2 = FilesKt.resolve((File)configFileLocation, (String)it).getCanonicalPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"configFileLocation.resolve(it).canonicalPath");
            ContractPathData contractPathData = new ContractPathData(string3, string2);
            collection.add(contractPathData);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<String> component1() {
        return this.getTestContracts();
    }

    @NotNull
    public final List<String> component2() {
        return this.getStubContracts();
    }

    @NotNull
    public final GitMonoRepo copy(@NotNull List<String> testContracts, @NotNull List<String> stubContracts) {
        Intrinsics.checkNotNullParameter(testContracts, (String)"testContracts");
        Intrinsics.checkNotNullParameter(stubContracts, (String)"stubContracts");
        return new GitMonoRepo(testContracts, stubContracts);
    }

    public static /* synthetic */ GitMonoRepo copy$default(GitMonoRepo gitMonoRepo, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list = gitMonoRepo.getTestContracts();
        }
        if ((n & 2) != 0) {
            list2 = gitMonoRepo.getStubContracts();
        }
        return gitMonoRepo.copy(list, list2);
    }

    @NotNull
    public String toString() {
        return "GitMonoRepo(testContracts=" + this.getTestContracts() + ", stubContracts=" + this.getStubContracts() + ')';
    }

    public int hashCode() {
        int result2 = ((Object)this.getTestContracts()).hashCode();
        result2 = result2 * 31 + ((Object)this.getStubContracts()).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitMonoRepo)) {
            return false;
        }
        GitMonoRepo gitMonoRepo = (GitMonoRepo)other;
        if (!Intrinsics.areEqual(this.getTestContracts(), gitMonoRepo.getTestContracts())) {
            return false;
        }
        return Intrinsics.areEqual(this.getStubContracts(), gitMonoRepo.getStubContracts());
    }
}

