/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.utilities;

import in.specmatic.core.OutputKt;
import in.specmatic.core.git.GitOperations;
import in.specmatic.core.git.SystemGit;
import in.specmatic.core.utilities.ContractPathData;
import in.specmatic.core.utilities.ContractSource;
import in.specmatic.core.utilities.ContractSourceKt;
import in.specmatic.core.utilities.ContractsSelectorPredicate;
import in.specmatic.core.utilities.Utilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J3\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J&\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00052\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0010\u0010&\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u0010\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H\u0016J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010*\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006+"}, d2={"Lin/specmatic/core/utilities/GitRepo;", "Lin/specmatic/core/utilities/ContractSource;", "gitRepositoryURL", "", "testContracts", "", "stubContracts", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getGitRepositoryURL", "()Ljava/lang/String;", "repoName", "getRepoName", "getStubContracts", "()Ljava/util/List;", "getTestContracts", "component1", "component2", "component3", "copy", "directoryRelativeTo", "Ljava/io/File;", "workingDirectory", "equals", "", "other", "", "getLatest", "", "sourceGit", "Lin/specmatic/core/git/SystemGit;", "hashCode", "", "install", "loadContracts", "Lin/specmatic/core/utilities/ContractPathData;", "selector", "Lin/specmatic/core/utilities/ContractsSelectorPredicate;", "configFilePath", "localRepoDir", "pathDescriptor", "path", "pushUpdates", "toString", "core"})
public final class GitRepo
extends ContractSource {
    @NotNull
    private final String gitRepositoryURL;
    @NotNull
    private final List<String> testContracts;
    @NotNull
    private final List<String> stubContracts;
    @NotNull
    private final String repoName;

    public GitRepo(@NotNull String gitRepositoryURL, @NotNull List<String> testContracts, @NotNull List<String> stubContracts) {
        Intrinsics.checkNotNullParameter((Object)gitRepositoryURL, (String)"gitRepositoryURL");
        Intrinsics.checkNotNullParameter(testContracts, (String)"testContracts");
        Intrinsics.checkNotNullParameter(stubContracts, (String)"stubContracts");
        super(null);
        this.gitRepositoryURL = gitRepositoryURL;
        this.testContracts = testContracts;
        this.stubContracts = stubContracts;
        String[] stringArray = new String[]{"/"};
        this.repoName = StringsKt.removeSuffix((String)((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)this.gitRepositoryURL, (String[])stringArray, (boolean)false, (int)0, (int)6, null))), (CharSequence)".git");
    }

    @NotNull
    public final String getGitRepositoryURL() {
        return this.gitRepositoryURL;
    }

    @Override
    @NotNull
    public List<String> getTestContracts() {
        return this.testContracts;
    }

    @Override
    @NotNull
    public List<String> getStubContracts() {
        return this.stubContracts;
    }

    @NotNull
    public final String getRepoName() {
        return this.repoName;
    }

    @Override
    @NotNull
    public String pathDescriptor(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.repoName + ':' + path;
    }

    @Override
    @NotNull
    public File directoryRelativeTo(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        return FilesKt.resolve((File)workingDirectory, (String)this.repoName);
    }

    @Override
    public void getLatest(@NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
        sourceGit.pull();
    }

    @Override
    public void pushUpdates(@NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
        ContractSourceKt.commitAndPush(sourceGit);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ContractPathData> loadContracts(@NotNull ContractsSelectorPredicate selector, @NotNull String workingDirectory, @NotNull String configFilePath) {
        void $this$mapTo$iv$iv;
        File file;
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        File userHome = new File(System.getProperty("user.home"));
        File defaultQontractWorkingDir = FilesKt.resolve((File)userHome, (String)".specmatic/repos");
        File defaultRepoDir = this.directoryRelativeTo(defaultQontractWorkingDir);
        File bundleDir = FilesKt.resolve((File)new File(".specmatic_test_bundle"), (String)this.repoName);
        if (bundleDir.exists()) {
            OutputKt.getInformation().forTheUser(Intrinsics.stringPlus((String)"Using contracts from ", (Object)bundleDir.getPath()));
            file = bundleDir;
        } else if (defaultRepoDir.exists()) {
            OutputKt.getInformation().forTheUser("Using contracts in home dir");
            file = defaultRepoDir;
        } else {
            File reposBaseDir = this.localRepoDir(workingDirectory);
            OutputKt.getInformation().forTheUser("Couldn't find local contracts, cloning " + this.gitRepositoryURL + " into " + reposBaseDir.getPath());
            if (!reposBaseDir.exists()) {
                reposBaseDir.mkdirs();
            }
            file = GitOperations.clone(reposBaseDir, this);
        }
        File repoDir = file;
        Iterable $this$map$iv = selector.select(this);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = repoDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"repoDir.path");
            String string3 = string2;
            string2 = FilesKt.resolve((File)repoDir, (String)it).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"repoDir.resolve(it).path");
            ContractPathData contractPathData = new ContractPathData(string3, string2);
            collection.add(contractPathData);
        }
        return (List)destination$iv$iv;
    }

    private final File localRepoDir(String workingDirectory) {
        return FilesKt.resolve((File)new File(workingDirectory), (String)"repos");
    }

    @Override
    public void install(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        File sourceDir = FilesKt.resolve((File)workingDirectory, (String)this.repoName);
        Object object = sourceDir.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sourceDir.path");
        SystemGit sourceGit = new SystemGit((String)object, null, 2, null);
        try {
            object = Intrinsics.stringPlus((String)"Checking ", (Object)sourceDir.getPath());
            boolean bl = false;
            System.out.println(object);
            if (!sourceDir.exists()) {
                sourceDir.mkdirs();
            }
            if (!sourceGit.workingDirectoryIsGitRepo()) {
                object = "Found it, not a git dir, recreating...";
                bl = false;
                System.out.println(object);
                FilesKt.deleteRecursively((File)sourceDir);
                sourceDir.mkdirs();
                object = "Cloning " + this.gitRepositoryURL + " into " + sourceDir.getAbsolutePath();
                bl = false;
                System.out.println(object);
                object = sourceDir.getAbsoluteFile();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sourceDir.absoluteFile");
                sourceGit.clone(this.gitRepositoryURL, (File)object);
            } else {
                object = "Git repo already exists at " + sourceDir.getPath() + ", so ignoring it and moving on";
                bl = false;
                System.out.println(object);
            }
        }
        catch (Throwable e) {
            String string = "Could not clone " + this.gitRepositoryURL + '\n' + e.getClass().getName() + ": " + Utilities.exceptionCauseMessage(e);
            boolean bl = false;
            System.out.println((Object)string);
        }
    }

    @NotNull
    public final String component1() {
        return this.gitRepositoryURL;
    }

    @NotNull
    public final List<String> component2() {
        return this.getTestContracts();
    }

    @NotNull
    public final List<String> component3() {
        return this.getStubContracts();
    }

    @NotNull
    public final GitRepo copy(@NotNull String gitRepositoryURL, @NotNull List<String> testContracts, @NotNull List<String> stubContracts) {
        Intrinsics.checkNotNullParameter((Object)gitRepositoryURL, (String)"gitRepositoryURL");
        Intrinsics.checkNotNullParameter(testContracts, (String)"testContracts");
        Intrinsics.checkNotNullParameter(stubContracts, (String)"stubContracts");
        return new GitRepo(gitRepositoryURL, testContracts, stubContracts);
    }

    public static /* synthetic */ GitRepo copy$default(GitRepo gitRepo, String string, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string = gitRepo.gitRepositoryURL;
        }
        if ((n & 2) != 0) {
            list = gitRepo.getTestContracts();
        }
        if ((n & 4) != 0) {
            list2 = gitRepo.getStubContracts();
        }
        return gitRepo.copy(string, list, list2);
    }

    @NotNull
    public String toString() {
        return "GitRepo(gitRepositoryURL=" + this.gitRepositoryURL + ", testContracts=" + this.getTestContracts() + ", stubContracts=" + this.getStubContracts() + ')';
    }

    public int hashCode() {
        int result2 = this.gitRepositoryURL.hashCode();
        result2 = result2 * 31 + ((Object)this.getTestContracts()).hashCode();
        result2 = result2 * 31 + ((Object)this.getStubContracts()).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitRepo)) {
            return false;
        }
        GitRepo gitRepo = (GitRepo)other;
        if (!Intrinsics.areEqual((Object)this.gitRepositoryURL, (Object)gitRepo.gitRepositoryURL)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getTestContracts(), gitRepo.getTestContracts())) {
            return false;
        }
        return Intrinsics.areEqual(this.getStubContracts(), gitRepo.getStubContracts());
    }
}

