/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.wsdl.parser.message;

import in.specmatic.core.value.StringValue;
import in.specmatic.core.value.XMLNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0015\u001a\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\b\"\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\b\u00a8\u0006\u001c"}, d2={"MULTIPLE_ATTRIBUTE_VALUE", "", "OCCURS_ATTRIBUTE_NAME", "OCCURS_ATTRIBUTE_NAME_LEGACY", "OPTIONAL_ATTRIBUTE_VALUE", "primitiveBooleanType", "", "getPrimitiveBooleanType", "()Ljava/util/List;", "primitiveDateTypes", "getPrimitiveDateTypes", "primitiveNamespace", "primitiveNumberTypes", "getPrimitiveNumberTypes", "primitiveStringTypes", "getPrimitiveStringTypes", "primitiveTypes", "getPrimitiveTypes", "elementIsOptional", "", "element", "Lin/specmatic/core/value/XMLNode;", "getQontractAttributes", "", "Lin/specmatic/core/value/StringValue;", "isPrimitiveType", "node", "multipleElementsCanExist", "core"})
public final class ParseMessageWithElementRefKt {
    @NotNull
    private static final List<String> primitiveStringTypes;
    @NotNull
    private static final List<String> primitiveNumberTypes;
    @NotNull
    private static final List<String> primitiveDateTypes;
    @NotNull
    private static final List<String> primitiveBooleanType;
    @NotNull
    private static final List<String> primitiveTypes;
    @NotNull
    public static final String primitiveNamespace = "http://www.w3.org/2001/XMLSchema";
    @NotNull
    public static final String OCCURS_ATTRIBUTE_NAME = "specmatic_occurs";
    @NotNull
    public static final String OCCURS_ATTRIBUTE_NAME_LEGACY = "qontract_occurs";
    @NotNull
    public static final String OPTIONAL_ATTRIBUTE_VALUE = "optional";
    @NotNull
    public static final String MULTIPLE_ATTRIBUTE_VALUE = "multiple";

    @NotNull
    public static final Map<String, StringValue> getQontractAttributes(@NotNull XMLNode element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return ParseMessageWithElementRefKt.elementIsOptional(element) ? MapsKt.mapOf((Pair)TuplesKt.to((Object)OCCURS_ATTRIBUTE_NAME, (Object)new StringValue(OPTIONAL_ATTRIBUTE_VALUE))) : (ParseMessageWithElementRefKt.multipleElementsCanExist(element) ? MapsKt.mapOf((Pair)TuplesKt.to((Object)OCCURS_ATTRIBUTE_NAME, (Object)new StringValue(MULTIPLE_ATTRIBUTE_VALUE))) : MapsKt.emptyMap());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean multipleElementsCanExist(XMLNode element) {
        if (!element.getAttributes().containsKey("maxOccurs")) return false;
        Object object = element.getAttributes().get("maxOccurs");
        if (Intrinsics.areEqual((Object)(object == null ? null : ((StringValue)object).toStringLiteral()), (Object)"unbounded")) return true;
        object = ((StringValue)MapsKt.getValue(element.getAttributes(), (Object)"maxOccurs")).toStringLiteral();
        boolean bl = false;
        if (Integer.parseInt((String)object) <= 1) return false;
        return true;
    }

    private static final boolean elementIsOptional(XMLNode element) {
        StringValue stringValue = element.getAttributes().get("minOccurs");
        return Intrinsics.areEqual((Object)(stringValue == null ? null : stringValue.toStringLiteral()), (Object)"0") && (!element.getAttributes().containsKey("maxOccurs") || Intrinsics.areEqual((Object)((StringValue)MapsKt.getValue(element.getAttributes(), (Object)"maxOccurs")).toStringLiteral(), (Object)"1"));
    }

    public static final boolean isPrimitiveType(@NotNull XMLNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String type = ((StringValue)MapsKt.getValue(node.getAttributes(), (Object)"type")).toStringLiteral();
        String namespace = node.resolveNamespace(type);
        if (StringsKt.isBlank((CharSequence)namespace)) {
            return primitiveTypes.contains(type);
        }
        return Intrinsics.areEqual((Object)namespace, (Object)primitiveNamespace);
    }

    @NotNull
    public static final List<String> getPrimitiveStringTypes() {
        return primitiveStringTypes;
    }

    @NotNull
    public static final List<String> getPrimitiveNumberTypes() {
        return primitiveNumberTypes;
    }

    @NotNull
    public static final List<String> getPrimitiveDateTypes() {
        return primitiveDateTypes;
    }

    @NotNull
    public static final List<String> getPrimitiveBooleanType() {
        return primitiveBooleanType;
    }

    @NotNull
    public static final List<String> getPrimitiveTypes() {
        return primitiveTypes;
    }

    static {
        Object[] objectArray = new String[]{"string", "duration", "time", "date", "gYearMonth", "gYear", "gMonthDay", "gDay", "gMonth", "hexBinary", "base64Binary", "anyURI", "QName", "NOTATION"};
        primitiveStringTypes = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"int", "integer", "long", "decimal", "float", "double", "numeric"};
        primitiveNumberTypes = CollectionsKt.listOf((Object[])objectArray);
        primitiveDateTypes = CollectionsKt.listOf((Object)"dateTime");
        primitiveBooleanType = CollectionsKt.listOf((Object)"boolean");
        primitiveTypes = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)primitiveStringTypes, (Iterable)primitiveNumberTypes), (Iterable)primitiveDateTypes), (Iterable)primitiveBooleanType);
    }
}

