/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.test;

import in.specmatic.core.Result;
import in.specmatic.core.Scenario;
import in.specmatic.core.ScenarioKt;
import in.specmatic.core.pattern.KafkaMessagePattern;
import in.specmatic.stub.API;
import in.specmatic.test.ContractTest;
import in.specmatic.test.HttpClient;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J6\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0013H\u0016J\b\u0010\u0015\u001a\u00020\nH\u0002J(\u0010\u0016\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u001a\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J$\u0010\u0018\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u001b\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lin/specmatic/test/ScenarioTest;", "Lin/specmatic/test/ContractTest;", "scenario", "Lin/specmatic/core/Scenario;", "(Lin/specmatic/core/Scenario;)V", "getScenario", "()Lin/specmatic/core/Scenario;", "executeTest", "Lin/specmatic/core/Result;", "protocol", "", "host", "port", "timeout", "", "testScenario", "generateTestScenarios", "", "testVariables", "", "testBaseURLs", "getBootstrapKafkaServers", "runHttpTest", "runKafkaTest", "runTest", "testBaseURL", "timeOut", "testDescription", "core"})
public final class ScenarioTest
implements ContractTest {
    @NotNull
    private final Scenario scenario;

    public ScenarioTest(@NotNull Scenario scenario) {
        Intrinsics.checkNotNullParameter((Object)scenario, (String)"scenario");
        this.scenario = scenario;
    }

    @NotNull
    public final Scenario getScenario() {
        return this.scenario;
    }

    @Override
    @NotNull
    public List<ContractTest> generateTestScenarios(@NotNull Map<String, String> testVariables, @NotNull Map<String, String> testBaseURLs) {
        Intrinsics.checkNotNullParameter(testVariables, (String)"testVariables");
        Intrinsics.checkNotNullParameter(testBaseURLs, (String)"testBaseURLs");
        return this.scenario.generateContractTests(testVariables, testBaseURLs);
    }

    @Override
    @NotNull
    public String testDescription() {
        return this.scenario.testDescription();
    }

    @Override
    @NotNull
    public Result runTest(@Nullable String host, @Nullable String port, int timeout) {
        Result result2;
        KafkaMessagePattern kafkaMessagePattern = this.scenario.getKafkaMessagePattern();
        if (kafkaMessagePattern != null) {
            result2 = this.runKafkaTest(this.scenario);
        } else {
            String string = host;
            Intrinsics.checkNotNull((Object)string);
            String string2 = port;
            Intrinsics.checkNotNull((Object)string2);
            result2 = this.runHttpTest(timeout, string, string2, this.scenario);
        }
        return result2;
    }

    @Override
    @NotNull
    public Result runTest(@Nullable String testBaseURL, int timeOut) {
        Result result2;
        KafkaMessagePattern kafkaMessagePattern = this.scenario.getKafkaMessagePattern();
        if (kafkaMessagePattern != null) {
            result2 = this.runKafkaTest(this.scenario);
        } else {
            String string = testBaseURL;
            Intrinsics.checkNotNull((Object)string);
            HttpClient httpClient = new HttpClient(string, timeOut, null, null, 12, null);
            result2 = ScenarioKt.executeTest(this.scenario, httpClient).updateScenario(this.scenario);
        }
        return result2;
    }

    private final Result runKafkaTest(Scenario testScenario) {
        if (System.getProperty("kafkaPort") == null) {
            String string = "The contract has a kafka message. Please specify the port of the Kafka instance to connect to.";
            boolean bl = false;
            System.out.println((Object)string);
            int n = 1;
            bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        boolean commit = Intrinsics.areEqual((Object)"true", (Object)System.getProperty("commit"));
        return API.testKafkaMessages(testScenario, this.getBootstrapKafkaServers(), commit);
    }

    private final Result runHttpTest(int timeout, String host, String port, Scenario testScenario) {
        String string = System.getProperty("protocol");
        String protocol = string == null ? "http" : string;
        return this.executeTest(protocol, host, port, timeout, testScenario).updateScenario(this.scenario);
    }

    private final Result executeTest(String protocol, String host, String port, int timeout, Scenario testScenario) {
        HttpClient httpClient = new HttpClient(protocol + "://" + host + ':' + port, timeout, null, null, 12, null);
        return ScenarioKt.executeTest(testScenario, httpClient);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String getBootstrapKafkaServers() {
        int n;
        String string;
        CharSequence charSequence;
        if (System.getProperty("kafkaBootstrapServers") != null) {
            CharSequence charSequence2 = System.getProperty("kafkaBootstrapServers");
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getProperty(\"kafkaBootstrapServers\")");
            charSequence2 = charSequence2;
            boolean bl = false;
            if (charSequence2.length() > 0) {
                charSequence2 = System.getProperty("kafkaBootstrapServers");
                Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getProperty(\"kafkaBootstrapServers\")");
                charSequence = charSequence2;
                return charSequence;
            }
        }
        if ((string = System.getProperty("kafkaPort")) == null) {
            n = 9093;
        } else {
            int n2;
            String string2 = string;
            boolean bl = false;
            n = n2 = Integer.parseInt(string2);
        }
        int kafkaPort = n;
        String string3 = System.getProperty("kafkaHost");
        String kafkaHost = string3 == null ? "localhost" : string3;
        charSequence = "PLAINTEXT://" + kafkaHost + ':' + kafkaPort;
        return charSequence;
    }
}

