/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.log;

import in.specmatic.core.log.LogMessage;
import in.specmatic.core.utilities.Utilities;
import in.specmatic.core.value.JSONObjectValue;
import in.specmatic.core.value.StringValue;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lin/specmatic/core/log/VerboseExceptionLog;", "Lin/specmatic/core/log/LogMessage;", "e", "", "msg", "", "(Ljava/lang/Throwable;Ljava/lang/String;)V", "getE", "()Ljava/lang/Throwable;", "getMsg", "()Ljava/lang/String;", "toJSONObject", "Lin/specmatic/core/value/JSONObjectValue;", "toLogString", "core"})
public final class VerboseExceptionLog
implements LogMessage {
    @NotNull
    private final Throwable e;
    @Nullable
    private final String msg;

    public VerboseExceptionLog(@NotNull Throwable e, @Nullable String msg) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.e = e;
        this.msg = msg;
    }

    @NotNull
    public final Throwable getE() {
        return this.e;
    }

    @Nullable
    public final String getMsg() {
        return this.msg;
    }

    @Override
    @NotNull
    public JSONObjectValue toJSONObject() {
        Object object;
        Map data2;
        block3: {
            block2: {
                Pair[] pairArray = new Pair[3];
                String string = this.e.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                pairArray[0] = TuplesKt.to((Object)"className", (Object)new StringValue(string));
                pairArray[1] = TuplesKt.to((Object)"cause", (Object)new StringValue(Utilities.exceptionCauseMessage(this.e)));
                pairArray[2] = TuplesKt.to((Object)"stackTrace", (Object)new StringValue(ExceptionsKt.stackTraceToString((Throwable)this.e)));
                data2 = MapsKt.mapOf((Pair[])pairArray);
                object = this.msg;
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)new StringValue(this.msg)));
                object = map;
                if (map != null) break block3;
            }
            object = MapsKt.emptyMap();
        }
        Object message = object;
        return new JSONObjectValue(MapsKt.plus((Map)data2, (Map)message));
    }

    @Override
    @NotNull
    public String toLogString() {
        Object object;
        if (this.msg == null) {
            object = Utilities.exceptionCauseMessage(this.e);
        } else {
            String string = this.e.getLocalizedMessage();
            if (string == null && (string = this.e.getMessage()) == null) {
                string = this.e.getClass().getName();
            }
            object = this.msg + ": " + string;
        }
        String message = object;
        return message + System.lineSeparator() + ExceptionsKt.stackTraceToString((Throwable)this.e);
    }
}

