/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core;

import in.specmatic.core.Configuration;
import in.specmatic.core.Feature;
import in.specmatic.core.FeatureKt;
import in.specmatic.core.SpecmaticConfigJson;
import in.specmatic.core.SpecmaticConfigKt;
import in.specmatic.core.pattern.ContractException;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001\u001a\u0012\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0001\u001a\n\u0010\u001c\u001a\u00020\u001d*\u00020\u0001\u001a\n\u0010\u001e\u001a\u00020\u001f*\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u000e\u0010\t\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u000e\u0010\u0014\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"APPLICATION_NAME", "", "APPLICATION_NAME_LOWER_CASE", "APPLICATION_NAME_LOWER_CASE_LEGACY", "CONTRACT_EXTENSION", "CONTRACT_EXTENSIONS", "", "getCONTRACT_EXTENSIONS", "()Ljava/util/List;", "DATA_DIR_SUFFIX", "DEFAULT_WORKING_DIRECTORY", "JSON", "LEGACY_CONTRACT_EXTENSION", "OPENAPI_FILE_EXTENSIONS", "getOPENAPI_FILE_EXTENSIONS", "SPECMATIC_GITHUB_ISSUES", "SpecmaticJsonFormat", "Lkotlinx/serialization/json/Json;", "getSpecmaticJsonFormat", "()Lkotlinx/serialization/json/Json;", "WSDL", "YAML", "YML", "invalidContractExtensionMessage", "filename", "loadSpecmaticJsonConfig", "Lin/specmatic/core/SpecmaticConfigJson;", "configFileName", "isContractFile", "", "loadContract", "Lin/specmatic/core/Feature;", "core"})
@SourceDebugExtension(value={"SMAP\nSpecmaticConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecmaticConfig.kt\nin/specmatic/core/SpecmaticConfigKt\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,192:1\n96#2:193\n*S KotlinDebug\n*F\n+ 1 SpecmaticConfig.kt\nin/specmatic/core/SpecmaticConfigKt\n*L\n187#1:193\n*E\n"})
public final class SpecmaticConfigKt {
    @NotNull
    public static final String APPLICATION_NAME = "Specmatic";
    @NotNull
    public static final String APPLICATION_NAME_LOWER_CASE = "specmatic";
    @NotNull
    public static final String APPLICATION_NAME_LOWER_CASE_LEGACY = "qontract";
    @NotNull
    public static final String CONTRACT_EXTENSION = "spec";
    @NotNull
    public static final String LEGACY_CONTRACT_EXTENSION = "qontract";
    @NotNull
    public static final String YAML = "yaml";
    @NotNull
    public static final String WSDL = "wsdl";
    @NotNull
    public static final String YML = "yml";
    @NotNull
    public static final String JSON = "json";
    @NotNull
    private static final List<String> OPENAPI_FILE_EXTENSIONS;
    @NotNull
    private static final List<String> CONTRACT_EXTENSIONS;
    @NotNull
    public static final String DATA_DIR_SUFFIX = "_data";
    @NotNull
    public static final String SPECMATIC_GITHUB_ISSUES = "https://github.com/znsio/specmatic/issues";
    @NotNull
    public static final String DEFAULT_WORKING_DIRECTORY = ".specmatic";
    @NotNull
    private static final Json SpecmaticJsonFormat;

    @NotNull
    public static final List<String> getOPENAPI_FILE_EXTENSIONS() {
        return OPENAPI_FILE_EXTENSIONS;
    }

    @NotNull
    public static final List<String> getCONTRACT_EXTENSIONS() {
        return CONTRACT_EXTENSIONS;
    }

    @NotNull
    public static final String invalidContractExtensionMessage(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return "The file " + filename + " does not seem like a contract file. Valid extensions for contract files are " + CollectionsKt.joinToString$default((Iterable)CONTRACT_EXTENSIONS, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
    }

    public static final boolean isContractFile(@NotNull String $this$isContractFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isContractFile, (String)"<this>");
        return CONTRACT_EXTENSIONS.contains(FilesKt.getExtension((File)new File($this$isContractFile)));
    }

    @NotNull
    public static final Feature loadContract(@NotNull String $this$loadContract) {
        Intrinsics.checkNotNullParameter((Object)$this$loadContract, (String)"<this>");
        if (!SpecmaticConfigKt.isContractFile($this$loadContract)) {
            throw new ContractException(SpecmaticConfigKt.invalidContractExtensionMessage($this$loadContract), null, null, null, false, 30, null);
        }
        return FeatureKt.parseContractFileToFeature$default(new File($this$loadContract), null, null, null, null, null, null, null, 254, null);
    }

    @NotNull
    public static final Json getSpecmaticJsonFormat() {
        return SpecmaticJsonFormat;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SpecmaticConfigJson loadSpecmaticJsonConfig(@Nullable String configFileName) {
        File configFile;
        String string = configFileName;
        if (string == null) {
            string = Configuration.Companion.getGlobalConfigFileName();
        }
        if (!(configFile = new File(string)).exists()) {
            throw new ContractException("Could not find specmatic.json at path " + configFile.getCanonicalPath(), null, null, null, false, 30, null);
        }
        try {
            void this_$iv;
            Json json2 = SpecmaticJsonFormat;
            String string$iv = FilesKt.readText$default((File)configFile, null, (int)1, null);
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            return (SpecmaticConfigJson)this_$iv.decodeFromString((DeserializationStrategy)SpecmaticConfigJson.Companion.serializer(), string$iv);
        }
        catch (Throwable e) {
            throw new Exception("Your specmatic.json file may have some missing configuration sections. Please ensure that the specmatic.json file adheres to the schema described at: https://specmatic.in/documentation/specmatic_json.html#complete-sample-specmaticjson-with-all-attributes");
        }
    }

    public static /* synthetic */ SpecmaticConfigJson loadSpecmaticJsonConfig$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return SpecmaticConfigKt.loadSpecmaticJsonConfig(string);
    }

    static {
        Object[] objectArray = new String[]{YAML, YML, JSON};
        OPENAPI_FILE_EXTENSIONS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{CONTRACT_EXTENSION, "qontract", WSDL};
        CONTRACT_EXTENSIONS = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)OPENAPI_FILE_EXTENSIONS);
        SpecmaticJsonFormat = JsonKt.Json$default(null, (Function1)SpecmaticJsonFormat.1.INSTANCE, (int)1, null);
    }
}

