/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.pattern;

import in.specmatic.core.Resolver;
import in.specmatic.core.Result;
import in.specmatic.core.pattern.ConsumeResult;
import in.specmatic.core.pattern.ContractExceptionKt;
import in.specmatic.core.pattern.NullPattern;
import in.specmatic.core.pattern.NumberPatternKt;
import in.specmatic.core.pattern.PairOfTypes;
import in.specmatic.core.pattern.Pattern;
import in.specmatic.core.pattern.Row;
import in.specmatic.core.pattern.ScalarType;
import in.specmatic.core.value.JSONArrayValue;
import in.specmatic.core.value.StringValue;
import in.specmatic.core.value.Value;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J2\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0010\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u00140\u0013j\u0002`\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u001e\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001c2\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u001a\u0010\u001d\u001a\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00010\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00000\u001c2\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00000\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u0018\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\b\u0010%\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006&"}, d2={"Lin/specmatic/core/pattern/UUIDPattern;", "Lin/specmatic/core/pattern/Pattern;", "Lin/specmatic/core/pattern/ScalarType;", "()V", "pattern", "", "getPattern", "()Ljava/lang/String;", "typeAlias", "getTypeAlias", "typeName", "getTypeName", "encompasses", "Lin/specmatic/core/Result;", "otherPattern", "thisResolver", "Lin/specmatic/core/Resolver;", "otherResolver", "typeStack", "", "Lin/specmatic/core/pattern/PairOfTypes;", "Lin/specmatic/core/pattern/TypeStack;", "generate", "Lin/specmatic/core/value/StringValue;", "resolver", "listOf", "Lin/specmatic/core/value/Value;", "valueList", "", "matches", "sampleData", "negativeBasedOn", "row", "Lin/specmatic/core/pattern/Row;", "newBasedOn", "parse", "value", "toString", "core"})
public final class UUIDPattern
implements Pattern,
ScalarType {
    @NotNull
    public static final UUIDPattern INSTANCE = new UUIDPattern();
    @NotNull
    private static final String typeName = "uuid";
    @NotNull
    private static final String pattern = "(uuid)";

    private UUIDPattern() {
    }

    @Override
    @NotNull
    public Result matches(@Nullable Value sampleData, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return sampleData instanceof StringValue ? ContractExceptionKt.resultOf((Function0<? extends Result>)((Function0)new Function0<Result>(sampleData, resolver){
            final /* synthetic */ Value $sampleData;
            final /* synthetic */ Resolver $resolver;
            {
                this.$sampleData = $sampleData;
                this.$resolver = $resolver;
                super(0);
            }

            @NotNull
            public final Result invoke() {
                UUIDPattern.INSTANCE.parse(((StringValue)this.$sampleData).getString(), this.$resolver);
                return new Result.Success(null, null, 3, null);
            }
        })) : (Result)new Result.Failure("UUID types can only be represented using strings", null, null, null, 14, null);
    }

    @Override
    @NotNull
    public StringValue generate(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new StringValue(string);
    }

    @NotNull
    public List<UUIDPattern> newBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return CollectionsKt.listOf((Object)this);
    }

    @NotNull
    public List<UUIDPattern> newBasedOn(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return CollectionsKt.listOf((Object)this);
    }

    @Override
    @NotNull
    public List<Pattern> negativeBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return CollectionsKt.listOf((Object)NullPattern.INSTANCE);
    }

    @Override
    @NotNull
    public StringValue parse(@NotNull String value2, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return (StringValue)ContractExceptionKt.attempt((Function0)new Function0<StringValue>(value2){
            final /* synthetic */ String $value;
            {
                this.$value = $value;
                super(0);
            }

            @NotNull
            public final StringValue invoke() {
                UUID.fromString(this.$value);
                return new StringValue(this.$value);
            }
        });
    }

    @Override
    @NotNull
    public Result encompasses(@NotNull Pattern otherPattern, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        Intrinsics.checkNotNullParameter((Object)otherPattern, (String)"otherPattern");
        Intrinsics.checkNotNullParameter((Object)thisResolver, (String)"thisResolver");
        Intrinsics.checkNotNullParameter((Object)otherResolver, (String)"otherResolver");
        Intrinsics.checkNotNullParameter(typeStack, (String)"typeStack");
        return NumberPatternKt.encompasses(this, otherPattern, thisResolver, otherResolver, typeStack);
    }

    @Override
    @NotNull
    public Value listOf(@NotNull List<? extends Value> valueList, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(valueList, (String)"valueList");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return new JSONArrayValue(valueList);
    }

    @Override
    @Nullable
    public String getTypeAlias() {
        return null;
    }

    @Override
    @NotNull
    public String getTypeName() {
        return typeName;
    }

    @Override
    @NotNull
    public String getPattern() {
        return pattern;
    }

    @NotNull
    public String toString() {
        return this.getPattern();
    }

    @Override
    @NotNull
    public ConsumeResult<Value, Value> matches(@NotNull List<? extends Value> sampleData, @NotNull Resolver resolver) {
        return Pattern.DefaultImpls.matches(this, sampleData, resolver);
    }

    @Override
    @NotNull
    public ConsumeResult<Pattern, Pattern> encompasses(@NotNull List<? extends Pattern> others, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull String lengthError, @NotNull Set<PairOfTypes> typeStack) {
        return Pattern.DefaultImpls.encompasses(this, others, thisResolver, otherResolver, lengthError, typeStack);
    }

    @Override
    @NotNull
    public Value generateWithAll(@NotNull Resolver resolver) {
        return Pattern.DefaultImpls.generateWithAll(this, resolver);
    }

    @Override
    @NotNull
    public List<Pattern> patternSet(@NotNull Resolver resolver) {
        return Pattern.DefaultImpls.patternSet(this, resolver);
    }

    @Override
    @NotNull
    public Pattern parseToType(@NotNull String valueString, @NotNull Resolver resolver) {
        return Pattern.DefaultImpls.parseToType(this, valueString, resolver);
    }

    @Override
    @NotNull
    public Result fitsWithin(@NotNull List<? extends Pattern> otherPatterns, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        return Pattern.DefaultImpls.fitsWithin(this, otherPatterns, thisResolver, otherResolver, typeStack);
    }

    @Override
    @NotNull
    public Pattern toNullable(@Nullable String defaultValue) {
        return Pattern.DefaultImpls.toNullable(this, defaultValue);
    }
}

