/*
 * Decompiled with CFR 0.152.
 */
package in.specmatic.core.git;

import in.specmatic.core.Configuration;
import in.specmatic.core.azure.AuthCredentials;
import in.specmatic.core.azure.NoGitAuthCredentials;
import in.specmatic.core.git.GitCommand;
import in.specmatic.core.git.GitOperations;
import in.specmatic.core.git.NonZeroExitError;
import in.specmatic.core.log.LoggingKt;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.utilities.ExternalCommand;
import in.specmatic.core.utilities.Utilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\u0000H\u0016J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0000H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0002J\b\u0010\u001a\u001a\u00020\u0003H\u0016J!\u0010\u001b\u001a\u00020\u00032\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u001d\"\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0016\u0010\u001b\u001a\u00020\u00032\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0002J+\u0010 \u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dH\u0002\u00a2\u0006\u0002\u0010!J!\u0010\"\u001a\u00020\u00032\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u001d\"\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010&\u001a\u00020\u0003H\u0016J\u0010\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020\u0003H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0016J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030\u001f2\u0006\u0010+\u001a\u00020\u0003J\b\u0010,\u001a\u00020\u0003H\u0016J\u001a\u0010-\u001a\u0004\u0018\u00010\u00152\u0006\u0010.\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0016J\u0010\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0003H\u0016J\b\u00102\u001a\u00020\u0003H\u0016J\u0010\u00103\u001a\u00020\u00012\u0006\u00104\u001a\u00020\u0003H\u0016J\u0006\u00105\u001a\u00020\u0000J\u0010\u00106\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u00107\u001a\u00020\u0000H\u0016J\b\u00108\u001a\u00020\u0000H\u0016J\b\u00109\u001a\u00020\u0000H\u0016J\u001c\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00030;2\u0006\u0010(\u001a\u00020\u0003H\u0016J\b\u0010<\u001a\u00020\u0000H\u0016J\b\u0010=\u001a\u00020\u0000H\u0016J\b\u0010>\u001a\u00020?H\u0016J\u0018\u0010@\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010A\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010B\u001a\u00020\u0003H\u0016J\b\u0010C\u001a\u00020$H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006D"}, d2={"Lin/specmatic/core/git/SystemGit;", "Lin/specmatic/core/git/GitCommand;", "workingDirectory", "", "prefix", "authCredentials", "Lin/specmatic/core/azure/AuthCredentials;", "(Ljava/lang/String;Ljava/lang/String;Lin/specmatic/core/azure/AuthCredentials;)V", "getAuthCredentials", "()Lin/specmatic/core/azure/AuthCredentials;", "getWorkingDirectory", "()Ljava/lang/String;", "add", "relativePath", "checkIgnore", "path", "checkout", "branchName", "clone", "gitRepositoryURI", "cloneDirectory", "Ljava/io/File;", "commit", "currentBranch", "defaultBranch", "defaultBranchFromGit", "detachedHEAD", "execute", "command", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "executeCommandWithWorkingDirectory", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "executeWithAuth", "exists", "", "treeish", "fetch", "fileIsInGitDir", "newerContractPath", "getChangedFiles", "getChangesFromMainBranch", "mainBranch", "getCurrentBranch", "getFileInTheDefaultBranch", "fileName", "getFilesChangeInCurrentBranch", "getRemoteUrl", "name", "gitRoot", "inGitRootOf", "contractPath", "init", "merge", "mergeAbort", "pull", "push", "relativeGitPath", "Lkotlin/Pair;", "resetHard", "resetMixed", "revisionsBehindCount", "", "shallowClone", "show", "statusPorcelain", "workingDirectoryIsGitRepo", "core"})
@SourceDebugExtension(value={"SMAP\nSystemGit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SystemGit.kt\nin/specmatic/core/git/SystemGit\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n37#2,2:188\n37#2,2:190\n1#3:192\n766#4:193\n857#4,2:194\n1549#4:196\n1620#4,3:197\n*S KotlinDebug\n*F\n+ 1 SystemGit.kt\nin/specmatic/core/git/SystemGit\n*L\n21#1:188,2\n24#1:190,2\n90#1:193\n90#1:194,2\n133#1:196\n133#1:197,3\n*E\n"})
public final class SystemGit
implements GitCommand {
    @NotNull
    private final String workingDirectory;
    @NotNull
    private final String prefix;
    @NotNull
    private final AuthCredentials authCredentials;

    public SystemGit(@NotNull String workingDirectory, @NotNull String prefix2, @NotNull AuthCredentials authCredentials) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)authCredentials, (String)"authCredentials");
        this.workingDirectory = workingDirectory;
        this.prefix = prefix2;
        this.authCredentials = authCredentials;
    }

    public /* synthetic */ SystemGit(String string, String string2, AuthCredentials authCredentials, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = ".";
        }
        if ((n & 2) != 0) {
            string2 = "- ";
        }
        if ((n & 4) != 0) {
            authCredentials = NoGitAuthCredentials.INSTANCE;
        }
        this(string, string2, authCredentials);
    }

    @Override
    @NotNull
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @NotNull
    public final AuthCredentials getAuthCredentials() {
        return this.authCredentials;
    }

    private final String executeWithAuth(String ... command) {
        List gitExecutable = CollectionsKt.listOf((Object)Configuration.Companion.getGitCommand());
        List<String> auth = this.authCredentials.gitCommandAuthHeaders();
        return this.execute(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)gitExecutable, (Iterable)auth), (Iterable)ArraysKt.toList((Object[])command)));
    }

    private final String execute(List<String> command) {
        Collection $this$toTypedArray$iv = CollectionsKt.toList((Iterable)command);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return this.executeCommandWithWorkingDirectory(this.prefix, this.getWorkingDirectory(), thisCollection$iv.toArray(new String[0]));
    }

    private final String execute(String ... command) {
        Collection $this$toTypedArray$iv = ArraysKt.toList((Object[])command);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return this.executeCommandWithWorkingDirectory(this.prefix, this.getWorkingDirectory(), thisCollection$iv.toArray(new String[0]));
    }

    private final String executeCommandWithWorkingDirectory(String prefix2, String workingDirectory, String[] command) {
        LoggingKt.getLogger().debug(prefix2 + "Executing: " + ArraysKt.joinToString$default((Object[])command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        return new ExternalCommand(command, workingDirectory, (Map<String, String>)MapsKt.mapOf((Pair)TuplesKt.to((Object)"GIT_SSL_NO_VERIFY", (Object)"true"))).executeAsSeparateProcess();
    }

    @NotNull
    public final SystemGit init() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "init"};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit add() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "add", "."};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit add(@NotNull String relativePath) {
        SystemGit systemGit;
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "add", relativePath};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit commit() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "commit", "-m", "Updated contract"};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit push() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "push"};
        this.executeWithAuth(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit pull() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "pull"};
        this.executeWithAuth(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit resetHard() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "reset", "--hard", "HEAD"};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit resetMixed() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "reset", "--mixed", "HEAD"};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit mergeAbort() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "merge", "--aborg"};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit checkout(@NotNull String branchName) {
        SystemGit systemGit;
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "checkout", branchName};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit merge(@NotNull String branchName) {
        SystemGit systemGit;
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "merge", branchName};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit clone(@NotNull String gitRepositoryURI, @NotNull File cloneDirectory) {
        SystemGit systemGit;
        Intrinsics.checkNotNullParameter((Object)gitRepositoryURI, (String)"gitRepositoryURI");
        Intrinsics.checkNotNullParameter((Object)cloneDirectory, (String)"cloneDirectory");
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[3];
        stringArray[0] = "clone";
        Map<String, String> map = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getenv(...)");
        stringArray[1] = GitOperations.evaluateEnvVariablesInGitRepoURI(gitRepositoryURI, map);
        Intrinsics.checkNotNullExpressionValue((Object)cloneDirectory.getAbsolutePath(), (String)"getAbsolutePath(...)");
        this.executeWithAuth(stringArray);
        return systemGit;
    }

    @Override
    public boolean exists(@NotNull String treeish, @NotNull String relativePath) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)treeish, (String)"treeish");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        try {
            this.show(treeish, relativePath);
            bl = true;
        }
        catch (NonZeroExitError e) {
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public String getCurrentBranch() {
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "git", "diff", "--name-only", "master"};
        return this.execute(stringArray);
    }

    @Override
    @NotNull
    public String statusPorcelain() {
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "status", "--porcelain"};
        return this.execute(stringArray);
    }

    @Override
    @NotNull
    public String fetch() {
        String[] stringArray = new String[]{"fetch"};
        return this.executeWithAuth(stringArray);
    }

    @Override
    public int revisionsBehindCount() {
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "rev-list", "--count", "HEAD..@{u}"};
        return Integer.parseInt(((Object)StringsKt.trim((CharSequence)this.execute(stringArray))).toString());
    }

    @Override
    @NotNull
    public String checkIgnore(@NotNull String path2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        try {
            object = new String[]{Configuration.Companion.getGitCommand(), "check-ignore", path2};
            object = this.execute((String)object);
        }
        catch (NonZeroExitError nonZeroExitError) {
            object = "";
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getFilesChangeInCurrentBranch() {
        void $this$filterTo$iv$iv;
        String defaultBranch = this.defaultBranch();
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "diff", defaultBranch, "HEAD", "--name-only"};
        String result2 = this.execute(stringArray);
        CharSequence charSequence = result2;
        stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)System.lineSeparator(), (String)"lineSeparator(...)");
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public File getFileInTheDefaultBranch(@NotNull String fileName, @NotNull String currentBranch) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)currentBranch, (String)"currentBranch");
        try {
            this.checkout(this.defaultBranch());
            if (!new File(fileName).exists()) {
                File file = null;
                return file;
            }
            File file = new File(fileName);
            return file;
        }
        finally {
            this.checkout(currentBranch);
        }
    }

    @Override
    @NotNull
    public SystemGit shallowClone(@NotNull String gitRepositoryURI, @NotNull File cloneDirectory) {
        SystemGit systemGit;
        Intrinsics.checkNotNullParameter((Object)gitRepositoryURI, (String)"gitRepositoryURI");
        Intrinsics.checkNotNullParameter((Object)cloneDirectory, (String)"cloneDirectory");
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[5];
        stringArray[0] = "clone";
        stringArray[1] = "--depth";
        stringArray[2] = "1";
        stringArray[3] = gitRepositoryURI;
        Intrinsics.checkNotNullExpressionValue((Object)cloneDirectory.getAbsolutePath(), (String)"getAbsolutePath(...)");
        this.executeWithAuth(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public String gitRoot() {
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "rev-parse", "--show-toplevel"};
        return ((Object)StringsKt.trim((CharSequence)this.execute(stringArray))).toString();
    }

    @Override
    @NotNull
    public String show(@NotNull String treeish, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)treeish, (String)"treeish");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "show", treeish + ":" + relativePath};
        return this.execute(stringArray);
    }

    @Override
    public boolean workingDirectoryIsGitRepo() {
        boolean bl;
        try {
            String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "rev-parse", "--is-inside-work-tree"};
            bl = Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)this.execute(stringArray))).toString(), (Object)"true");
        }
        catch (Throwable e) {
            boolean bl2;
            boolean it = bl2 = false;
            boolean bl3 = false;
            LoggingKt.getLogger().debug("This must not be a git dir, got error " + e.getClass().getName() + ": " + Utilities.exceptionCauseMessage(e));
            bl = bl2;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getChangedFiles() {
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "status", "--porcelain=1"};
        String result2 = ((Object)StringsKt.trim((CharSequence)this.execute(stringArray))).toString();
        if (((CharSequence)result2).length() == 0) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = StringsKt.lines((CharSequence)result2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{" "};
            collection.add((String)StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString(), (String[])stringArray2, (boolean)false, (int)2, (int)2, null).get(1));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public Pair<SystemGit, String> relativeGitPath(@NotNull String newerContractPath) {
        Intrinsics.checkNotNullParameter((Object)newerContractPath, (String)"newerContractPath");
        String string = new File(newerContractPath).getAbsoluteFile().getParent();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParent(...)");
        File gitRoot = new File(new SystemGit(string, null, null, 6, null).gitRoot());
        String string2 = gitRoot.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        SystemGit git = new SystemGit(string2, null, null, 6, null);
        File file = new File(newerContractPath).getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAbsoluteFile(...)");
        File file2 = gitRoot.getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAbsoluteFile(...)");
        String relativeContractPath = FilesKt.relativeTo((File)file, (File)file2).getPath();
        return new Pair((Object)git, (Object)relativeContractPath);
    }

    @Override
    public boolean fileIsInGitDir(@NotNull String newerContractPath) {
        Intrinsics.checkNotNullParameter((Object)newerContractPath, (String)"newerContractPath");
        String parentDir = new File(newerContractPath).getAbsoluteFile().getParentFile().getAbsolutePath();
        Intrinsics.checkNotNull((Object)parentDir);
        return new SystemGit(parentDir, null, null, 6, null).workingDirectoryIsGitRepo();
    }

    @Override
    @NotNull
    public GitCommand inGitRootOf(@NotNull String contractPath) {
        Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
        String string = new File(contractPath).getParentFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return new SystemGit(string, null, null, 6, null);
    }

    @NotNull
    public final List<String> getChangesFromMainBranch(@NotNull String mainBranch) {
        Intrinsics.checkNotNullParameter((Object)mainBranch, (String)"mainBranch");
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "diff", "--name-only", mainBranch};
        CharSequence charSequence = this.execute(stringArray);
        stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)System.lineSeparator(), (String)"lineSeparator(...)");
        return StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
    }

    @Override
    @NotNull
    public String getRemoteUrl(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "remote", "get-url", name};
        return this.execute(stringArray);
    }

    @Override
    @NotNull
    public String currentBranch() {
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "rev-parse", "--abbrev-ref", "HEAD"};
        return ((Object)StringsKt.trim((CharSequence)this.execute(stringArray))).toString();
    }

    @Override
    @NotNull
    public String defaultBranch() {
        String string = System.getenv("GITHUB_BASE_REF");
        if (string == null) {
            string = this.defaultBranchFromGit();
        }
        String defaultBranchName = string;
        return "origin/" + defaultBranchName;
    }

    private final String defaultBranchFromGit() {
        String symbolicRef;
        String string = System.getenv("GITHUB_BASE_REF");
        if (string == null) {
            String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "symbolic-ref", "refs/remotes/origin/HEAD", "--short"};
            string = this.execute(stringArray);
        }
        if (!StringsKt.contains$default((CharSequence)(symbolicRef = string), (CharSequence)"/", (boolean)false, (int)2, null)) {
            throw new ContractException("Could not understand symbolic-ref value " + symbolicRef + ", expected it to be of the format remote/branch name.", null, null, null, false, 30, null);
        }
        String[] stringArray = new String[]{"/"};
        return ((Object)StringsKt.trim((CharSequence)((String)StringsKt.split$default((CharSequence)symbolicRef, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1)))).toString();
    }

    @Override
    @NotNull
    public String detachedHEAD() {
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "show", "-s", "--pretty=%D", "HEAD"};
        String result2 = this.execute(stringArray);
        stringArray = new String[]{","};
        return ((Object)StringsKt.trim((CharSequence)((String)StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)result2)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1)))).toString();
    }

    public SystemGit() {
        this(null, null, null, 7, null);
    }
}

