/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.beckn;

import com.venky.core.security.Crypt;
import java.io.Serializable;
import org.json.simple.JSONAware;
import org.json.simple.JSONValue;

public abstract class BecknAware<T extends JSONAware>
implements Serializable {
    private String payload;
    private T value;

    protected BecknAware(T value) {
        this.value = value;
        if (value == null) {
            throw new NullPointerException();
        }
    }

    protected BecknAware(String payload) {
        this((JSONAware)JSONValue.parse((String)payload));
        this.payload = payload;
    }

    public void setInner(T value) {
        this.value = value;
    }

    public T getInner() {
        return this.value;
    }

    public String toString() {
        if (this.payload == null) {
            return this.value.toJSONString();
        }
        return this.payload;
    }

    public String hash() {
        return BecknAware.generateBlakeHash(this.toString());
    }

    public static String generateBlakeHash(String req) {
        return Crypt.getInstance().toBase64(Crypt.getInstance().digest("BLAKE2B-512", req));
    }
}

