/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.beckn;

import com.venky.core.util.ObjectHolder;
import com.venky.core.util.ObjectUtil;
import com.venky.geo.GeoCoordinate;
import in.succinct.beckn.Address;
import in.succinct.beckn.BecknObjectWithId;
import in.succinct.beckn.Circle;
import in.succinct.beckn.City;
import in.succinct.beckn.Country;
import in.succinct.beckn.Descriptor;
import java.math.BigDecimal;
import java.util.StringTokenizer;

public class Location
extends BecknObjectWithId {
    ObjectHolder<GeoCoordinate> gps = null;

    public Location() {
    }

    public Location(String payload) {
        super(payload);
    }

    public GeoCoordinate getGps() {
        if (this.gps == null) {
            this.gps = new ObjectHolder(null);
            String gps = (String)this.get("gps");
            if (!ObjectUtil.isVoid((Object)gps)) {
                StringTokenizer tokenizer = new StringTokenizer(gps, ",");
                String lat = tokenizer.nextToken().trim();
                String lng = tokenizer.nextToken().trim();
                this.gps.set((Object)new GeoCoordinate(new BigDecimal(lat), new BigDecimal(lng)));
            }
        }
        return (GeoCoordinate)this.gps.get();
    }

    public void setGps(GeoCoordinate coordinate) {
        this.set("gps", String.format("%f,%f", coordinate.getLat(), coordinate.getLng()));
        if (this.gps == null) {
            this.gps = new ObjectHolder((Object)coordinate);
        } else {
            this.gps.set((Object)coordinate);
        }
    }

    public City getCity() {
        return this.get(City.class, "city");
    }

    public void setCity(City city) {
        this.set("city", city);
    }

    public Country getCountry() {
        return this.get(Country.class, "country");
    }

    public void setCountry(Country country) {
        this.set("country", country);
    }

    public Circle getCircle() {
        return this.get(Circle.class, "circle");
    }

    public void setCircle(Circle circle) {
        this.set("circle", circle);
    }

    public Address getAddress() {
        return this.get(Address.class, "address");
    }

    public void setAddress(Address address) {
        this.set("address", address);
    }

    public Descriptor getDescriptor() {
        return this.get(Descriptor.class, "descriptor");
    }

    public void setDescriptor(Descriptor descriptor) {
        this.set("descriptor", descriptor);
    }
}

