/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.beckn;

import com.venky.core.collections.IgnoreCaseMap;
import com.venky.core.collections.SequenceMap;
import com.venky.core.security.Crypt;
import com.venky.core.util.ObjectHolder;
import com.venky.core.util.ObjectUtil;
import com.venky.extension.Registry;
import in.succinct.beckn.BecknObject;
import in.succinct.beckn.CancellationReasons;
import in.succinct.beckn.Context;
import in.succinct.beckn.Error;
import in.succinct.beckn.FeedbackCategories;
import in.succinct.beckn.Message;
import in.succinct.beckn.RatingCategories;
import in.succinct.beckn.ReturnReasons;
import java.lang.reflect.Field;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Base64;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPublicKey;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public class Request
extends BecknObject {
    private BecknObject extendedAttributes = new BecknObject();
    public static String SIGNATURE_ALGO = "Ed25519";
    public static int SIGNATURE_ALGO_KEY_LENGTH = 256;
    public static String ENCRYPTION_ALGO = "X25519";
    public static int ENCRYPTION_ALGO_KEY_LENGTH = 256;

    public Request() {
        this(new JSONObject());
    }

    public Request(String payLoad) {
        super(payLoad);
    }

    public Request(JSONObject request) {
        super(request);
    }

    public Context getContext() {
        return this.get(Context.class, "context");
    }

    public void setContext(Context context) {
        this.set("context", (JSONAware)context.getInner());
    }

    public Message getMessage() {
        return this.get(Message.class, "message");
    }

    public void setMessage(Message message) {
        this.set("message", (JSONAware)message.getInner());
    }

    public Error getError() {
        return this.get(Error.class, "error");
    }

    public void setError(Error error) {
        this.set("error", (JSONAware)error.getInner());
    }

    public RatingCategories getRatingCategories() {
        return this.get(RatingCategories.class, "rating_categories");
    }

    public void setRatingCategories(RatingCategories rating_categories) {
        this.set("rating_categories", rating_categories);
    }

    public FeedbackCategories getFeedbackCategories() {
        return this.get(FeedbackCategories.class, "feedback_categories");
    }

    public void setFeedbackCategories(FeedbackCategories feedback_categories) {
        this.set("feedback_categories", feedback_categories);
    }

    public CancellationReasons getCancellationReasons() {
        return this.get(CancellationReasons.class, "cancellation_reasons");
    }

    public void setCancellationReasons(CancellationReasons cancellation_reasons) {
        this.set("cancellation_reasons", cancellation_reasons);
    }

    public ReturnReasons getReturnReasons() {
        return this.get(ReturnReasons.class, "return_reasons");
    }

    public void setReturnReasons(ReturnReasons return_reasons) {
        this.set("return_reasons", return_reasons);
    }

    public String getSigningString(long created_at, long expires_at) {
        StringBuilder builder = new StringBuilder();
        builder.append("(created): ").append(created_at);
        builder.append("\n(expires): ").append(expires_at);
        builder.append("\n").append("digest: BLAKE-512=").append(this.hash());
        return builder.toString();
    }

    public boolean verifySignature(String header, Map<String, String> httpRequestHeaders) {
        return this.verifySignature(header, httpRequestHeaders, true);
    }

    public boolean verifySignature(Map<String, String> params, boolean headerMandatory) {
        if (params.isEmpty()) {
            return !headerMandatory;
        }
        String signature = params.get("signature");
        String created = params.get("created");
        String expires = params.get("expires");
        String keyId = params.get("keyId");
        String subscriberId = params.get("subscriber_id");
        String pub_key_id = params.get("pub_key_id");
        String signingString = this.getSigningString(Long.parseLong(created), Long.parseLong(expires));
        System.out.println("Signing String:" + signingString);
        System.out.println("Signature:" + signature);
        System.out.println("pub_key_id:" + pub_key_id);
        return Request.verifySignature(signature, signingString, Request.getPublicKey(subscriberId, pub_key_id));
    }

    public boolean verifySignature(String header, Map<String, String> httpRequestHeaders, boolean headerMandatory) {
        Map<String, String> params = this.extractAuthorizationParams(header, httpRequestHeaders);
        return this.verifySignature(params, headerMandatory);
    }

    public static String getPublicKey(String subscriber_id, String keyId) {
        ObjectHolder publicKeyHolder = new ObjectHolder(null);
        Registry.instance().callExtensions("beckn.public.key.get", new Object[]{subscriber_id, keyId, publicKeyHolder});
        return (String)publicKeyHolder.get();
    }

    public static String getPrivateKey(String subscriber_id, String keyId) {
        ObjectHolder privateKeyHolder = new ObjectHolder(null);
        Registry.instance().callExtensions("beckn.private.key.get", new Object[]{subscriber_id, keyId, privateKeyHolder});
        return (String)privateKeyHolder.get();
    }

    public String generateAuthorizationHeader(String subscriberId, String pub_key_id) {
        Map<String, String> map = this.generateAuthorizationParams(subscriberId, pub_key_id);
        StringBuilder auth = new StringBuilder();
        map.forEach((k, v) -> {
            if (auth.length() == 0) {
                auth.append("Signature ");
            } else {
                auth.append(",");
            }
            auth.append((String)k).append("=\"").append((String)v).append("\"");
        });
        return auth.toString();
    }

    public Map<String, String> extractAuthorizationParams(String header, Map<String, String> httpRequestHeaders) {
        String keyId;
        String signatureToken;
        IgnoreCaseMap params = new IgnoreCaseMap();
        if (!httpRequestHeaders.containsKey(header)) {
            return params;
        }
        String authorization = httpRequestHeaders.get(header).trim();
        if (authorization.startsWith(signatureToken = "Signature ")) {
            authorization = authorization.substring(signatureToken.length());
        }
        Matcher matcher = Pattern.compile("([A-z]+)(=)[\"]*([^\",]*)[\"]*[, ]*").matcher(authorization);
        matcher.results().forEach(arg_0 -> Request.lambda$extractAuthorizationParams$1((Map)params, arg_0));
        if (!params.isEmpty() && !ObjectUtil.isVoid((Object)(keyId = (String)params.get("keyId")))) {
            StringTokenizer keyTokenizer = new StringTokenizer(keyId, "|");
            String subscriberId = keyTokenizer.nextToken();
            String pub_key_id = keyTokenizer.nextToken();
            params.put("subscriber_id", subscriberId);
            params.put("pub_key_id", pub_key_id);
        }
        return params;
    }

    public Map<String, String> generateAuthorizationParams(String subscriberId, String pub_key_id) {
        SequenceMap map = new SequenceMap();
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(subscriberId).append('|').append(pub_key_id).append('|').append("ed25519");
        map.put("keyId", keyBuilder.toString());
        map.put("algorithm", "ed25519");
        long created_at = System.currentTimeMillis() / 1000L;
        long expires_at = created_at + (this.getContext() == null ? 10L : this.getContext().getTtl());
        map.put("created", Long.toString(created_at));
        map.put("expires", Long.toString(expires_at));
        map.put("headers", "(created) (expires) digest");
        map.put("signature", Request.generateSignature(this.getSigningString(created_at, expires_at), Request.getPrivateKey(subscriberId, pub_key_id)));
        return map;
    }

    public BecknObject getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public static String generateSignature(String req, String privateKey) {
        PrivateKey key = Crypt.getInstance().getPrivateKey(SIGNATURE_ALGO, privateKey);
        return Crypt.getInstance().generateSignature(req, SIGNATURE_ALGO, key);
    }

    public static boolean verifySignature(String sign, String requestData, String b64PublicKey) {
        System.out.println("Public Key:" + b64PublicKey);
        PublicKey key = Request.getSigningPublicKey(b64PublicKey);
        System.out.println("Public Key OK:" + (key != null));
        return Crypt.getInstance().verifySignature(requestData, sign, SIGNATURE_ALGO, key);
    }

    public static String getSubscriberId(Map<String, String> authParams) {
        if (!authParams.isEmpty()) {
            String keyId = authParams.get("keyId");
            StringTokenizer keyTokenizer = new StringTokenizer(keyId, "|");
            String subscriberId = keyTokenizer.nextToken();
            return subscriberId;
        }
        return null;
    }

    public static PublicKey getSigningPublicKey(String keyFromRegistry) {
        try {
            return Crypt.getInstance().getPublicKey(SIGNATURE_ALGO, keyFromRegistry);
        }
        catch (Exception ex) {
            try {
                byte[] bcBytes = Base64.getDecoder().decode(keyFromRegistry);
                byte[] jceBytes = new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), bcBytes).getEncoded();
                String pemKey = Base64.getEncoder().encodeToString(jceBytes);
                return Crypt.getInstance().getPublicKey(SIGNATURE_ALGO, pemKey);
            }
            catch (Exception jceEx) {
                return null;
            }
        }
    }

    public static PublicKey getEncryptionPublicKey(String keyFromRegistry) {
        try {
            return Crypt.getInstance().getPublicKey(ENCRYPTION_ALGO, keyFromRegistry);
        }
        catch (Exception ex) {
            try {
                byte[] bcBytes = Base64.getDecoder().decode(keyFromRegistry);
                byte[] jceBytes = new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X25519), bcBytes).getEncoded();
                String pemKey = Base64.getEncoder().encodeToString(jceBytes);
                return Crypt.getInstance().getPublicKey(ENCRYPTION_ALGO, pemKey);
            }
            catch (Exception jceEx) {
                return null;
            }
        }
    }

    public static String getRawSigningKey(PublicKey publicKey) {
        try {
            BCEdDSAPublicKey k = (BCEdDSAPublicKey)publicKey;
            Field f = k.getClass().getDeclaredField("eddsaPublicKey");
            f.setAccessible(true);
            Ed25519PublicKeyParameters publicKeyParameters = (Ed25519PublicKeyParameters)f.get(k);
            return Base64.getEncoder().encodeToString(publicKeyParameters.getEncoded());
        }
        catch (Exception ex) {
            throw new RuntimeException("Unknown Key format");
        }
    }

    public static String getRawEncryptionKey(PublicKey publicKey) {
        try {
            BCXDHPublicKey k = (BCXDHPublicKey)publicKey;
            Field f = k.getClass().getDeclaredField("xdhPublicKey");
            f.setAccessible(true);
            X25519PublicKeyParameters publicKeyParameters = (X25519PublicKeyParameters)f.get(k);
            return Base64.getEncoder().encodeToString(publicKeyParameters.getEncoded());
        }
        catch (Exception ex) {
            throw new RuntimeException("Unknown Key format");
        }
    }

    public static String getPemSigningKey(String keyFromRegistry) {
        return Base64.getEncoder().encodeToString(Request.getSigningPublicKey(keyFromRegistry).getEncoded());
    }

    public static String getPemEncryptionKey(String keyFromRegistry) {
        return Base64.getEncoder().encodeToString(Request.getEncryptionPublicKey(keyFromRegistry).getEncoded());
    }

    public static String getRawSigningKey(String keyFromRegistry) {
        return Request.getRawSigningKey(Request.getSigningPublicKey(keyFromRegistry));
    }

    public static String getRawEncryptionKey(String keyFromRegistry) {
        return Request.getRawEncryptionKey(Request.getEncryptionPublicKey(keyFromRegistry));
    }

    private static /* synthetic */ void lambda$extractAuthorizationParams$1(Map params, MatchResult mr) {
        System.out.println(mr.group());
        params.put(mr.group(1), mr.group(3));
    }
}

