/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.beckn;

import com.venky.core.util.ObjectHolder;
import in.succinct.beckn.BecknAware;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public class BecknObject
extends BecknAware<JSONObject> {
    private final Map<String, ObjectHolder<BecknAware>> attributeMap = new HashMap<String, ObjectHolder<BecknAware>>();
    public static final DateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public BecknObject() {
        this(new JSONObject());
    }

    public BecknObject(String payload) {
        super(payload);
        if (!(this.getInner() instanceof JSONObject)) {
            throw new RuntimeException("Payload not correct format");
        }
    }

    public BecknObject(JSONObject object) {
        super(object);
    }

    public <T extends BecknAware> T get(Class<T> clazz, String name) {
        return this.get(clazz, name, false);
    }

    public <T extends BecknAware> T get(Class<T> clazz, String name, boolean createIfAbsent) {
        if (this.attributeMap.containsKey(name)) {
            return (T)((BecknAware)this.attributeMap.get(name).get());
        }
        JSONObject inner = (JSONObject)this.getInner();
        Object clazzInner = (JSONAware)inner.get((Object)name);
        try {
            BecknAware t = null;
            if (clazzInner != null || createIfAbsent) {
                t = (BecknAware)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (clazzInner != null) {
                    t.setInner(clazzInner);
                } else {
                    clazzInner = t.getInner();
                    inner.put((Object)name, clazzInner);
                }
            }
            this.attributeMap.put(name, (ObjectHolder<BecknAware>)new ObjectHolder(t));
            return (T)t;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T> T get(String key) {
        return (T)((JSONObject)this.getInner()).get((Object)key);
    }

    public <T> T get(String key, T returnIfNull) {
        T ret = this.get(key);
        return ret != null ? ret : returnIfNull;
    }

    public <T extends BecknAware> void set(String key, T value) {
        this.set(key, (JSONAware)value.getInner());
    }

    public void set(String key, JSONAware value) {
        ((JSONObject)this.getInner()).put((Object)key, (Object)value);
    }

    public void set(String key, String value) {
        ((JSONObject)this.getInner()).put((Object)key, (Object)value);
    }

    public void set(String key, boolean value) {
        ((JSONObject)this.getInner()).put((Object)key, (Object)value);
    }

    public void set(String key, Date date, DateFormat format) {
        this.set(key, format.format(date));
    }

    public void set(String key, Double value) {
        ((JSONObject)this.getInner()).put((Object)key, (Object)value);
    }

    public void set(String key, int value) {
        ((JSONObject)this.getInner()).put((Object)key, (Object)value);
    }

    public Date getDate(String key, DateFormat format) {
        String value = (String)this.get(key);
        if (value == null) {
            return null;
        }
        try {
            return format.parse(value);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public double getDouble(String key) {
        return Double.valueOf(String.valueOf(this.get(key, 0.0)));
    }

    public int getInteger(String key) {
        return Integer.valueOf(String.valueOf(this.get(key, 0)));
    }

    public long getLong(String key) {
        return Long.valueOf(String.valueOf(this.get(key, 0L)));
    }

    public boolean getBoolean(String key) {
        return Boolean.valueOf(String.valueOf(this.get(key, false)));
    }

    static {
        TIMESTAMP_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

