/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.beckn;

import in.succinct.beckn.BecknAware;
import in.succinct.beckn.BecknObject;
import java.lang.reflect.ParameterizedType;
import java.util.Comparator;
import java.util.Iterator;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class BecknObjects<T>
extends BecknAware<JSONArray>
implements Iterable<T> {
    Class<T> clazz;

    public BecknObjects() {
        this(new JSONArray());
    }

    public BecknObjects(JSONArray value) {
        super(value);
        ParameterizedType pt = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.clazz = (Class)pt.getActualTypeArguments()[0];
    }

    public BecknObjects(String payload) {
        super(payload);
        ParameterizedType pt = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.clazz = (Class)pt.getActualTypeArguments()[0];
    }

    public void add(T t) {
        if (t instanceof BecknObject) {
            ((JSONArray)this.getInner()).add(((BecknObject)t).getInner());
        } else {
            ((JSONArray)this.getInner()).add(t);
        }
    }

    public void remove(T t) {
        if (t instanceof BecknObject) {
            ((JSONArray)this.getInner()).remove(((BecknObject)t).getInner());
        } else {
            ((JSONArray)this.getInner()).remove(t);
        }
    }

    public T get(int index) {
        Object element = ((JSONArray)this.getInner()).get(index);
        try {
            T t;
            if (BecknObject.class.isAssignableFrom(this.clazz)) {
                t = this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                ((BecknObject)t).setInner((JSONObject)element);
            } else {
                t = this.clazz.getConstructor(new Class[0]).newInstance(String.valueOf(element));
            }
            return t;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public int size() {
        return ((JSONArray)this.getInner()).size();
    }

    public boolean equals(Object o) {
        if (o != null && this.getClass() == o.getClass()) {
            BecknObjects other = (BecknObjects)o;
            return other.clazz == this.clazz && other.getInner().equals(this.getInner());
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < BecknObjects.this.size();
            }

            @Override
            public T next() {
                return BecknObjects.this.get(this.i++);
            }
        };
    }

    public T min(Comparator<T> comparator) {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        T min = this.get(0);
        for (int i = 1; i < size; ++i) {
            T t = this.get(i);
            if (comparator.compare(min, t) <= 0) continue;
            min = t;
        }
        return min;
    }
}

