/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.beckn;

import in.succinct.beckn.BecknObject;
import in.succinct.beckn.Time;
import java.util.HashSet;
import java.util.Set;

public class Payment
extends BecknObject {
    static final Set<String> TL_METHODS = new HashSet<String>(){
        {
            this.add("http/get");
            this.add("http/post");
        }
    };
    static final Set<String> TYPES = new HashSet<String>(){
        {
            this.add("ON-ORDER");
            this.add("PRE-FULFILLMENT");
            this.add("ON-FULFILLMENT");
            this.add("POST-FULFILLMENT");
        }
    };
    static final Set<String> STATUSES = new HashSet<String>(){
        {
            this.add("PAID");
            this.add("NOT-PAID");
        }
    };

    public String getUri() {
        return (String)this.get("uri");
    }

    public void setUri(String uri) {
        this.set("uri", uri);
    }

    public String getTlMethod() {
        return (String)this.get("tl_method");
    }

    public void setTlMethod(String tl_method) {
        if (!TL_METHODS.contains(tl_method)) {
            throw new IllegalArgumentException();
        }
        this.set("tl_method", tl_method);
    }

    public Params getParams() {
        return this.get(Params.class, "params");
    }

    public void setParams(Params params) {
        this.set("params", params);
    }

    public String getType() {
        return (String)this.get("type");
    }

    public void setType(String type) {
        if (!TYPES.contains(type)) {
            throw new IllegalArgumentException();
        }
        this.set("type", type);
    }

    public String getStatus() {
        return (String)this.get("status");
    }

    public void setStatus(String status) {
        if (!STATUSES.contains(status)) {
            throw new IllegalArgumentException();
        }
        this.set("status", status);
    }

    public Time getTime() {
        return this.get(Time.class, "time");
    }

    public void setTime(Time time) {
        this.set("time", time);
    }

    public static class Params
    extends BecknObject {
        public String getTransactionId() {
            return (String)this.get("transaction_id");
        }

        public void setTransactionId(String transaction_id) {
            this.set("transaction_id", transaction_id);
        }

        public double getAmount() {
            return this.getDouble("amount");
        }

        public void setAmount(double amount) {
            this.set("amount", String.valueOf(amount));
        }

        public String getCurrency() {
            return (String)this.get("currency");
        }

        public void setCurrency(String currency) {
            this.set("currency", currency);
        }
    }
}

