/*
 * Decompiled with CFR 0.152.
 */
package in.tombo.ponto;

import in.tombo.ponto.MethodType;
import in.tombo.ponto.Node;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Properties;
import javax.lang.model.SourceVersion;

public enum KeyStyle {
    Flat{

        @Override
        public void writeMethods(PrintWriter pw, Properties properties) {
            for (Object key : properties.keySet()) {
                pw.println();
                String keyString = key.toString();
                MethodType type = MethodType.findMethodType(keyString);
                String methodName = keyString.replace('.', '_').replaceFirst(String.format("_%s\\Z", type.getMethodKey()), "");
                pw.print(KeyStyle.indent(1));
                pw.println(type.toMethodString(KeyStyle.escapedMethodName(methodName), keyString));
            }
        }
    }
    ,
    Hierarchical{

        @Override
        public void writeMethods(PrintWriter pw, Properties properties) {
            Node root = new Node(null, "");
            for (Object key : properties.keySet()) {
                String keyString = key.toString();
                root.addKeyString(keyString);
            }
            this.writeNode(pw, root, 1);
        }

        private void writeNode(PrintWriter pw, Node node, int depth) {
            for (Map.Entry<String, MethodType> method : node.getMethods().entrySet()) {
                pw.println();
                pw.print(KeyStyle.indent(depth));
                String fullName = node.getFullName();
                String keyName = method.getKey();
                if (!fullName.isEmpty()) {
                    keyName = String.format("%s.%s", fullName, method.getKey());
                }
                if (method.getValue() != MethodType.STRING) {
                    keyName = String.format("%s.%s", keyName, method.getValue().getMethodKey());
                }
                pw.println(method.getValue().toMethodString(KeyStyle.escapedMethodName(method.getKey()), keyName));
            }
            for (Node child : node.getChilds()) {
                pw.println();
                pw.print(KeyStyle.indent(depth));
                pw.println(String.format("public static class %s {", child.getName()));
                this.writeNode(pw, child, depth + 1);
                pw.print(KeyStyle.indent(depth));
                pw.println("}");
            }
        }
    };


    public abstract void writeMethods(PrintWriter var1, Properties var2);

    private static String escapedMethodName(String methodName) {
        if (!SourceVersion.isName(methodName)) {
            return "_" + methodName;
        }
        return methodName;
    }

    private static String indent(int depth) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            buf.append("  ");
        }
        return buf.toString();
    }
}

