/*
 * Decompiled with CFR 0.152.
 */
package in.tombo.ponto;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesService {
    private Logger logger;
    private String[] filePaths;
    private String envValue;
    private Properties properties;
    private Properties envProperties;

    public PropertiesService(String loggerName, String envValue, String ... filePaths) {
        this.logger = LoggerFactory.getLogger((String)loggerName);
        this.envValue = envValue;
        this.filePaths = filePaths;
        this.loadProperties();
        this.loggingSettings();
    }

    public String getProperties(String keyString) {
        if (this.envProperties.containsKey(keyString)) {
            this.logger.debug("get key env:{}, key:{}", (Object)this.envValue, (Object)keyString);
            return this.envProperties.getProperty(keyString);
        }
        this.logger.debug("get key env:default, key:{}", (Object)keyString);
        return this.properties.getProperty(keyString);
    }

    private void loadProperties() {
        this.envProperties = new Properties();
        this.properties = new Properties();
        for (String filePath : this.filePaths) {
            this.loadProperty(filePath);
        }
    }

    private void loggingSettings() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Avairable property keys.");
            for (Object keyObj : this.properties.keySet()) {
                Properties p;
                String useProp;
                String keyStr = (String)keyObj;
                if (this.envProperties.containsKey(keyStr)) {
                    useProp = this.envValue;
                    p = this.envProperties;
                } else {
                    useProp = "default";
                    p = this.properties;
                }
                this.logger.info("\tenv:{}\tkey:{}\tvalue:{}", new Object[]{useProp, keyStr, p.get(keyStr)});
            }
        }
    }

    private void loadProperty(String filePath) {
        block7: {
            boolean isXml = filePath.endsWith(".xml");
            String envFilePath = this.getEnvFilePath(filePath);
            try {
                if (isXml) {
                    try {
                        this.envProperties.loadFromXML(this.getInputStream(envFilePath));
                        this.logger.info("properties file {} is loaded.", (Object)envFilePath);
                    }
                    catch (IOException e) {
                        this.logger.info("env properties file {} is not found.", (Object)envFilePath);
                    }
                    this.properties.loadFromXML(this.getInputStream(filePath));
                    this.logger.info("properties file {} is loaded.", (Object)filePath);
                    break block7;
                }
                try {
                    this.envProperties.load(this.getInputStream(envFilePath));
                    this.logger.info("properties file {} is loaded.", (Object)envFilePath);
                }
                catch (IOException e) {
                    this.logger.info("env properties file {} is not found.", (Object)envFilePath);
                }
                this.properties.load(this.getInputStream(filePath));
                this.logger.info("properties file {} is loaded.", (Object)filePath);
            }
            catch (IOException e) {
                this.logger.error("properties file {} is not found.", (Object)filePath);
                throw new RuntimeException(String.format("properties file %s is not found.", filePath));
            }
        }
    }

    private String getEnvFilePath(String filePath) {
        int lastDotIndex = filePath.lastIndexOf(".");
        String pre = filePath.substring(0, lastDotIndex);
        String post = filePath.substring(lastDotIndex);
        return String.format("%s_%s%s", pre, this.envValue, post);
    }

    private InputStream getInputStream(String filePath) throws IOException {
        InputStream in = filePath.startsWith("classpath:") ? ClassLoader.getSystemResourceAsStream(filePath.substring(10)) : (filePath.startsWith("file:") ? new FileInputStream(filePath.substring(5)) : ClassLoader.getSystemResourceAsStream(filePath));
        if (in == null) {
            throw new IOException("filePath " + filePath + " is invalid.");
        }
        return in;
    }
}

