/*
 * Decompiled with CFR 0.152.
 */
package in.tombo.ponto;

import in.tombo.ponto.ConstantResource;
import in.tombo.ponto.MethodType;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"in.tombo.ponto.ConstantResource"})
public class PontoProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(ConstantResource.class)) {
            ConstantResource annotation = element.getAnnotation(ConstantResource.class);
            Messager messager = this.processingEnv.getMessager();
            try {
                this.generateSource(annotation);
            }
            catch (IOException | IllegalArgumentException e) {
                messager.printMessage(Diagnostic.Kind.ERROR, e.toString());
                return false;
            }
        }
        return true;
    }

    private void generateSource(ConstantResource annotation) throws IOException {
        String[] propFiles = annotation.value();
        String packageName = annotation.packageName();
        String className = annotation.className();
        long scanPereod = annotation.scanPeriod();
        String encoding = annotation.encoding();
        Filer filer = this.processingEnv.getFiler();
        Properties properties = this.loadProperties(propFiles);
        List<String> errors = this.validation(properties);
        annotation.keyStyle().validateProperties(errors, properties);
        if (!errors.isEmpty()) {
            Messager messager = this.processingEnv.getMessager();
            for (String err : errors) {
                messager.printMessage(Diagnostic.Kind.ERROR, err);
            }
            throw new IllegalArgumentException("invalid propertie file.");
        }
        JavaFileObject source = filer.createSourceFile(String.format("%s.%s", packageName, className), new Element[0]);
        PrintWriter pw = new PrintWriter(source.openOutputStream(), true);
        if (!packageName.isEmpty()) {
            pw.println(String.format("package %s;", packageName));
        }
        pw.println(String.format("public class %s {", className));
        annotation.keyStyle().writeMethods(pw, properties);
        String envKey = annotation.envKey();
        String envDefault = annotation.envDefault();
        pw.println("  private static String getEnvValue() {");
        pw.println("    String env = System.getenv(\"" + envKey + "\");");
        pw.println("    if (env != null) {");
        pw.println("      return env;");
        pw.println("    }");
        pw.println("    return \"" + envDefault + "\";");
        pw.println("  }");
        pw.println("  private static String[] propertyFilePaths = new String[] {");
        for (String propFile : propFiles) {
            pw.printf("    \"%s\",\n", propFile);
        }
        pw.println("  };");
        pw.printf("  private static in.tombo.ponto.PropertiesService pService = new in.tombo.ponto.PropertiesService(\"%s.%s\", %dL, getEnvValue(), \"%s\", propertyFilePaths);\n", packageName, className, scanPereod, encoding);
        pw.println("  public static java.util.Properties getProperties() {");
        pw.println("    return pService.getProperties();");
        pw.println("  }");
        pw.println("  private static String getProperty(String key) {");
        pw.println("    return pService.getProperty(key);");
        pw.println("  }");
        pw.println("}");
        pw.flush();
        pw.close();
    }

    private Properties loadProperties(String[] propFiles) throws IOException, InvalidPropertiesFormatException {
        Properties properties = new Properties();
        Filer filer = this.processingEnv.getFiler();
        for (String propFile : propFiles) {
            InputStream stream = filer.getResource(StandardLocation.CLASS_PATH, "", propFile).openInputStream();
            if (propFile.endsWith(".xml")) {
                properties.loadFromXML(stream);
                continue;
            }
            properties.load(stream);
        }
        return properties;
    }

    private List<String> validation(Properties properties) {
        ArrayList<String> errors = new ArrayList<String>();
        for (Object key : properties.keySet()) {
            String value;
            String keyStr = (String)key;
            MethodType methodType = MethodType.findMethodType(keyStr);
            if (methodType.isValid(value = properties.getProperty(keyStr))) continue;
            errors.add(String.format("invalid key. type[%s], format[%s], value[%s]", new Object[]{methodType, keyStr, value}));
        }
        return errors;
    }
}

