/*
 * Decompiled with CFR 0.152.
 */
package in.tombo.ponto;

import in.tombo.ponto.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Node {
    private Node parent = null;
    private List<Node> childs = new ArrayList<Node>();
    private Map<String, MethodType> methods = new HashMap<String, MethodType>();
    private String name;

    public Node(Node parent, String name) {
        if (parent == null) {
            return;
        }
        this.name = name;
        this.parent = parent;
        this.parent.childs.add(this);
    }

    public Node getParent() {
        return this.parent;
    }

    public List<Node> getChilds() {
        return this.childs;
    }

    public Map<String, MethodType> getMethods() {
        return this.methods;
    }

    public void addKeyString(String keyString) {
        String[] elems = keyString.split("\\.");
        this.addKeys(elems);
    }

    private void addKeys(String[] elems) {
        MethodType type;
        if (elems.length == 1) {
            this.methods.put(elems[0], MethodType.STRING);
            return;
        }
        if (elems.length == 2 && (type = MethodType.findMethodType(elems[1])) != MethodType.STRING) {
            this.methods.put(elems[0], type);
            return;
        }
        Node child = this.getChildsOrCreate(elems[0]);
        child.addKeys(Arrays.copyOfRange(elems, 1, elems.length));
    }

    private Node getChildsOrCreate(String name) {
        for (Node child : this.childs) {
            if (!child.name.equals(name)) continue;
            return child;
        }
        return new Node(this, name);
    }

    public String getFullName() {
        if (this.parent == null) {
            return "";
        }
        String parentFullName = this.parent.getFullName();
        if (parentFullName.isEmpty()) {
            return this.name;
        }
        return String.format("%s.%s", parentFullName, this.name);
    }

    public String getName() {
        return this.name;
    }
}

