/*
 * Decompiled with CFR 0.152.
 */
package in.tombo.ponto;

import in.tombo.ponto.MethodType;
import in.tombo.ponto.Node;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;

public enum KeyStyle {
    Flat{

        @Override
        public void writeMethods(PrintWriter pw, Properties properties) {
            for (Object key : properties.keySet()) {
                pw.println();
                String keyString = key.toString();
                MethodType type = MethodType.findMethodType(keyString);
                String methodName = keyString.replace('.', '_').replaceFirst(String.format("_%s\\Z", type.getMethodKey()), "");
                pw.println(1.commentString(keyString, properties.getProperty(keyString), 1));
                pw.print(KeyStyle.indent(1));
                pw.println(type.toMethodString("public static", KeyStyle.escapedMethodName(methodName), keyString));
            }
        }
    }
    ,
    Hierarchical{

        @Override
        public void writeMethods(PrintWriter pw, Properties properties) {
            Node root = new Node(null, "");
            for (Object key : properties.keySet()) {
                String keyString = key.toString();
                root.addKeyString(keyString);
            }
            this.writeNode(pw, root, 1, properties);
        }

        private void writeNode(PrintWriter pw, Node node, int depth, Properties properties) {
            for (Map.Entry<String, MethodType> method : node.getMethods().entrySet()) {
                String fullName = node.getFullName();
                String keyName = method.getKey();
                if (!fullName.isEmpty()) {
                    keyName = String.format("%s.%s", fullName, method.getKey());
                }
                if (method.getValue() != MethodType.STRING) {
                    keyName = String.format("%s.%s", keyName, method.getValue().getMethodKey());
                }
                pw.println();
                pw.println(2.commentString(keyName, properties.getProperty(keyName), depth));
                pw.print(KeyStyle.indent(depth));
                pw.println(method.getValue().toMethodString("public static", KeyStyle.escapedMethodName(method.getKey()), keyName));
            }
            for (Node child : node.getChilds()) {
                pw.println();
                pw.print(KeyStyle.indent(depth));
                pw.println(String.format("public static class %s {", KeyStyle.escapedClassName(child.getName())));
                this.writeNode(pw, child, depth + 1, properties);
                pw.print(KeyStyle.indent(depth));
                pw.println("}");
            }
        }
    }
    ,
    Bean{

        @Override
        public void validateProperties(List<String> errors, Properties properties) {
            Node root = new Node(null, "");
            for (Object key : properties.keySet()) {
                String keyString = key.toString();
                root.addKeyString(keyString);
            }
            this.validateNode(errors, root);
        }

        private void validateNode(List<String> errors, Node node) {
            HashSet<String> parentKeys = new HashSet<String>();
            for (Map.Entry<String, MethodType> method : node.getMethods().entrySet()) {
                parentKeys.add(method.getKey());
            }
            for (Node child : node.getChilds()) {
                if (parentKeys.contains(child.getName())) {
                    errors.add(String.format("If using Bean Style, can not assign a value to the parent key [%s].", child.getFullName()));
                }
                this.validateNode(errors, child);
            }
        }

        @Override
        public void writeMethods(PrintWriter pw, Properties properties) {
            Node root = new Node(null, "");
            for (Object key : properties.keySet()) {
                String keyString = key.toString();
                root.addKeyString(keyString);
            }
            this.writeNode(pw, root, 1, properties);
        }

        private void writeNode(PrintWriter pw, Node node, int depth, Properties properties) {
            for (Map.Entry<String, MethodType> method : node.getMethods().entrySet()) {
                String fullName = node.getFullName();
                String keyName = method.getKey();
                if (!fullName.isEmpty()) {
                    keyName = String.format("%s.%s", fullName, method.getKey());
                }
                if (method.getValue() != MethodType.STRING) {
                    keyName = String.format("%s.%s", keyName, method.getValue().getMethodKey());
                }
                pw.println();
                pw.println(3.commentString(keyName, properties.getProperty(keyName), depth));
                pw.print(KeyStyle.indent(depth));
                pw.println(method.getValue().toMethodString("public", KeyStyle.beanGetterName(method.getKey(), method.getValue()), keyName));
            }
            for (Node child : node.getChilds()) {
                String childName = child.getName();
                pw.println();
                pw.print(KeyStyle.indent(depth));
                pw.println(String.format("public %s %s() { return new %s(); }", KeyStyle.escapedClassName(childName), KeyStyle.beanGetterName(childName), KeyStyle.escapedClassName(childName)));
                pw.println();
                pw.print(KeyStyle.indent(depth));
                pw.println(String.format("public static class %s {", KeyStyle.escapedClassName(childName)));
                this.writeNode(pw, child, depth + 1, properties);
                pw.print(KeyStyle.indent(depth));
                pw.println("}");
            }
        }
    };

    public static final String commentTemplate = "----indent----/**\n----indent---- * Key<br>\n----indent---- * <pre>%s</pre><br>\n----indent---- * Value<br>\n----indent---- * <pre>%s</pre>\n----indent---- */";
    private static final Pattern upperCamelConvertionPattern;
    private static final Pattern snakeToCamelPattern;

    public void validateProperties(List<String> errors, Properties properties) {
    }

    public static String commentString(String key, String value, int depth) {
        return String.format(commentTemplate.replaceAll("----indent----", KeyStyle.indent(depth)), key, value);
    }

    public abstract void writeMethods(PrintWriter var1, Properties var2);

    private static String escapedMethodName(String methodName) {
        return KeyStyle.escapedName(methodName);
    }

    private static String escapedClassName(String className) {
        return KeyStyle.escapedName(className);
    }

    private static String escapedName(String name) {
        if (!SourceVersion.isName(name)) {
            return "_" + name;
        }
        return name;
    }

    private static String beanGetterName(String propertyName) {
        return KeyStyle.beanGetterName(propertyName, null);
    }

    private static String beanGetterName(String propertyName, MethodType methodType) {
        Matcher m;
        if (upperCamelConvertionPattern.matcher(propertyName).matches()) {
            propertyName = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        }
        while ((m = snakeToCamelPattern.matcher(propertyName)).find()) {
            String group = m.group(1);
            propertyName = propertyName.replace("_" + group, group.toUpperCase());
        }
        String prefix = methodType == MethodType.BOOLEAN ? "is" : "get";
        return prefix + propertyName;
    }

    private static String indent(int depth) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            buf.append("  ");
        }
        return buf.toString();
    }

    static {
        upperCamelConvertionPattern = Pattern.compile("\\A.[a-z].*");
        snakeToCamelPattern = Pattern.compile("_([a-zA-Z])");
    }
}

