/*
 * Decompiled with CFR 0.152.
 */
package in.tombo.ponto;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.regex.Pattern;

public enum MethodType {
    STRING{

        @Override
        public String getMethodKey() {
            return null;
        }

        @Override
        public String toMethodString(String modifier, String escapedMethodName, String keyName) {
            return String.format("%s String %s() { return getProperty(\"%s\"); }", modifier, escapedMethodName, keyName);
        }

        @Override
        public boolean isValid(String property) {
            return true;
        }
    }
    ,
    REGEXP{

        @Override
        public String getMethodKey() {
            return "_regexp";
        }

        @Override
        public String toMethodString(String modifier, String escapedMethodName, String keyName) {
            return String.format("%s java.util.regex.Pattern %s() { return java.util.regex.Pattern.compile(getProperty(\"%s\")); }", modifier, escapedMethodName, keyName);
        }

        @Override
        public boolean isValid(String property) {
            try {
                Pattern.compile(property);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
    ,
    INTEGER{

        @Override
        public String getMethodKey() {
            return "_int";
        }

        @Override
        public String toMethodString(String modifier, String escapedMethodName, String keyName) {
            return String.format("%s int %s() { return Integer.valueOf(getProperty(\"%s\")); }", modifier, escapedMethodName, keyName);
        }

        @Override
        public boolean isValid(String property) {
            try {
                Integer.valueOf(property);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
    ,
    LONG{

        @Override
        public String getMethodKey() {
            return "_long";
        }

        @Override
        public String toMethodString(String modifier, String escapedMethodName, String keyName) {
            return String.format("%s long %s() { return Long.valueOf(getProperty(\"%s\")); }", modifier, escapedMethodName, keyName);
        }

        @Override
        public boolean isValid(String property) {
            try {
                Long.valueOf(property);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
    ,
    FLOAT{

        @Override
        public String getMethodKey() {
            return "_float";
        }

        @Override
        public String toMethodString(String modifier, String escapedMethodName, String keyName) {
            return String.format("%s float %s() { return Float.valueOf(getProperty(\"%s\")); }", modifier, escapedMethodName, keyName);
        }

        @Override
        public boolean isValid(String property) {
            try {
                Float.valueOf(property);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
    ,
    DOUBLE{

        @Override
        public String getMethodKey() {
            return "_double";
        }

        @Override
        public String toMethodString(String modifier, String escapedMethodName, String keyName) {
            return String.format("%s double %s() { return Double.valueOf(getProperty(\"%s\")); }", modifier, escapedMethodName, keyName);
        }

        @Override
        public boolean isValid(String property) {
            try {
                Double.valueOf(property);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
    ,
    BOOLEAN{

        @Override
        public String getMethodKey() {
            return "_boolean";
        }

        @Override
        public String toMethodString(String modifier, String escapedMethodName, String keyName) {
            StringBuilder buf = new StringBuilder();
            buf.append("%s boolean %s() { ");
            buf.append("String p = (getProperty(\"%s\")); ");
            buf.append("if (\"true\".equalsIgnoreCase(p)) {return true;} ");
            buf.append("if (\"false\".equalsIgnoreCase(p)) {return false;} ");
            buf.append("throw new RuntimeException(\"%s is showuld be true or false.\"); ");
            buf.append("}");
            return String.format(buf.toString(), modifier, escapedMethodName, keyName, keyName);
        }

        @Override
        public boolean isValid(String property) {
            return "true".equalsIgnoreCase(property) || "false".equalsIgnoreCase(property);
        }
    }
    ,
    DATE{
        private static final String DATE_FORMAT = "yyyy-MM-dd";

        @Override
        public String getMethodKey() {
            return "_date";
        }

        @Override
        public String toMethodString(String modifier, String escapedMethodName, String keyName) {
            return String.format("%s java.util.Date %s() { try { return new java.text.SimpleDateFormat(\"%s\").parse(getProperty(\"%s\")); } catch (Exception e) { throw new RuntimeException(e); } }", modifier, escapedMethodName, DATE_FORMAT, keyName);
        }

        @Override
        public boolean isValid(String property) {
            try {
                new SimpleDateFormat(DATE_FORMAT).parse(property);
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }
    }
    ,
    TIMESTAMP{
        private static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";

        @Override
        public String getMethodKey() {
            return "_timestamp";
        }

        @Override
        public String toMethodString(String modifier, String escapedMethodName, String keyName) {
            return String.format("%s java.util.Date %s() { try { return new java.text.SimpleDateFormat(\"%s\").parse(getProperty(\"%s\")); } catch (Exception e) { throw new RuntimeException(e); } }", modifier, escapedMethodName, TIMESTAMP_FORMAT, keyName);
        }

        @Override
        public boolean isValid(String property) {
            try {
                new SimpleDateFormat(TIMESTAMP_FORMAT).parse(property);
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }
    };


    public abstract String getMethodKey();

    public abstract String toMethodString(String var1, String var2, String var3);

    public abstract boolean isValid(String var1);

    public static MethodType findMethodType(String key) {
        String[] split = key.split("\\.");
        String lastKey = split[split.length - 1];
        for (MethodType type : MethodType.values()) {
            if (!lastKey.equals(type.getMethodKey())) continue;
            return type;
        }
        return STRING;
    }
}

