package `in`.trainman.book.trainmanbookingsdk

import okhttp3.*
import org.json.JSONObject
import java.io.IOException

object ConfigManager {
    private var call: Call? = null

    fun fetchData(canStartBookingFlow: (Boolean) -> Unit) {
        val client = Network.client
        val request = buildRequest()
        call?.cancel()
        call = client.newCall(request)
        call?.enqueue(object : Callback {
            override fun onResponse(call: Call, response: Response) {
                if (response.isSuccessful) {
                    response.body()?.let {
                        try {
                            val json = JSONObject(it.string())
                            updateConfig(json)
                            canStartBookingFlow.invoke(true)
                        }catch (e : Exception){ } finally {
                            Utils.initBaseURLs()
                        }
                    }
                }
            }

            override fun onFailure(call: Call, e: IOException) {}

        })

    }

    private fun updateConfig(json: JSONObject) {
        Utils.apply {
            if (json.has("web_production_url")) {
                WEB_PRODUCTION_URL = json.getString("web_production_url")
            }
            if (json.has("web_staging_url")) {
                WEB_STAGING_URL = json.getString("web_staging_url")
            }
            if (json.has("app_production_url")) {
                APP_PRODUCTION_URL = json.getString("app_production_url")
            }
            if (json.has("app_staging_url")) {
                APP_STAGING_URL = json.getString("app_staging_url")
            }
            if (json.has("auth_api_end_point")) {
                AUTH_API_END_POINT = json.getString("auth_api_end_point")
            }
        }

    }

    private fun buildRequest(): Request {
        return Request.Builder()
            .get()
            .url(Utils.CONFIG_API_URL)
            .build()
    }

}