package `in`.trainman.book.trainmanbookingsdk

import android.content.Context
import android.os.Build
import android.webkit.CookieManager
import android.webkit.CookieSyncManager

enum class APP_TYPE {
    PRODUCTION, STAGING
}

object Utils {
    var WEB_PRODUCTION_URL = "https://partner.trainman.in"
    var WEB_STAGING_URL = "http://dev.flightman.in:7999"
    var APP_PRODUCTION_URL = "https://partner.trainman.in"
    var APP_STAGING_URL = "http://dev.flightman.in:5999"
    var AUTH_API_END_POINT = "/services/account/authenticate/"

    var appType : APP_TYPE = APP_TYPE.STAGING
    val INITIALIZATION_ERROR = "One of the fields is empty, please initialize sdk by calling init(client_id : String, client_secret : String, client_token : String, app_type : String) properly."
    val INITIALIZATION_ERROR_CTX = "Activity context is null, please pass a valid context."
    val ERR_GENERIC = "Something went wrong please try again."
    val ERR_NETWORK = "Please check your internet connection."

    var CONFIG_API_URL = "https://partner.trainman.in/static/json/wls-constants.json"
    var APP_BASE_URL: String = if (appType == APP_TYPE.STAGING) APP_STAGING_URL else APP_PRODUCTION_URL

    var WEB_URL = if (appType == APP_TYPE.STAGING) WEB_STAGING_URL else WEB_PRODUCTION_URL

    fun initBaseURLs(){
        APP_BASE_URL = if (appType == APP_TYPE.STAGING) APP_STAGING_URL else APP_PRODUCTION_URL
        WEB_URL = if (appType == APP_TYPE.STAGING) WEB_STAGING_URL else WEB_PRODUCTION_URL
    }
    var VERSION = "1.0.0"

    @Suppress("DEPRECATION")
    fun clearCookies(context: Context) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP_MR1) {
            CookieManager.getInstance().removeAllCookies(null)
            CookieManager.getInstance().flush()
        } else {
            val cookieSyncMngr = CookieSyncManager.createInstance(context)
            cookieSyncMngr.startSync()
            val cookieManager = CookieManager.getInstance()
            cookieManager.removeAllCookie()
            cookieManager.removeSessionCookie()
            cookieSyncMngr.stopSync()
            cookieSyncMngr.sync()
        }
    }
}
