package `in`.trainman.book.trainmanbookingsdk

import `in`.trainman.book.R
import android.annotation.SuppressLint
import android.content.Context
import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.os.Message
import android.view.KeyEvent
import android.view.View
import android.view.ViewGroup
import android.webkit.*
import android.webkit.WebView.WebViewTransport
import android.widget.LinearLayout
import android.widget.ProgressBar
import androidx.appcompat.app.AppCompatActivity


class WebActivity : AppCompatActivity() {
    private var progress: ProgressBar? = null
    private var paymentContainer: LinearLayout? = null
    private var webView: WebView? = null
    private var onPaymentPage: Boolean = false
    private val TAG: String = "WebActivity"
    var tokenResponse: String? = null
    var paymentWebView: WebView? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_web)
        setUpViews()
        if (intent.hasExtra(TOKEN_RESPONSE)) {
            tokenResponse = intent.getStringExtra(TOKEN_RESPONSE)
        }
        setUpWebView()
        loadWebPage()
    }

    private fun setUpViews() {
        webView = findViewById(R.id.webView)
        paymentContainer = findViewById(R.id.paymentContainer)
        progress = findViewById(R.id.progress)
    }

    private fun loadWebPage() {
        webView?.loadUrl(Utils.WEB_URL + "/auth?tokenResponse=${tokenResponse}")
    }

    @Suppress("DEPRECATION")
    @SuppressLint("SetJavaScriptEnabled")
    private fun setUpWebView() {
        webView?.apply {
            settings.apply {
                javaScriptEnabled = true
                domStorageEnabled = true
                allowFileAccessFromFileURLs = true
                setSupportMultipleWindows(true);
                javaScriptCanOpenWindowsAutomatically = true
            }
            isHapticFeedbackEnabled = false
            clearWebView(this)
            webChromeClient = MyWebChromeClient(this@WebActivity)
            webViewClient = buildClient()
            addJavascriptInterface(MyJavaScriptInterface(this@WebActivity), "JavascriptInterface")

        }
    }

    private fun buildClient(): WebViewClient {
        return object : WebViewClient() {

            override fun shouldOverrideUrlLoading(
                view: WebView?,
                request: WebResourceRequest?
            ): Boolean {

                val uri: Uri? = request?.url
                val result = overrideUrl(uri)
                if(result)
                    return true

                if (request?.url?.path?.contains("after-booking") == true) {
                    hideLoader()
                }
                return super.shouldOverrideUrlLoading(view, request)
            }
        }
    }

    private fun overrideUrl(uri: Uri?): Boolean {
        try {
            when {
                uri?.scheme?.equals("whatsapp") == true -> {
                    val intent = Intent.parseUri(uri.toString(), Intent.URI_INTENT_SCHEME)
                    if (intent.resolveActivity(packageManager) != null)
                        startActivity(intent)
                    return true
                }
                uri?.scheme?.startsWith("tel") == true -> {
                    val tel = Intent(Intent.ACTION_DIAL, uri)
                    startActivity(tel)
                    return true
                }
                uri?.scheme?.startsWith("mailto") == true -> {
                    startActivity(
                        Intent(Intent.ACTION_VIEW, uri)
                    )
                    return true
                }
            }
        } catch (use: Exception) {

        }
        return false
    }

    class MyWebChromeClient(var activity: WebActivity) : WebChromeClient() {
        @SuppressLint("SetJavaScriptEnabled")
        override fun onCreateWindow(
            view: WebView?,
            isDialog: Boolean,
            isUserGesture: Boolean,
            resultMsg: Message?
        ): Boolean {
            activity.paymentContainer?.also { layout->
                layout.removeAllViews()
                activity.paymentWebView = activity.getNewWebView(activity).apply {
                    layout.addView(this)
                    activity.clearWebView(this)
                    // reinit payment WebView
                    layout.visibility = View.VISIBLE
                    settings.apply {
                        javaScriptEnabled = true
                        javaScriptCanOpenWindowsAutomatically = true
                        setSupportMultipleWindows(true)
                        useWideViewPort = false
                    }
                    webViewClient = object : WebViewClient() {
                        override fun shouldOverrideUrlLoading(
                            view: WebView?,
                            request: WebResourceRequest?
                        ): Boolean {

                            when {
                                url?.endsWith(".pdf") == true -> {
                                    activity.openUrlExternally(request?.url.toString())
                                    hideLayout(layout)
                                    return true
                                }
                                else -> {
                                    layout.visibility = View.GONE
                                    activity.onPaymentPage = false
                                }
                            }
                            return super.shouldOverrideUrlLoading(view, request)
                        }
                    }
                    val transport = resultMsg?.obj as WebViewTransport
                    transport.webView = this
                    resultMsg.sendToTarget()
                    activity.onPaymentPage = true
                }

            }



            return true
        }


        private fun hideLayout(layout : View){
            layout.visibility = View.GONE
            activity.onPaymentPage = false
        }

    }
    fun openUrlExternally(url : String) {
        startActivity(Intent(Intent.ACTION_VIEW, Uri.parse(url)))
    }

    fun getNewWebView(context: Context): WebView {
        val paymentWebView = WebView(context)
        paymentWebView.layoutParams = ViewGroup.LayoutParams(
            ViewGroup.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.MATCH_PARENT
        )
        return paymentWebView
    }

    private fun showLoader() {
        progress?.visibility = View.VISIBLE
    }

    private fun hideLoader() {
        progress?.visibility = View.GONE
    }

    internal class MyJavaScriptInterface(private val ctx: WebActivity) {

        @JavascriptInterface
        fun onBackPressed() {
            ctx.exitFlow()
        }

        @JavascriptInterface
        fun openUrlExternally(url : String) {
            ctx.openUrlExternally(url)
        }

    }

    private fun exitFlow() {
        val returnIntent = Intent()
        setResult(RESULT_OK, returnIntent)
        finish()
    }


    override fun onKeyDown(keyCode: Int, event: KeyEvent?): Boolean {
        if (event?.action == KeyEvent.ACTION_DOWN) {
            when (keyCode) {
                KeyEvent.KEYCODE_BACK -> {

                    if(onPaymentPage){
                        paymentWebView?.let { webView ->
                            if (webView.canGoBack()) {
                                webView.goBack()
                            } else {
                                webView.destroy()
                                paymentContainer?.visibility = View.GONE
                                onPaymentPage = false
                            }
                        }?: run {
                            onPaymentPage = false
                        }
                    }
                    else {
                        if (webView?.canGoBack() == true) {
                            webView?.goBack()
                        } else {
                            exitFlow()
                        }
                    }

                    return true
                }
            }
        }
        return super.onKeyDown(keyCode, event)

    }

    fun clearWebView(webView: WebView) {
        webView.apply {
            clearCache(true)
            clearHistory()
        }
        Utils.clearCookies(webView.context)
    }

}