package umun.entity.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import umun.core.constants.RestConstants;
import umun.core.constants.ValidationException;
import umun.entity.model.impl.NamedEntity;
import umun.entity.service.impl.NamedEntityCRUDService;
import umun.entity.templates.controller.EntityController;
import umun.entity.templates.service.EntityCRUDService;
import umun.iam.service.TokenService;

@RestController
@CrossOrigin("*")
@RequestMapping(RestConstants.V1 + "/named/entity")
public class NamedEntityController extends EntityController<NamedEntity> {

	@Autowired
	private NamedEntityCRUDService crudService;
	
	@Autowired
	public TokenService tokenService;
	
	@GetMapping
	public ResponseEntity<?> read(@RequestParam("entityName") String entityName) {
		// TODO: shall add a hook for validation to this and other mappings
		try {
			return ResponseEntity.ok(crudService.read(entityName));
		} catch (ValidationException e) {
			return ResponseEntity.status(e.getHttpStatus()).body(e.getMessage());
		}
	}

	@Override
	protected EntityCRUDService<NamedEntity> getCRUDService() {
		return crudService;
	}

}
