package umun.entity.model;

import java.util.Map;

import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import umun.entity.model.impl.EntityPrefImpl;

@JsonDeserialize(as = EntityPrefImpl.class)
@MappedSuperclass
public abstract class EntityPref {

	@Transient
	private String displayName;
	
	@Lob
	private String value;

	private PrefDataType datatype;

	private String remoteHideKey;

	@Transient
	private Map<String, String> options;

	@Transient
	private String group;
	
	public EntityPref(String value, PrefDataType datatype, String remoteHideKey, String displayName) {
		super();
		this.value = value;
		this.datatype = datatype;
		this.remoteHideKey = remoteHideKey;
		this.displayName = displayName;
	}

	public EntityPref() {
		super();
	}

	//this should be ID in sub class - to make composite ID
	public abstract String getKey();

	public abstract void setKey(String key);

	//this should be ID in sub class - to make composite ID
	public abstract Long getCategoryId();

	public abstract void setCategoryId(Long categoryId);

	public abstract EntityPrefCategory getCategory();

	public abstract void setCategory(EntityPrefCategory category);
	
	public String getCategoryDisplayName() {
		return this.getCategory().getDisplayName();
	}

	public String getCategoryName() {
		return this.getCategory().getName();
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public PrefDataType getDatatype() {
		return datatype;
	}

	public void setDatatype(PrefDataType datatype) {
		this.datatype = datatype;
	}

	public String getRemoteHideKey() {
		return remoteHideKey;
	}

	public void setRemoteHideKey(String remoteHideKey) {
		this.remoteHideKey = remoteHideKey;
	}

	public Map<String, String> getOptions() {
		return options;
	}

	public void setOptions(Map<String, String> options) {
		this.options = options;
	}

	public String getDisplayName() {
		return displayName;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	public String getGroup() {
		if(group == null) {
			return "General";
		}
		return group;
	}

	public void setGroup(String group) {
		this.group = group;
	}

}
