package umun.entity.model;

import umun.iam.model.Meta;

public class EntityPrefProp<ENTITY extends Meta, PREF extends EntityPref> {

	private EntityPrefFieldMapping<ENTITY, PREF> mappedField;

	private boolean isHiddenInCreateTemplate;
	private boolean isRequiredInCreateTemplate;
	private long numberOfOptionsAsList = 0;
	private TableEntityPrefFieldMapping<PREF> subEntityMappedField;
	private EntityFieldPrefMapping<ENTITY, PREF> fieldPrefMapping;

	public EntityPrefProp(EntityPrefFieldMapping<ENTITY, PREF> mappedField, boolean isHiddenInCreateTemplate,
			boolean isRequiredInCreateTemplate, long numberOfOptionsAsList,
			TableEntityPrefFieldMapping<PREF> subEntityMappedField,
			EntityFieldPrefMapping<ENTITY, PREF> fieldPrefMapping) {
		super();
		this.mappedField = mappedField;
		this.isHiddenInCreateTemplate = isHiddenInCreateTemplate;
		this.isRequiredInCreateTemplate = isRequiredInCreateTemplate;
		this.setSubEntityMappedField(subEntityMappedField);
		this.setFieldPrefMapping(fieldPrefMapping);
		this.setNumberOfOptionsAsList(numberOfOptionsAsList);
	}

	public EntityPrefFieldMapping<ENTITY, PREF> getMappedField() {
		return mappedField;
	}

	public void setMappedField(EntityPrefFieldMapping<ENTITY, PREF> mappedField) {
		this.mappedField = mappedField;
	}

	public boolean isHiddenInCreateTemplate() {
		return isHiddenInCreateTemplate;
	}

	public void setHiddenInCreateTemplate(boolean isHiddenInCreateTemplate) {
		this.isHiddenInCreateTemplate = isHiddenInCreateTemplate;
	}

	public boolean isRequiredInCreateTemplate() {
		return isRequiredInCreateTemplate;
	}

	public void setRequiredInCreateTemplate(boolean isRequiredInCreateTemplate) {
		this.isRequiredInCreateTemplate = isRequiredInCreateTemplate;
	}

	public TableEntityPrefFieldMapping<PREF> getSubEntityMappedField() {
		return subEntityMappedField;
	}

	public void setSubEntityMappedField(TableEntityPrefFieldMapping<PREF> subEntityMappedField) {
		this.subEntityMappedField = subEntityMappedField;
	}

	public EntityFieldPrefMapping<ENTITY, PREF> getFieldPrefMapping() {
		return fieldPrefMapping;
	}

	public void setFieldPrefMapping(EntityFieldPrefMapping<ENTITY, PREF> fieldPrefMapping) {
		this.fieldPrefMapping = fieldPrefMapping;
	}

	public long getNumberOfOptionsAsList() {
		return numberOfOptionsAsList;
	}

	public void setNumberOfOptionsAsList(long numberOfOptionsAsList) {
		this.numberOfOptionsAsList = numberOfOptionsAsList;
	}

}
