package umun.entity.model;

import umun.iam.model.Meta;

public class EntityPrefPropBuilder<ENTITY extends Meta, PREF extends EntityPref> {

	protected EntityPrefFieldMapping<ENTITY, PREF> mappedField;

	protected boolean isHiddenInCreateTemplate = false;
	protected boolean isRequiredInCreateTemplate = false;
	protected long numberOfOptionsAsList = 0;

	private TableEntityPrefFieldMapping<PREF> subEntityMappedField;
	private EntityFieldPrefMapping<ENTITY, PREF> fieldPrefMapping;

	public EntityPrefProp<ENTITY, PREF> build() {
		return new EntityPrefProp<ENTITY, PREF>(mappedField, isHiddenInCreateTemplate, isRequiredInCreateTemplate, numberOfOptionsAsList,
				subEntityMappedField, fieldPrefMapping);
	}

	public EntityPrefPropBuilder<ENTITY, PREF> mappedField(EntityPrefFieldMapping<ENTITY, PREF> mappedField) {
		this.mappedField = mappedField;
		return this;
	}

	public EntityPrefPropBuilder<ENTITY, PREF> hiddenInCreate(boolean isHidden) {
		this.isHiddenInCreateTemplate = isHidden;
		return this;
	}

	public EntityPrefPropBuilder<ENTITY, PREF> setNumberOfOptionsAsList(long numberOfOptionsAsList) {
		this.numberOfOptionsAsList = numberOfOptionsAsList;
		return this;
	}

	public EntityPrefPropBuilder<ENTITY, PREF> requiredInCreate(boolean isRequired) {
		this.isRequiredInCreateTemplate = isRequired;
		return this;
	}

	public EntityPrefPropBuilder<ENTITY, PREF> subEntityMappedField(
			TableEntityPrefFieldMapping<PREF> subEntityMappedField) {
		this.subEntityMappedField = subEntityMappedField;
		return this;
	}
	
	public EntityPrefPropBuilder<ENTITY, PREF> fieldPrefMapping(EntityFieldPrefMapping<ENTITY, PREF> fieldPrefMapping) {
		this.fieldPrefMapping = fieldPrefMapping;
		return this;
	}
}
