package umun.entity.model;

import java.util.Map;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;

import com.fasterxml.jackson.annotation.JsonIgnore;

import umun.entity.service.SystemDefaultPrefService;

@Entity
@IdClass(SystemDefaultPrefId.class)
public class SystemDefaultPref extends EntityPref {

	@Id
	@Column(name = "_key", columnDefinition = "varchar(100)")
	public String key;

	@Id
	@Column(name = "category_id")
	private Long categoryId;

	@OneToOne(cascade = CascadeType.DETACH)
	@JoinColumn(name = "category_id", insertable = false, updatable = false)
	@JsonIgnore
	public EntityPrefCategory category;

	public SystemDefaultPref() {
		super();
	}

	public SystemDefaultPref(String key, Long categoryId, EntityPrefCategory category, String value,
			PrefDataType datatype, String remoteHideKey, Map<String, String> options, String displayName,
			String group) {
		super(value, datatype, remoteHideKey, displayName);
		this.key = key;
		this.categoryId = categoryId;
		this.category = category;
		this.setOptions(options);
		this.setGroup(group);
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public Long getCategoryId() {
		return categoryId;
	}

	public void setCategoryId(Long categoryId) {
		this.categoryId = categoryId;
	}

	public EntityPrefCategory getCategory() {
		return category;
	}

	public void setCategory(EntityPrefCategory category) {
		this.category = category;
	}

	public String getEntityName() {
		return SystemDefaultPrefService.ENTITY_NAME;
	}

}
