package umun.entity.model.impl;

import java.io.Serializable;

import umun.entity.model.EntityPrefId;

public class NamedEntityPrefId extends EntityPrefId implements Serializable {

	private static final long serialVersionUID = 5997490980199838100L;

	public Long namedEntityId;
	public String key;
	public Long categoryId;

	public NamedEntityPrefId() {
		super();
	}

	public NamedEntityPrefId(Long orderId, String key, Long categoryId) {
		super();
		this.namedEntityId = orderId;
		this.key = key;
		this.categoryId = categoryId;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((categoryId == null) ? 0 : categoryId.hashCode());
		result = prime * result + ((key == null) ? 0 : key.hashCode());
		result = prime * result + ((namedEntityId == null) ? 0 : namedEntityId.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		NamedEntityPrefId other = (NamedEntityPrefId) obj;
		if (categoryId == null) {
			if (other.categoryId != null)
				return false;
		} else if (!categoryId.equals(other.categoryId))
			return false;
		if (key == null) {
			if (other.key != null)
				return false;
		} else if (!key.equals(other.key))
			return false;
		if (namedEntityId == null) {
			if (other.namedEntityId != null)
				return false;
		} else if (!namedEntityId.equals(other.namedEntityId))
			return false;
		return true;
	}

	public Long getNamedEntityId() {
		return namedEntityId;
	}

	public void setNamedEntityId(Long namedEntityId) {
		this.namedEntityId = namedEntityId;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public Long getCategoryId() {
		return categoryId;
	}

	public void setCategoryId(Long categoryId) {
		this.categoryId = categoryId;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}
}
