package umun.entity.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

import umun.core.constants.ValidationException;
import umun.core.util.DateUtil;
import umun.entity.model.EntityPrefCategory;
import umun.entity.repository.EntityPrefCategoryRepository;
import umun.iam.service.UserService;

@Service
public class EntityPrefCategoryService {

	@Autowired
	private EntityPrefCategoryRepository repository;

	@Autowired
	private UserService userService;

	public EntityPrefCategory findRootCategory(String entityName) {
		return readWithoutFail("root", entityName, "", "root");
	}

	public List<EntityPrefCategory> read(boolean isDeleted, String entityName) {
		return repository.findByDeletedAndEntityName(isDeleted, entityName);
	}

	public EntityPrefCategory readOrFail(long categoryId) throws ValidationException {
		EntityPrefCategory category = repository.findOne(categoryId);
		if (category == null) {
			throw new ValidationException("Category not found", HttpStatus.NOT_FOUND);
		}
		return category;
	}

	public EntityPrefCategory readWithoutFail(String name, String entityName, String remoteHideKey, String displayName) {
		EntityPrefCategory category = repository.findByNameAndAndEntityNameAndDeleted(name, entityName, false);
		if (category == null) {
			category = new EntityPrefCategory(name, entityName, remoteHideKey, displayName);
			category.setCreatedBy(userService.getSystemAdmin());
			category.setCreateTime(DateUtil.getCurrentTimeInIST());

			category = repository.saveAndFlush(category);
 		} else {
 			category.setDisplayName(displayName);
 			category = repository.saveAndFlush(category);
 		}

		return category;
	}

}
