package umun.entity.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import umun.core.constants.ValidationException;
import umun.entity.model.EntityPrefCategory;
import umun.entity.model.EntityPrefValue;
import umun.entity.model.PrefDataType;
import umun.entity.model.SystemDefaultPref;
import umun.entity.model.SystemDefaultPrefId;
import umun.entity.repository.EntityPrefRepository;
import umun.entity.repository.SystemDefaultPrefRepository;
import umun.entity.templates.service.EntityCRUDService;
import umun.iam.model.Meta;
import umun.iam.model.User;

@Service
public class SystemDefaultPrefService extends EntityPrefService<Meta, SystemDefaultPref, SystemDefaultPrefId> {

	/*
	 * For system default we are omitting the use of a entity
	 * 
	 * hence system preferences are independent of entity id.
	 * 
	 * Hence to read -> api/v1/pref/SystemDefault/{anyIdHere} shall work and shall
	 * return the same list
	 */

	public static final String ENTITY_NAME = "SystemDefault";

	@Autowired
	private SystemDefaultPrefRepository repository;

	private static Map<String, EntityPrefCategoryInterface<Meta, SystemDefaultPref, SystemDefaultPrefId, ?>> categoryServicesMap = new HashMap<>();

	private static Map<String, EntityPrefValue<Meta, SystemDefaultPref>> rootKeys = new HashMap<>();

	@Override
	protected EntityPrefRepository<SystemDefaultPref, SystemDefaultPrefId> getRepository() {
		return repository;
	}

	@Override
	protected Map<String, EntityPrefCategoryInterface<Meta, SystemDefaultPref, SystemDefaultPrefId, ?>> getCategoryServicesMap() {
		return categoryServicesMap;
	}

	@Override
	protected Map<String, EntityPrefValue<Meta, SystemDefaultPref>> getRootKeys() {
		return rootKeys;
	}

	@Override
	protected List<SystemDefaultPref> findByEntityAndCategoryOrderByKey(Meta entity, EntityPrefCategory rootCategory) {
		return repository.findByCategoryIdOrderByKey(rootCategory.getId());
	}

	@Override
	protected SystemDefaultPref createMissingRootPref(Meta entity, EntityPrefCategory rootCategory, String key,
			EntityPrefValue<Meta, SystemDefaultPref> entityPrefValue, Map<String, String> options, String group) {
		return new SystemDefaultPref(key, rootCategory.getId(), rootCategory, entityPrefValue.value,
				entityPrefValue.dataType, entityPrefValue.remoteHideKey, options, entityPrefValue.displayName, group);
	}

	@Override
	protected SystemDefaultPref createCategoryAsPref(Meta entity, EntityPrefCategory category)
			throws ValidationException {
		return new SystemDefaultPref(category.getName(), category.getId(), category, null, PrefDataType.category,
				getRemoteHideKey(category, category.getName()), getOptions(category, category.getName(), entity),
				category.getDisplayName(), getGroup(category, category.getName()));
	}

	@Override
	protected SystemDefaultPrefId createEntityPrefId(Meta entity, EntityPrefCategory category, String key) {
		return new SystemDefaultPrefId(key, category.getId());
	}

	@Override
	protected SystemDefaultPref createPref(Meta entity, EntityPrefCategory category, String key, String value,
			String remoteHideKey) throws ValidationException {
		return new SystemDefaultPref(key, category.getId(), category, value, getDataType(category, key), remoteHideKey,
				getOptions(category, key, entity), getDisplayname(key), getGroup(category, key));
	}

	@Override
	protected Meta findEntityOrFail(long entityId, User requestedBy) throws ValidationException {
		return new Meta(1L, "System Default");
	}

	@Override
	protected String getEntityName() {
		return ENTITY_NAME;
	}

	@Override
	protected EntityCRUDService<Meta> getCrudService() {
		return null;
	}

}
