package umun.entity.service.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

import umun.core.constants.ValidationException;
import umun.entity.model.impl.NamedEntity;
import umun.entity.repository.impl.NamedEntityCRUDRepository;
import umun.entity.templates.repository.EntityCRUDRepository;
import umun.entity.templates.service.EntityCRUDService;
import umun.entity.templates.service.EntityFilterService;
import umun.entity.templates.service.EntityService;
import umun.iam.model.User;

@Service
public class NamedEntityCRUDService extends EntityCRUDService<NamedEntity> {

	@Autowired
	private NamedEntityCRUDRepository repository;
	
	private static Set<String> subEntities = new HashSet<>();
	
	public String addSubEntity(String subEntityName) {
		//this should contain displayName, allow read and write permissions and other details as well
		if(subEntities.contains(subEntityName)) {
			System.err.println(String.format("Sub entity %s re-added in NamedEntityCRUD Service", subEntityName));
		} else {
			subEntities.add(subEntityName);
		}
		return subEntityName;
	}
	
	public List<NamedEntity> read(String subEntityName) throws ValidationException {
		validateRead(subEntityName);
		return repository.findByEntityNameAndDeletedOrderByName(subEntityName, false);
	}
	
	

	public NamedEntity readOrFail(String subEntityName, long id) throws ValidationException {
		validateRead(subEntityName);
		return repository.findByEntityNameAndIdAndDeletedOrderByName(subEntityName, id, false);
	}

	@Override
	protected EntityCRUDRepository<NamedEntity> getRepository() {
		return repository;
	}

	@Override
	protected String getEntityName() {
		return "NamedEntity";
	}

	@Override
	protected void validateCreate(NamedEntity entity, User createdBy) throws ValidationException {
		// do nothing here
	}

	@Override
	protected void validateUpdate(NamedEntity savedEntity, NamedEntity entity, User modifiedBy)
			throws ValidationException {
		// do nothing here
	}

	@Override
	protected void validateDelete(NamedEntity savedEntity, User modifiedBy) throws ValidationException {
		// do nothing here
	}

	@Override
	protected NamedEntity setValuesOnUpdate(NamedEntity savedEntity, NamedEntity entity, User modifiedBy)
			throws ValidationException {
		return savedEntity;
	}

	@Override
	protected NamedEntity setVariablesOnCreate(NamedEntity entity) throws ValidationException {
		return entity;
	}
	private void validateRead(String subEntityName) throws ValidationException {
		if(!subEntities.contains(subEntityName)) {
			throw new ValidationException(String.format("Sub entity %s not found", subEntityName), HttpStatus.NOT_FOUND);
		}		
	}

	@Override
	protected EntityService<NamedEntity, ?, ?> getEntityService() {
		//todo: check if something could be returned from here
		return null;
	}

	@Override
	protected EntityFilterService<NamedEntity> getFilterService() {
		//todo: check if something could be returned from here
		return null;
	}
}
