package umun.entity.templates.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

import umun.core.constants.RestConstants;
import umun.core.constants.ValidationException;
import umun.entity.templates.service.EntityCRUDService;
import umun.iam.model.Meta;
import umun.iam.service.TokenService;

public abstract class EntityController<ENTITY extends Meta>{
	
	@Autowired
	public TokenService tokenService;
	
	protected abstract EntityCRUDService<ENTITY> getCRUDService();

	@PostMapping
	public ResponseEntity<?> create(@RequestHeader(RestConstants.HEADER_AUTHORIZATION) String authHeader,
			@RequestBody ENTITY entity) {
		try {
			return ResponseEntity.ok(getCRUDService().create(entity, tokenService.getAdminToken(authHeader).getUser()));
		} catch (ValidationException e) {
			return ResponseEntity.status(e.getHttpStatus()).body(e.getMessage());
		}
	}
	
	@PutMapping("/{entityId}")
	public ResponseEntity<?> update(@RequestHeader(RestConstants.HEADER_AUTHORIZATION) String authHeader,
			@PathVariable("entityId") long entityId, @RequestBody ENTITY entity) {
		try {
			return ResponseEntity.ok(getCRUDService().update(entityId, entity, tokenService.getAdminToken(authHeader).getUser()));
		} catch (ValidationException e) {
			return ResponseEntity.status(e.getHttpStatus()).body(e.getMessage());
		}
	}

	@DeleteMapping("/{entityId}")
	public ResponseEntity<?> delete(
			@RequestHeader(RestConstants.HEADER_AUTHORIZATION) String authHeader,
			@PathVariable("entityId") long entityId) {
		try {
			return ResponseEntity.ok(getCRUDService().delete(entityId, 
					tokenService.getAdminToken(authHeader).getUser()));
		} catch (ValidationException e) {
			return ResponseEntity.status(e.getHttpStatus()).body(e.getMessage());
		}
	}

}
