package umun.entity.templates.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import umun.core.constants.ValidationException;
import umun.entity.templates.service.EntityCRUDService;
import umun.iam.model.Meta;
import umun.iam.service.UserService;
import umun.iam.service.UserServiceBasic;

public abstract class EntityControllerV2<ENTITY extends Meta>{
	
	@Autowired
	public UserService userService;
	
	
	protected abstract EntityCRUDService<ENTITY> getCRUDService();

	@PostMapping
	public ResponseEntity<?> create(Authentication authentication,
			@RequestBody ENTITY entity) {
		try {
			return ResponseEntity.ok(getCRUDService().create(entity, UserServiceBasic.getUser(authentication)));
		} catch (ValidationException e) {
			return ResponseEntity.status(e.getHttpStatus()).body(e.getMessage());
		}
	}
	
	@PutMapping("/{entityId}")
	public ResponseEntity<?> update(Authentication authentication,
			@PathVariable("entityId") long entityId, @RequestBody ENTITY entity) {
		try {
			return ResponseEntity.ok(getCRUDService().update(entityId, entity, UserServiceBasic.getUser(authentication)));
		} catch (ValidationException e) {
			return ResponseEntity.status(e.getHttpStatus()).body(e.getMessage());
		}
	}

	@DeleteMapping("/{entityId}")
	public ResponseEntity<?> delete(
			Authentication authentication,
			@PathVariable("entityId") long entityId) {
		try {
			return ResponseEntity.ok(getCRUDService().delete(entityId, 
					UserServiceBasic.getUser(authentication)));
		} catch (ValidationException e) {
			return ResponseEntity.status(e.getHttpStatus()).body(e.getMessage());
		}
	}

}
