package umun.entity.templates.repository;

import java.util.List;
import java.util.Set;

import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.repository.NoRepositoryBean;

@NoRepositoryBean
public interface EntityCRUDRepository<ENTITY> extends JpaRepository<ENTITY, Long>{

	List<ENTITY> findByDeletedOrderByNameDesc(boolean deleted);
	
	Slice<ENTITY> findByDeletedOrderByIdDesc(boolean deleted, Pageable page);

	Slice<ENTITY> findByDeletedAndIdInOrderByIdDesc(boolean delted, Set<Long> orderIds, Pageable page);

	List<ENTITY> findByDeletedAndIdInOrderByIdDesc(boolean delted, Set<Long> orderIds);
}
